/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.stanag4676.parser.util;

import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.locationtech.geowave.core.index.FloatCompareUtils;

public class EarthVector {
    public static final double X_EPSILON = 1.0E-9;
    public static final double Y_EPSILON = 1.0E-6;
    public static final double ECF_EPSILON = 1.0E-9;
    public static final int DEGREES = 0;
    public static final int RADIANS = 1;
    public static final double KMperNM = 1.852;
    public static final double KMperSM = 1.609344;
    public static final double FTperSM = 5280.0;
    public static final double SMperKM = 0.621371192237334;
    public static final double FTperKM = 3280.839895013123;
    public static final double INperKM = 39370.07874015748;
    public static final double YDperKM = 1093.6132983377076;
    public static final double KMperDegree = 111.12;
    public static final double NMperDegree = 60.0;
    public static final double REKM = 6378.137;
    public static final double CEKM = 40075.016685578485;
    public static final double RENM = 3443.918466523;
    public static final double POLAR_RENM = 3432.371659977;
    public static final double FLATTENING_FACTOR = 0.9966471893402117;
    public static final double EARTH_FLATTENING = 0.0033528106598350155;
    public static final double FLAT_COEFF1 = 0.006694379980349327;
    public static final double FLAT_COEFF2 = 0.9933056200196507;
    public static final double DPR = 57.29577951308232;
    public static final double RAD_1 = 0.0174532925199433;
    public static final double RAD_45 = 0.785398163;
    public static final double RAD_90 = 1.5707963267948966;
    public static final double RAD_180 = Math.PI;
    public static final double RAD_270 = 4.71238898038469;
    public static final double RAD_360 = Math.PI * 2;
    public static final double EARTH_ROT_RATE = 7.2921158553E-5;
    public static final double G = 0.0098066;
    public static final double GM = 398600.8;
    public static final double J2 = 0.00108263;
    public static final double J3 = -2.532152E-6;
    public static final double J4 = -1.610988E-6;
    public static final double J5 = -2.357857E-7;
    public static final int SEC_90 = 324000;
    public static final int SEC_180 = 648000;
    public static final int SEC_270 = 972000;
    public static final int SEC_360 = 1296000;
    protected double latitude;
    protected double longitude;
    protected double elevation;
    protected Vector3d ecfVector;
    protected boolean oblate = false;

    public static EarthVector fromDegrees(double lat, double lon) {
        return new EarthVector(lat, lon, 0);
    }

    public static EarthVector translateDegrees(double lat, double lon, Vector3d translation) {
        EarthVector result = EarthVector.fromDegrees(lat, lon);
        result.getVector().add((Tuple3d)translation);
        return new EarthVector(result.getVector());
    }

    public EarthVector() {
        this.latitude = 0.0;
        this.longitude = 0.0;
        this.elevation = 0.0;
        this.initVector();
    }

    public EarthVector(double inlat, double inlon) {
        this.latitude = inlat;
        this.longitude = inlon;
        this.elevation = 0.0;
        this.initVector();
    }

    public EarthVector(double inlat, double inlon, int units) {
        if (units == 0) {
            this.latitude = EarthVector.degToRad(inlat);
            this.longitude = EarthVector.degToRad(inlon);
        } else {
            this.latitude = inlat;
            this.longitude = inlon;
        }
        this.elevation = 0.0;
        this.initVector();
    }

    public EarthVector(double inlat, double inlon, double inelev) {
        this.latitude = inlat;
        this.longitude = inlon;
        this.elevation = inelev;
        this.initVector();
    }

    public EarthVector(double inlat, double inlon, double inelev, int units) {
        if (units == 0) {
            this.latitude = EarthVector.degToRad(inlat);
            this.longitude = EarthVector.degToRad(inlon);
        } else {
            this.latitude = inlat;
            this.longitude = inlon;
        }
        this.elevation = inelev;
        this.initVector();
    }

    public EarthVector(Point2d point) {
        this.latitude = point.y;
        this.longitude = point.x;
        this.elevation = 0.0;
        this.initVector();
    }

    public EarthVector(Point2d point, int units) {
        if (units == 0) {
            this.latitude = EarthVector.degToRad(point.y);
            this.longitude = EarthVector.degToRad(point.x);
        } else {
            this.latitude = point.y;
            this.longitude = point.x;
        }
        this.elevation = 0.0;
        this.initVector();
    }

    public EarthVector(Point2d point, double inelev) {
        this.latitude = point.y;
        this.longitude = point.x;
        this.elevation = inelev;
        this.initVector();
    }

    public EarthVector(Point2d point, double inelev, int units) {
        if (units == 0) {
            this.latitude = EarthVector.degToRad(point.y);
            this.longitude = EarthVector.degToRad(point.x);
        } else {
            this.latitude = point.y;
            this.longitude = point.x;
        }
        this.elevation = inelev;
        this.initVector();
    }

    public EarthVector(Vector3d vec) {
        double vra;
        Vector3d norm = new Vector3d(vec);
        norm.normalize();
        double sinlat = norm.z;
        double coslat = Math.sqrt(Math.abs(1.0 - sinlat * sinlat));
        this.latitude = Math.atan2(sinlat, coslat);
        if (Math.abs(coslat) <= 1.0E-6) {
            vra = 0.0;
        } else {
            double cosa = norm.x / coslat;
            double sina = norm.y / coslat;
            vra = Math.abs(cosa) < 1.0E-9 ? 1.5707963267948966 * this.sign(sina) : Math.atan2(sina, cosa);
        }
        this.longitude = vra;
        this.elevation = vec.length() > this.getEarthRadiusKM() ? vec.length() - this.getEarthRadiusKM() : 0.0;
        this.initVector();
    }

    public EarthVector(Vector3d vec, double inelev) {
        Vector3d norm = vec;
        norm.normalize();
        double sinlat = norm.z;
        double coslat = Math.sqrt(Math.abs(1.0 - sinlat * sinlat));
        this.latitude = Math.atan2(sinlat, coslat);
        double cosa = norm.x / coslat;
        double sina = norm.y / coslat;
        double vra = Math.abs(cosa) < 0.001 ? 1.5707963267948966 * this.sign(sina) : Math.atan2(sina, cosa);
        this.longitude = vra;
        this.elevation = inelev;
        this.initVector();
    }

    public EarthVector(EarthVector loc) {
        if (loc == null) {
            this.latitude = 0.0;
            this.longitude = 0.0;
            this.elevation = 0.0;
        } else {
            this.latitude = loc.getLatitude();
            this.longitude = loc.getLongitude();
            this.elevation = loc.getElevation();
        }
        this.initVector();
    }

    public void setCoord(EarthVector coord) {
        this.latitude = coord.getLatitude();
        this.longitude = coord.getLongitude();
        this.elevation = coord.getElevation();
        this.initVector();
    }

    public boolean epsilonEquals(EarthVector otherEv, double epsilon) {
        if (otherEv == null) {
            return false;
        }
        return this.ecfVector.epsilonEquals((Tuple3d)otherEv.ecfVector, epsilon);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EarthVector)) {
            return false;
        }
        EarthVector coord = (EarthVector)obj;
        return FloatCompareUtils.checkDoublesEqual((double)coord.getX(), (double)this.ecfVector.x) && FloatCompareUtils.checkDoublesEqual((double)coord.getY(), (double)this.ecfVector.y) && FloatCompareUtils.checkDoublesEqual((double)coord.getZ(), (double)this.ecfVector.z);
    }

    public int hashCode() {
        return this.ecfVector.hashCode();
    }

    protected void initVector() {
        double z;
        double x = Math.cos(this.latitude) * Math.cos(this.longitude) * this.getRadius();
        double y = Math.cos(this.latitude) * Math.sin(this.longitude) * this.getRadius();
        double sin_lat = Math.sin(this.latitude);
        if (this.oblate) {
            double ann = 6378.137 / Math.sqrt(1.0 - 0.006694379980349327 * sin_lat * sin_lat);
            z = sin_lat * (ann * 0.9933056200196507);
        } else {
            z = sin_lat * this.getRadius();
        }
        this.ecfVector = new Vector3d(x, y, z);
    }

    public static double normalizeLongitude(double lon) {
        double nLon = lon;
        if (nLon > 180.0) {
            nLon -= 360.0;
        } else if (nLon < -180.0) {
            nLon += 360.0;
        }
        return nLon;
    }

    public static double normalizeLatitude(double lat) {
        double nLat = lat;
        if (nLat > 90.0) {
            nLat = 90.0 - nLat % 90.0;
        } else if (nLat < -90.0) {
            nLat = -90.0 + Math.abs(nLat) % 90.0;
        }
        return nLat;
    }

    public void setOblate(boolean isOblate) {
        this.oblate = isOblate;
    }

    public boolean isOblate() {
        return this.oblate;
    }

    public static double degToRad(double deg) {
        return deg * 0.0174532925199433;
    }

    public static double radToDeg(double rad) {
        double deg;
        for (deg = rad * 57.29577951308232; deg > 180.0; deg -= 360.0) {
        }
        while (deg < -180.0) {
            deg += 360.0;
        }
        return deg;
    }

    public static double KMToNM(double km) {
        return km / 1.852;
    }

    public static double KMToSM(double km) {
        return km / 1.609344;
    }

    public static double NMToKM(double nm) {
        return nm * 1.852;
    }

    public static double SMToKM(double sm) {
        return sm * 1.609344;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLatitude(int units) {
        if (units == 0) {
            return EarthVector.radToDeg(this.latitude);
        }
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLongitude(int units) {
        if (units == 0) {
            return EarthVector.radToDeg(this.longitude);
        }
        return this.longitude;
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setLatitude(double inlat) {
        this.latitude = inlat;
        this.initVector();
    }

    public void setLatitude(double inlat, int units) {
        this.latitude = units == 0 ? EarthVector.degToRad(inlat) : inlat;
        this.initVector();
    }

    public void setLongitude(double inlon) {
        this.longitude = inlon;
        this.initVector();
    }

    public void setLongitude(double inlon, int units) {
        this.longitude = units == 0 ? EarthVector.degToRad(inlon) : inlon;
        this.initVector();
    }

    public void setElevation(double inelev) {
        this.elevation = inelev;
        this.initVector();
    }

    public Vector3d getVector() {
        return this.ecfVector;
    }

    public EarthVector setVector(Vector3d vec) {
        EarthVector loc = new EarthVector(vec);
        this.latitude = loc.getLatitude();
        this.longitude = loc.getLongitude();
        this.elevation = loc.getElevation();
        this.ecfVector = loc.getVector();
        return this;
    }

    public double getX() {
        return this.ecfVector.x;
    }

    public double getY() {
        return this.ecfVector.y;
    }

    public double getZ() {
        return this.ecfVector.z;
    }

    public Vector3d getUnitVector() {
        Vector3d unitVec = new Vector3d(this.ecfVector);
        unitVec.normalize();
        return unitVec;
    }

    public EarthVector[] makeGreatCircle(EarthVector endpoint) {
        return this.makeGreatCircleSegmentLength(endpoint, 100.0);
    }

    public EarthVector[] makeGreatCircleSegmentLength(EarthVector endpoint, double segmentLengthKM) {
        int segments = this.getNumGreatCircleSegments(endpoint, segmentLengthKM, false);
        return this.makeGreatCircleNumSegments(endpoint, segments, false);
    }

    public EarthVector[] makeGreatCircleSegmentLengthReverseDirection(EarthVector endpoint, double segmentLengthKM) {
        int segments = this.getNumGreatCircleSegments(endpoint, segmentLengthKM, true);
        return this.makeGreatCircleNumSegments(endpoint, segments, true);
    }

    public EarthVector[] makeGreatCircleNumSegments(EarthVector endpoint, int segments) {
        return this.makeGreatCircleNumSegments(endpoint, segments, false);
    }

    public EarthVector[] makeGreatCircleNumSegments(EarthVector endpoint, int segments, boolean reverseDirection) {
        double resolution = 1.0 / (double)segments;
        double fraction = 0.0;
        EarthVector[] points = new EarthVector[segments + 1];
        points[0] = new EarthVector(this);
        points[segments] = new EarthVector(endpoint);
        if (reverseDirection) {
            double reverseFactor = this.getDistanceReverseDirection(endpoint) / this.getDistance(endpoint);
            for (int i = 1; i < segments; ++i) {
                fraction = (double)i * resolution;
                points[i] = this.findPointReverseDirection(endpoint, fraction * reverseFactor);
            }
        } else {
            for (int i = 1; i < segments; ++i) {
                fraction = (double)i * resolution;
                points[i] = this.findPoint(endpoint, fraction);
            }
        }
        return points;
    }

    public EarthVector[] makeInterpolatedLineSegmentLength(EarthVector endpoint, double segmentLengthKM) {
        return this.makeInterpolatedLineSegmentLength(endpoint, segmentLengthKM, false);
    }

    public EarthVector[] makeInterpolatedLineSegmentLength(EarthVector endpoint, double segmentLengthKM, boolean reverseDirection) {
        int segments = this.getNumGreatCircleSegments(endpoint, segmentLengthKM, reverseDirection);
        return this.makeInterpolatedLineNumSegments(endpoint, segments, reverseDirection);
    }

    public EarthVector[] makeInterpolatedLineNumSegments(EarthVector endpoint, int segments) {
        return this.makeInterpolatedLineNumSegments(endpoint, segments, false);
    }

    public EarthVector[] makeInterpolatedLineNumSegments(EarthVector endpoint, int segments, boolean reverseDirection) {
        double resolution = 1.0 / (double)segments;
        EarthVector[] points = new EarthVector[segments + 1];
        points[0] = new EarthVector(this);
        points[segments] = new EarthVector(endpoint);
        double baseLat = points[0].getLatitude(0);
        double latStep = (points[segments].getLatitude(0) - baseLat) * resolution;
        double baseLon = points[0].getLongitude(0);
        double deltaLon = points[segments].getLongitude(0) - baseLon;
        double baseAlt = points[0].elevation;
        double altStep = (points[segments].elevation - baseAlt) * resolution;
        if (Math.abs(deltaLon) >= 0.0) {
            if (reverseDirection) {
                if (Math.abs(deltaLon) < 180.0) {
                    deltaLon = deltaLon > 0.0 ? (deltaLon -= 360.0) : (deltaLon += 360.0);
                }
            } else if (deltaLon > 180.0) {
                deltaLon = -360.0 + deltaLon;
            } else if (deltaLon < -180.0) {
                deltaLon = 360.0 + deltaLon;
            }
        }
        double lonStep = deltaLon * resolution;
        for (int i = 1; i < segments; ++i) {
            double lat = baseLat + (double)i * latStep;
            double lon = EarthVector.get180NormalizedLon(baseLon + (double)i * lonStep);
            double alt = baseAlt + (double)i * altStep;
            points[i] = new EarthVector(EarthVector.degToRad(lat), EarthVector.degToRad(lon), alt);
        }
        return points;
    }

    private static double get180NormalizedLon(double lon) {
        double newLon;
        for (newLon = lon; newLon < -180.0; newLon += 360.0) {
        }
        while (newLon > 180.0) {
            newLon -= 360.0;
        }
        return newLon;
    }

    public int getNumGreatCircleSegments(EarthVector endpoint, double segmentLengthKM) {
        return this.getNumGreatCircleSegments(endpoint, segmentLengthKM, false);
    }

    public int getNumGreatCircleSegments(EarthVector endpoint, double segmentLengthKM, boolean reverseDirection) {
        if (segmentLengthKM <= 0.0) {
            segmentLengthKM = 100.0;
        }
        double distance = reverseDirection ? this.getDistanceReverseDirection(endpoint) : this.getDistance(endpoint);
        return (int)(distance / segmentLengthKM) + 1;
    }

    public EarthVector findPoint(EarthVector nextCoord, double fraction) {
        if (this.equals(nextCoord)) {
            return new EarthVector(this);
        }
        Vector3d nextVector = nextCoord.getVector();
        Vector3d vec = new Vector3d();
        vec.cross(this.ecfVector, nextVector);
        double phi = fraction * Math.acos(this.ecfVector.dot(nextVector) / (this.ecfVector.length() * nextVector.length()));
        Vector3d output = this.rotate(vec, phi);
        output.normalize();
        double size = (nextVector.length() - this.ecfVector.length()) * fraction + this.ecfVector.length();
        output.scale(size);
        return new EarthVector(output);
    }

    public EarthVector findPointReverseDirection(EarthVector nextCoord, double fraction) {
        if (this.equals(nextCoord)) {
            return new EarthVector(this);
        }
        Vector3d nextVector = nextCoord.getVector();
        Vector3d vec = new Vector3d();
        vec.cross(this.ecfVector, nextVector);
        vec.negate();
        double phi = fraction * Math.acos(this.ecfVector.dot(nextVector) / (this.ecfVector.length() * nextVector.length()));
        Vector3d output = this.rotate(vec, phi);
        output.normalize();
        double size = (nextVector.length() - this.ecfVector.length()) * fraction + this.ecfVector.length();
        output.scale(size);
        return new EarthVector(output);
    }

    public Vector3d getNormalizedEarthTangentVector(double azimuth) {
        EarthVector nextEV = this.findPoint(1.0, azimuth);
        Vector3d deltaVec = new Vector3d();
        deltaVec.sub((Tuple3d)nextEV.getVector(), (Tuple3d)this.getVector());
        deltaVec.normalize();
        return deltaVec;
    }

    public EarthVector findPoint(double distanceKM, double azimuth) {
        EarthVector locNorth = new EarthVector(this);
        double distR = distanceKM / this.kmPerDegree() / 57.29577951308232;
        locNorth.setLatitude(locNorth.getLatitude() + distR);
        if (locNorth.getLatitude() > 1.5707963267948966) {
            locNorth.setLatitude(Math.PI - locNorth.getLatitude());
            locNorth.setLongitude(locNorth.getLongitude() + Math.PI);
        }
        Vector3d vec = locNorth.rotate(this.ecfVector, -azimuth);
        EarthVector newPoint = new EarthVector(vec);
        newPoint.setElevation(this.getElevation());
        return newPoint;
    }

    public EarthVector findPoint(double distanceKM, double azimuth, double elevAngle) {
        double lon = this.getLongitude();
        double lat = this.getLatitude();
        Vector3d eastVec = new Vector3d(1.0, 0.0, 0.0);
        Vector3d northVec = new Vector3d(0.0, 1.0, 0.0);
        double sinLon = Math.sin(lon);
        double cosLon = Math.cos(lon);
        double sinLat = Math.sin(lat);
        double cosLat = Math.cos(lat);
        Matrix3d enuToEcf = new Matrix3d();
        enuToEcf.m00 = -sinLon;
        enuToEcf.m01 = -(sinLat * cosLon);
        enuToEcf.m02 = cosLat * cosLon;
        enuToEcf.m10 = cosLon;
        enuToEcf.m11 = -(sinLat * sinLon);
        enuToEcf.m12 = cosLat * sinLon;
        enuToEcf.m20 = 0.0;
        enuToEcf.m21 = cosLat;
        enuToEcf.m22 = sinLat;
        enuToEcf.transform((Tuple3d)eastVec);
        enuToEcf.transform((Tuple3d)northVec);
        eastVec.normalize();
        northVec.normalize();
        northVec.scale(distanceKM);
        Matrix3d elevTrans = new Matrix3d();
        elevTrans.set(new AxisAngle4d(eastVec, elevAngle));
        elevTrans.transform((Tuple3d)northVec);
        Matrix3d azTrans = new Matrix3d();
        Vector3d unitEcf = new Vector3d(this.ecfVector);
        unitEcf.normalize();
        azTrans.set(new AxisAngle4d(unitEcf, azimuth));
        azTrans.transform((Tuple3d)northVec);
        Vector3d transformedEcf = new Vector3d();
        transformedEcf.add((Tuple3d)this.ecfVector, (Tuple3d)northVec);
        EarthVector transformedEv = new EarthVector(transformedEcf);
        return transformedEv;
    }

    public static double kmToRadians(double distKM, double latRad) {
        return distKM / EarthVector.kmPerDegree(latRad) / 57.29577951308232;
    }

    public static double kmToDegrees(double distKM, double latDeg) {
        return distKM / EarthVector.kmPerDegree(latDeg / 57.29577951308232);
    }

    public static double radianstoKM(double distRad, double latRad) {
        return distRad * EarthVector.kmPerDegree(latRad) * 57.29577951308232;
    }

    public static double degreestoKM(double distDeg, double latDeg) {
        return distDeg * EarthVector.kmPerDegree(latDeg / 57.29577951308232);
    }

    public double kmToRadians(double distKM) {
        return distKM / this.kmPerDegree() / 57.29577951308232;
    }

    public double kmToDegrees(double distKM) {
        return distKM / this.kmPerDegree();
    }

    public Vector3d rotate(Vector3d rotAxis, double angle) {
        Vector3d thisVec = new Vector3d(this.ecfVector);
        Vector3d axis = new Vector3d(rotAxis);
        axis.normalize();
        Matrix3d trans = new Matrix3d();
        trans.set(new AxisAngle4d(axis, angle));
        trans.transform((Tuple3d)thisVec);
        return thisVec;
    }

    public double getVectorDistanceKMSq(EarthVector loc) {
        Vector3d delta = this.getVector(loc);
        return delta.lengthSquared();
    }

    public double getDistance(EarthVector loc) {
        double dist = this.getEarthRadiusKM() * Math.acos(this.ecfVector.dot(loc.getVector()) / (this.ecfVector.length() * loc.getVector().length()));
        if (Double.isNaN(dist) || Double.isInfinite(dist)) {
            dist = 0.0;
        }
        return dist;
    }

    public double getDistanceReverseDirection(EarthVector loc) {
        double dist = this.getEarthRadiusKM() * (Math.PI * 2 - Math.acos(this.ecfVector.dot(loc.getVector()) / (this.ecfVector.length() * loc.getVector().length())));
        if (Double.isNaN(dist) || Double.isInfinite(dist)) {
            dist = 0.0;
        }
        return dist;
    }

    public double getSphereDistance(EarthVector loc) {
        return this.getEarthRadiusKM() * Math.acos(Math.sin(this.latitude) * Math.sin(loc.getLatitude()) + Math.cos(this.latitude) * Math.cos(loc.getLatitude()) * Math.cos(loc.getLongitude() - this.longitude));
    }

    public double getAzimuth(EarthVector loc) {
        EarthVector thisNorm = new EarthVector(this);
        thisNorm.setElevation(0.0);
        EarthVector otherNorm = new EarthVector(loc);
        otherNorm.setElevation(0.0);
        return thisNorm.internalGetAzimuth(otherNorm);
    }

    private double internalGetAzimuth(EarthVector loc) {
        boolean calcNorth;
        EarthVector locNorth = new EarthVector(this);
        double radInc = Math.max(0.0174532925199433, Math.abs(loc.getLatitude() - this.getLatitude()));
        boolean bl = calcNorth = this.latitude < loc.getLatitude();
        if (calcNorth) {
            locNorth.setLatitude(locNorth.getLatitude() + radInc);
        } else {
            locNorth.setLatitude(locNorth.getLatitude() - radInc);
        }
        Vector3d vecNorth = locNorth.getVector();
        vecNorth.sub((Tuple3d)this.ecfVector);
        Vector3d vecTemp = new Vector3d(loc.getVector());
        vecTemp.sub((Tuple3d)this.ecfVector);
        vecNorth.normalize();
        vecTemp.normalize();
        double azimuth = Math.acos(vecNorth.dot(vecTemp));
        if (!calcNorth) {
            azimuth = Math.PI - azimuth;
        }
        double deltaLon = Math.abs(loc.getLongitude() - this.longitude);
        if (loc.getLongitude() < this.longitude && deltaLon < Math.PI || loc.getLongitude() > this.longitude && deltaLon > Math.PI) {
            azimuth = Math.PI * 2 - azimuth;
        }
        return azimuth;
    }

    public Vector3d getVector(EarthVector loc) {
        Vector3d vecTemp = new Vector3d(loc.getVector());
        vecTemp.sub((Tuple3d)this.ecfVector);
        return vecTemp;
    }

    public double getRadius() {
        return this.elevation + this.getEarthRadiusKM();
    }

    public double getEarthRadiusKM() {
        return EarthVector.getEarthRadiusKM(this.latitude, this.oblate);
    }

    public static double getEarthRadiusKM(double lat, boolean flat) {
        double radiusAtEquatorKM = 6378.137;
        if (flat) {
            return 6356.752314276511 / Math.sqrt(1.0 - Math.cos(lat) * Math.cos(lat) * 0.0033528106598350155 * 1.996647189340165);
        }
        return 6378.137;
    }

    public static double kmPerDegree(double lat) {
        return Math.PI * 2 * EarthVector.getEarthRadiusKM(lat, false) / 360.0;
    }

    public double kmPerDegree() {
        return Math.PI * 2 * this.getEarthRadiusKM() / 360.0;
    }

    protected double sign(double x) {
        if (x < 0.0) {
            return -1.0;
        }
        if (x > 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    public String toString() {
        return this.getLatitude(0) + ", " + this.getLongitude(0);
    }

    public Point2d getPoint2d() {
        return new Point2d(this.getLongitude(0), this.getLatitude(0));
    }
}

