/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.stanag4676;

import com.google.common.io.BaseEncoding;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.ingest.hdfs.mapreduce.KeyValueData;
import org.locationtech.geowave.format.stanag4676.Stanag4676EventWritable;
import org.locationtech.geowave.format.stanag4676.image.ImageChipInfo;
import org.locationtech.geowave.format.stanag4676.image.ImageChipUtils;
import org.locationtech.geowave.format.stanag4676.parser.TrackReader;
import org.locationtech.geowave.format.stanag4676.parser.model.MissionFrame;
import org.locationtech.geowave.format.stanag4676.parser.model.MissionSummary;
import org.locationtech.geowave.format.stanag4676.parser.model.MissionSummaryMessage;
import org.locationtech.geowave.format.stanag4676.parser.model.ModalityType;
import org.locationtech.geowave.format.stanag4676.parser.model.MotionEventPoint;
import org.locationtech.geowave.format.stanag4676.parser.model.MotionImagery;
import org.locationtech.geowave.format.stanag4676.parser.model.NATO4676Message;
import org.locationtech.geowave.format.stanag4676.parser.model.ObjectClassification;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackClassification;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackEvent;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackMessage;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackPoint;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackRun;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKBWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IngestMessageHandler
implements TrackReader.ProcessMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(IngestMessageHandler.class);
    private final WKBWriter wkbWriter = new WKBWriter(3);
    private static final String DEFAULT_IMAGE_FORMAT = "jpg";
    private final List<KeyValueData<Text, Stanag4676EventWritable>> intermediateData = new ArrayList<KeyValueData<Text, Stanag4676EventWritable>>();

    public List<KeyValueData<Text, Stanag4676EventWritable>> getIntermediateData() {
        return this.intermediateData;
    }

    @Override
    public void notify(NATO4676Message msg) throws IOException, InterruptedException {
        MissionSummaryMessage missionSummaryMessage;
        MissionSummary missionSummary;
        String missionUUID;
        if (msg == null) {
            LOGGER.error("Received null msg");
            return;
        }
        if (msg instanceof TrackMessage) {
            TrackMessage trackMessage = (TrackMessage)msg;
            for (TrackEvent evt : trackMessage.getTracks()) {
                Object stream;
                if (evt.getPoints().size() <= 0) continue;
                String trackUuid = evt.getUuid().toString();
                missionUUID = evt.getMissionId();
                String comment = evt.getComment();
                if (missionUUID == null && comment != null) {
                    missionUUID = comment;
                }
                missionUUID = missionUUID == null ? "" : missionUUID.replaceAll("Mission:", "").trim();
                String trackNumber = evt.getTrackNumber();
                String trackStatus = "";
                if (evt.getStatus() != null) {
                    trackStatus = evt.getStatus().name();
                }
                String trackClassification = "";
                if (evt.getSecurity() != null && evt.getSecurity().getClassification() != null) {
                    trackClassification = evt.getSecurity().getClassification().name();
                }
                TreeMap<Long, ImageChipInfo> timesWithImageChips = new TreeMap<Long, ImageChipInfo>();
                List<MotionImagery> images = evt.getMotionImages();
                int width = -1;
                int height = -1;
                for (MotionImagery motionImagery : images) {
                    try {
                        String imageChip = motionImagery.getImageChip();
                        BufferedImage img = null;
                        if (imageChip != null && imageChip.length() > 0) {
                            byte[] binary = BaseEncoding.base64().decode((CharSequence)imageChip);
                            stream = ImageIO.createImageInputStream(new ByteArrayInputStream(binary));
                            img = ImageIO.read((ImageInputStream)stream);
                            if (width < 0 || img.getWidth() > width) {
                                width = img.getWidth();
                            }
                            if (height < 0 || img.getHeight() > height) {
                                height = img.getHeight();
                            }
                        }
                        timesWithImageChips.put(motionImagery.getTime(), new ImageChipInfo(img, motionImagery.getFrameNumber(), motionImagery.getPixelRow(), motionImagery.getPixelColumn()));
                    }
                    catch (Exception e) {
                        LOGGER.warn("Unable to write image chip to file", (Throwable)e);
                    }
                }
                for (Map.Entry entry : timesWithImageChips.entrySet()) {
                    BufferedImage img = ((ImageChipInfo)entry.getValue()).getImage();
                    if (img == null) continue;
                    BufferedImage scaledImage = IngestMessageHandler.toBufferedImage(img.getScaledInstance(width, height, 4), 5);
                    ((ImageChipInfo)entry.getValue()).setImage(scaledImage);
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        stream = null;
                        try {
                            ImageIO.write((RenderedImage)scaledImage, DEFAULT_IMAGE_FORMAT, baos);
                            baos.flush();
                            ((ImageChipInfo)entry.getValue()).setImageBytes(baos.toByteArray());
                        }
                        catch (Throwable throwable) {
                            stream = throwable;
                            throw throwable;
                        }
                        finally {
                            if (baos == null) continue;
                            if (stream != null) {
                                try {
                                    baos.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)stream).addSuppressed(throwable);
                                }
                                continue;
                            }
                            baos.close();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Unable to write image chip to file", (Throwable)e);
                    }
                }
                for (TrackPoint trackPoint : evt.getPoints().values()) {
                    ModalityType mt;
                    String trackItemUUID = trackPoint.getUuid();
                    long timeStamp = trackPoint.getEventTime();
                    long endTimeStamp = -1L;
                    double speed = trackPoint.getSpeed();
                    double course = trackPoint.getCourse();
                    String trackItemClassification = "UNKNOWN";
                    if (trackPoint.getSecurity() != null && trackPoint.getSecurity().getClassification() != null) {
                        trackItemClassification = trackPoint.getSecurity().getClassification().name();
                    }
                    String trackPointSource = (mt = trackPoint.getTrackPointSource()) != null ? mt.toString() : "";
                    double latitude = trackPoint.getLocation().latitude;
                    double longitude = trackPoint.getLocation().longitude;
                    double elevation = trackPoint.getLocation().elevation;
                    byte[] geometry = this.wkbWriter.write((Geometry)GeometryUtils.GEOMETRY_FACTORY.createPoint(new Coordinate(longitude, latitude)));
                    double detailLatitude = Double.MIN_VALUE;
                    double detailLongitude = Double.MIN_VALUE;
                    double detailElevation = Double.MIN_VALUE;
                    byte[] detailGeometry = null;
                    if (trackPoint.getDetail() != null && trackPoint.getDetail().getLocation() != null) {
                        detailLatitude = trackPoint.getDetail().getLocation().latitude;
                        detailLongitude = trackPoint.getDetail().getLocation().longitude;
                        detailElevation = trackPoint.getDetail().getLocation().elevation;
                        detailGeometry = this.wkbWriter.write((Geometry)GeometryUtils.GEOMETRY_FACTORY.createPoint(new Coordinate(detailLongitude, detailLatitude)));
                    }
                    ImageChipInfo chipInfo = (ImageChipInfo)timesWithImageChips.get(timeStamp);
                    int pixelRow = -1;
                    int pixelColumn = -1;
                    int frameNumber = -1;
                    byte[] imageBytes = new byte[]{};
                    if (chipInfo != null) {
                        pixelRow = chipInfo.getPixelRow();
                        pixelColumn = chipInfo.getPixelColumn();
                        frameNumber = chipInfo.getFrameNumber();
                        imageBytes = chipInfo.getImageBytes();
                    }
                    Stanag4676EventWritable sw = new Stanag4676EventWritable();
                    sw.setTrackPointData(geometry, detailGeometry, imageBytes, missionUUID, trackNumber, trackUuid, trackStatus, trackClassification, trackItemUUID, trackPointSource, timeStamp, -1L, speed, course, trackItemClassification, latitude, longitude, elevation, detailLatitude, detailLongitude, detailElevation, pixelRow, pixelColumn, frameNumber);
                    this.intermediateData.add((KeyValueData<Text, Stanag4676EventWritable>)new KeyValueData((WritableComparable)new Text(trackUuid), (Writable)sw));
                }
                for (MotionEventPoint motionEventPoint : evt.getMotionPoints().values()) {
                    byte[] geometry = this.wkbWriter.write((Geometry)GeometryUtils.GEOMETRY_FACTORY.createPoint(new Coordinate(motionEventPoint.getLocation().longitude.doubleValue(), motionEventPoint.getLocation().latitude.doubleValue())));
                    String trackItemUUID = motionEventPoint.getUuid();
                    long timeStamp = motionEventPoint.getEventTime();
                    long endTimeStamp = motionEventPoint.getEndTime();
                    double speed = motionEventPoint.getSpeed();
                    double course = motionEventPoint.getCourse();
                    String trackItemClassification = "UNKNOWN";
                    if (motionEventPoint.getSecurity() != null && motionEventPoint.getSecurity().getClassification() != null) {
                        trackItemClassification = motionEventPoint.getSecurity().getClassification().name();
                    }
                    double latitude = motionEventPoint.getLocation().latitude;
                    double longitude = motionEventPoint.getLocation().longitude;
                    double elevation = motionEventPoint.getLocation().elevation;
                    ModalityType mt = motionEventPoint.getTrackPointSource();
                    String trackPointSource = mt != null ? mt.toString() : "";
                    ImageChipInfo chipInfo = (ImageChipInfo)timesWithImageChips.get(timeStamp);
                    int pixelRow = -1;
                    int pixelColumn = -1;
                    int frameNumber = -1;
                    byte[] imageBytes = new byte[]{};
                    if (chipInfo != null) {
                        pixelRow = chipInfo.getPixelRow();
                        pixelColumn = chipInfo.getPixelColumn();
                        frameNumber = chipInfo.getFrameNumber();
                        imageBytes = chipInfo.getImageBytes();
                    }
                    String motionEvent = motionEventPoint.motionEvent;
                    Stanag4676EventWritable sw = new Stanag4676EventWritable();
                    sw.setMotionPointData(geometry, imageBytes, missionUUID, trackNumber, trackUuid, trackStatus, trackClassification, trackItemUUID, trackPointSource, timeStamp, endTimeStamp, speed, course, trackItemClassification, latitude, longitude, elevation, pixelRow, pixelColumn, frameNumber, motionEvent);
                    this.intermediateData.add((KeyValueData<Text, Stanag4676EventWritable>)new KeyValueData((WritableComparable)new Text(trackUuid), (Writable)sw));
                }
                for (TrackClassification trackClassification2 : evt.getClassifications()) {
                    long objectClassTime = trackClassification2.getTime();
                    String objectClass = trackClassification2.classification.toString();
                    int objectClassConf = trackClassification2.credibility.getValueConfidence();
                    int objectClassRel = trackClassification2.credibility.getSourceReliability();
                    Stanag4676EventWritable sw = new Stanag4676EventWritable();
                    sw.setTrackObjectClassData(objectClassTime, objectClass, objectClassConf, objectClassRel);
                    this.intermediateData.add((KeyValueData<Text, Stanag4676EventWritable>)new KeyValueData((WritableComparable)new Text(trackUuid), (Writable)sw));
                }
            }
        }
        if (msg instanceof MissionSummaryMessage && (missionSummary = (missionSummaryMessage = (MissionSummaryMessage)msg).getMissionSummary()) != null && missionSummary.getCoverageArea() != null) {
            Polygon missionPolygon = missionSummary.getCoverageArea().getPolygon();
            byte[] missionGeometry = this.wkbWriter.write((Geometry)missionPolygon);
            missionUUID = missionSummary.getMissionId();
            String missionName = missionSummary.getName();
            int missionNumFrames = missionSummary.getFrames().size();
            long missionStartTime = missionSummary.getStartTime();
            long missionEndTime = missionSummary.getEndTime();
            String missionClassification = missionSummary.getSecurity();
            StringBuilder sb = new StringBuilder();
            for (ObjectClassification objectClassification : missionSummary.getClassifications()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(objectClassification.toString());
            }
            String activeObjectClass = sb.toString();
            Stanag4676EventWritable stanag4676EventWritable = new Stanag4676EventWritable();
            stanag4676EventWritable.setMissionSummaryData(missionGeometry, missionUUID, missionName, missionNumFrames, missionStartTime, missionEndTime, missionClassification, activeObjectClass);
            this.intermediateData.add((KeyValueData<Text, Stanag4676EventWritable>)new KeyValueData((WritableComparable)new Text(missionUUID), (Writable)stanag4676EventWritable));
            for (MissionFrame frame : missionSummary.getFrames()) {
                if (frame == null || frame.getCoverageArea() == null) continue;
                Polygon framePolygon = frame.getCoverageArea().getPolygon();
                byte[] frameGeometry = this.wkbWriter.write((Geometry)framePolygon);
                long frameTimeStamp = frame.getFrameTime();
                int frameNumber = frame.getFrameNumber();
                Stanag4676EventWritable fsw = new Stanag4676EventWritable();
                fsw.setMissionFrameData(frameGeometry, missionUUID, frameNumber, frameTimeStamp);
                this.intermediateData.add((KeyValueData<Text, Stanag4676EventWritable>)new KeyValueData((WritableComparable)new Text(missionUUID), (Writable)fsw));
            }
        }
    }

    private static BufferedImage toBufferedImage(Image image, int type) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        return ImageChipUtils.toBufferedImage(image, type);
    }

    @Override
    public void notify(TrackRun run) {
    }

    @Override
    public void initialize(TrackRun run) {
    }
}

