/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.stanag4676;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.jaitools.jts.CoordinateSequence2D;
import org.locationtech.geowave.adapter.vector.FeatureDataAdapter;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.index.FloatCompareUtils;
import org.locationtech.geowave.core.ingest.avro.AbstractStageWholeFileToAvro;
import org.locationtech.geowave.core.ingest.avro.AvroWholeFile;
import org.locationtech.geowave.core.ingest.hdfs.mapreduce.IngestFromHdfsPlugin;
import org.locationtech.geowave.core.ingest.hdfs.mapreduce.IngestWithMapper;
import org.locationtech.geowave.core.ingest.hdfs.mapreduce.IngestWithReducer;
import org.locationtech.geowave.core.ingest.hdfs.mapreduce.KeyValueData;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.index.NullIndex;
import org.locationtech.geowave.core.store.ingest.GeoWaveData;
import org.locationtech.geowave.core.store.ingest.IngestPluginBase;
import org.locationtech.geowave.core.store.ingest.LocalFileIngestPlugin;
import org.locationtech.geowave.format.stanag4676.ByteBufferBackedInputStream;
import org.locationtech.geowave.format.stanag4676.ComparatorStanag4676EventWritable;
import org.locationtech.geowave.format.stanag4676.IngestMessageHandler;
import org.locationtech.geowave.format.stanag4676.Stanag4676EventWritable;
import org.locationtech.geowave.format.stanag4676.Stanag4676Utils;
import org.locationtech.geowave.format.stanag4676.image.ImageChip;
import org.locationtech.geowave.format.stanag4676.image.ImageChipDataAdapter;
import org.locationtech.geowave.format.stanag4676.parser.NATO4676Decoder;
import org.locationtech.geowave.format.stanag4676.parser.TrackFileReader;
import org.locationtech.geowave.format.stanag4676.parser.util.EarthVector;
import org.locationtech.geowave.format.stanag4676.parser.util.Length;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stanag4676IngestPlugin
extends AbstractStageWholeFileToAvro<Object>
implements IngestFromHdfsPlugin<AvroWholeFile, Object>,
LocalFileIngestPlugin<Object> {
    private static Logger LOGGER = LoggerFactory.getLogger(Stanag4676IngestPlugin.class);
    public static final Index IMAGE_CHIP_INDEX = new NullIndex("IMAGERY_CHIPS");
    private static final String[] IMAGE_CHIP_AS_ARRAY = new String[]{IMAGE_CHIP_INDEX.getName()};

    public String[] getFileExtensionFilters() {
        return new String[]{"xml", "4676"};
    }

    public void init(URL baseDirectory) {
    }

    public boolean supportsFile(URL file) {
        try {
            return file.openConnection().getContentLength() > 0;
        }
        catch (IOException e) {
            LOGGER.info("Unable to read URL for '" + file.getPath() + "'", (Throwable)e);
            return false;
        }
    }

    public boolean isUseReducerPreferred() {
        return true;
    }

    public IngestWithMapper<AvroWholeFile, Object> ingestWithMapper() {
        return new IngestWithReducerImpl();
    }

    public IngestWithReducer<AvroWholeFile, ?, ?, Object> ingestWithReducer() {
        return new IngestWithReducerImpl();
    }

    public CloseableIterator<GeoWaveData<Object>> toGeoWaveData(URL file, String[] indexNames) {
        return this.ingestWithMapper().toGeoWaveData(this.toAvroObjects(file).next(), indexNames);
    }

    public DataTypeAdapter<Object>[] getDataAdapters() {
        return new IngestWithReducerImpl().getDataAdapters();
    }

    public Index[] getRequiredIndices() {
        return new Index[]{IMAGE_CHIP_INDEX};
    }

    public IngestPluginBase<AvroWholeFile, Object> getIngestWithAvroPlugin() {
        return this.ingestWithMapper();
    }

    public String[] getSupportedIndexTypes() {
        return new String[]{"default_geom_dimension", "default_time_dimension"};
    }

    public static class IngestWithReducerImpl
    implements IngestWithReducer<AvroWholeFile, Text, Stanag4676EventWritable, Object>,
    IngestWithMapper<AvroWholeFile, Object> {
        private final SimpleFeatureBuilder ptBuilder;
        private final SimpleFeatureBuilder motionBuilder;
        private final SimpleFeatureBuilder trackBuilder;
        private final SimpleFeatureBuilder missionSummaryBuilder;
        private final SimpleFeatureBuilder missionFrameBuilder;
        private final SimpleFeatureType pointType = Stanag4676Utils.createPointDataType();
        private final SimpleFeatureType motionPointType = Stanag4676Utils.createMotionDataType();
        private final SimpleFeatureType trackType = Stanag4676Utils.createTrackDataType();
        private final SimpleFeatureType missionSummaryType = Stanag4676Utils.createMissionSummaryDataType();
        private final SimpleFeatureType missionFrameType = Stanag4676Utils.createMissionFrameDataType();

        public IngestWithReducerImpl() {
            this.ptBuilder = new SimpleFeatureBuilder(this.pointType);
            this.motionBuilder = new SimpleFeatureBuilder(this.motionPointType);
            this.trackBuilder = new SimpleFeatureBuilder(this.trackType);
            this.missionSummaryBuilder = new SimpleFeatureBuilder(this.missionSummaryType);
            this.missionFrameBuilder = new SimpleFeatureBuilder(this.missionFrameType);
        }

        public String[] getSupportedIndexTypes() {
            return new String[]{"default_geom_dimension", "default_time_dimension"};
        }

        public DataTypeAdapter<Object>[] getDataAdapters() {
            return new DataTypeAdapter[]{new FeatureDataAdapter(this.pointType), new FeatureDataAdapter(this.motionPointType), new FeatureDataAdapter(this.trackType), new FeatureDataAdapter(this.missionSummaryType), new FeatureDataAdapter(this.missionFrameType), new ImageChipDataAdapter()};
        }

        public byte[] toBinary() {
            return new byte[0];
        }

        public void fromBinary(byte[] bytes) {
        }

        public CloseableIterator<KeyValueData<Text, Stanag4676EventWritable>> toIntermediateMapReduceData(AvroWholeFile input) {
            TrackFileReader fileReader = new TrackFileReader();
            fileReader.setDecoder(new NATO4676Decoder());
            fileReader.setStreaming(true);
            IngestMessageHandler handler = new IngestMessageHandler();
            fileReader.setHandler(handler);
            fileReader.read(new ByteBufferBackedInputStream(input.getOriginalFile()));
            return new CloseableIterator.Wrapper(handler.getIntermediateData().iterator());
        }

        public CloseableIterator<GeoWaveData<Object>> toGeoWaveData(Text key, String[] indexNames, Iterable<Stanag4676EventWritable> values) {
            ArrayList<GeoWaveData> geowaveData = new ArrayList<GeoWaveData>();
            ArrayList<Stanag4676EventWritable> sortedEvents = new ArrayList<Stanag4676EventWritable>();
            for (Stanag4676EventWritable event : values) {
                sortedEvents.add(Stanag4676EventWritable.clone(event));
            }
            Collections.sort(sortedEvents, new ComparatorStanag4676EventWritable());
            String trackUuid = "";
            String mission = "";
            String trackNumber = "";
            String trackStatus = "";
            String trackClassification = "";
            Stanag4676EventWritable firstEvent = null;
            Stanag4676EventWritable lastEvent = null;
            int numTrackPoints = 0;
            double distanceKm = 0.0;
            EarthVector prevEv = null;
            ArrayList<Double> coord_sequence = new ArrayList<Double>();
            ArrayList<Double> detail_coord_sequence = new ArrayList<Double>();
            double minSpeed = Double.MAX_VALUE;
            double maxSpeed = -1.7976931348623157E308;
            int numMotionPoints = 0;
            int stopCount = 0;
            int turnCount = 0;
            int uturnCount = 0;
            int stopDurationContibCount = 0;
            long stopDuration = 0L;
            long stopTime = -1L;
            String objectClass = "";
            String objectClassConf = "";
            String objectClassRel = "";
            String objectClassTimes = "";
            for (Stanag4676EventWritable event : sortedEvents) {
                byte[] imageBytes;
                trackUuid = event.TrackUUID.toString();
                mission = event.MissionUUID.toString();
                trackNumber = event.TrackNumber.toString();
                trackClassification = event.TrackClassification.toString();
                if (event.EventType.get() == 0) {
                    ++numTrackPoints;
                    if (firstEvent == null) {
                        firstEvent = event;
                    }
                    lastEvent = event;
                    Object currentEv = new EarthVector(EarthVector.degToRad(event.Latitude.get()), EarthVector.degToRad(event.Longitude.get()), Length.fromM(event.Elevation.get()).getKM());
                    if (prevEv != null) {
                        distanceKm += prevEv.getDistance((EarthVector)currentEv);
                    }
                    coord_sequence.add(event.Longitude.get());
                    coord_sequence.add(event.Latitude.get());
                    prevEv = currentEv;
                    Point geometry = GeometryUtils.GEOMETRY_FACTORY.createPoint(new Coordinate(event.Longitude.get(), event.Latitude.get()));
                    this.ptBuilder.add((Object)geometry);
                    if (!FloatCompareUtils.checkDoublesEqual((double)event.DetailLatitude.get(), (double)Double.MIN_VALUE) && !FloatCompareUtils.checkDoublesEqual((double)event.DetailLongitude.get(), (double)Double.MIN_VALUE)) {
                        detail_coord_sequence.add(event.DetailLongitude.get());
                        detail_coord_sequence.add(event.DetailLatitude.get());
                    }
                    Double detailLatitude = null;
                    Double detailLongitude = null;
                    Double detailElevation = null;
                    Point detailGeometry = null;
                    if (!FloatCompareUtils.checkDoublesEqual((double)event.DetailLatitude.get(), (double)Double.MIN_VALUE) && !FloatCompareUtils.checkDoublesEqual((double)event.DetailLongitude.get(), (double)Double.MIN_VALUE)) {
                        detailLatitude = event.DetailLatitude.get();
                        detailLongitude = event.DetailLongitude.get();
                        detailElevation = event.DetailElevation.get();
                        detailGeometry = GeometryUtils.GEOMETRY_FACTORY.createPoint(new Coordinate(detailLongitude.doubleValue(), detailLatitude.doubleValue()));
                    }
                    this.ptBuilder.add(detailGeometry);
                    this.ptBuilder.add((Object)mission);
                    this.ptBuilder.add((Object)trackNumber);
                    this.ptBuilder.add((Object)trackUuid);
                    this.ptBuilder.add((Object)event.TrackItemUUID.toString());
                    this.ptBuilder.add((Object)event.TrackPointSource.toString());
                    this.ptBuilder.add((Object)new Date(event.TimeStamp.get()));
                    if (event.Speed.get() > maxSpeed) {
                        maxSpeed = event.Speed.get();
                    }
                    if (event.Speed.get() < minSpeed) {
                        minSpeed = event.Speed.get();
                    }
                    this.ptBuilder.add((Object)new Double(event.Speed.get()));
                    this.ptBuilder.add((Object)new Double(event.Course.get()));
                    this.ptBuilder.add((Object)event.TrackItemClassification.toString());
                    this.ptBuilder.add((Object)new Double(event.Latitude.get()));
                    this.ptBuilder.add((Object)new Double(event.Longitude.get()));
                    this.ptBuilder.add((Object)new Double(event.Elevation.get()));
                    this.ptBuilder.add((Object)detailLatitude);
                    this.ptBuilder.add((Object)detailLongitude);
                    this.ptBuilder.add((Object)detailElevation);
                    this.ptBuilder.add((Object)event.FrameNumber.get());
                    this.ptBuilder.add((Object)event.PixelRow.get());
                    this.ptBuilder.add((Object)event.PixelColumn.get());
                    geowaveData.add(new GeoWaveData("track_point", indexNames, (Object)this.ptBuilder.buildFeature(event.TrackItemUUID.toString())));
                } else if (event.EventType.get() == 1) {
                    ++numMotionPoints;
                    this.motionBuilder.add((Object)GeometryUtils.GEOMETRY_FACTORY.createPoint(new Coordinate(event.Longitude.get(), event.Latitude.get())));
                    this.motionBuilder.add((Object)mission);
                    this.motionBuilder.add((Object)trackNumber);
                    this.motionBuilder.add((Object)trackUuid);
                    this.motionBuilder.add((Object)event.TrackItemUUID.toString());
                    this.motionBuilder.add((Object)event.MotionEvent.toString());
                    switch (event.MotionEvent.toString()) {
                        case "STOP": {
                            ++stopCount;
                            stopTime = event.TimeStamp.get();
                            break;
                        }
                        case "START": {
                            if (stopTime <= 0L) break;
                            stopDuration += event.TimeStamp.get() - stopTime;
                            ++stopDurationContibCount;
                            stopTime = -1L;
                            break;
                        }
                        case "LEFT TURN": 
                        case "RIGHT TURN": {
                            ++turnCount;
                            break;
                        }
                        case "LEFT U TURN": 
                        case "RIGHT U TURN": {
                            ++uturnCount;
                            break;
                        }
                    }
                    this.motionBuilder.add((Object)new Date(event.TimeStamp.get()));
                    this.motionBuilder.add((Object)new Date(event.EndTimeStamp.get()));
                    this.motionBuilder.add((Object)event.TrackItemClassification.toString());
                    this.motionBuilder.add((Object)new Double(event.Latitude.get()));
                    this.motionBuilder.add((Object)new Double(event.Longitude.get()));
                    this.motionBuilder.add((Object)new Double(event.Elevation.get()));
                    this.motionBuilder.add((Object)event.FrameNumber.get());
                    this.motionBuilder.add((Object)event.PixelRow.get());
                    this.motionBuilder.add((Object)event.PixelColumn.get());
                    geowaveData.add(new GeoWaveData("motion_point", indexNames, (Object)this.motionBuilder.buildFeature(event.TrackItemUUID.toString())));
                } else if (event.EventType.get() == 2) {
                    Date date = new Date(event.TimeStamp.get());
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                    format.setTimeZone(TimeZone.getTimeZone("UTC"));
                    String dateStr = format.format(date);
                    if (objectClass.length() != 0) {
                        objectClass = objectClass + ",";
                    }
                    if (objectClassConf.length() != 0) {
                        objectClassConf = objectClassConf + ",";
                    }
                    if (objectClassRel.length() != 0) {
                        objectClassRel = objectClassRel + ",";
                    }
                    if (objectClassTimes.length() != 0) {
                        objectClassTimes = objectClassTimes + ",";
                    }
                    objectClass = objectClass + event.ObjectClass.toString();
                    objectClassConf = objectClassConf + event.ObjectClassConf.toString();
                    objectClassRel = objectClassRel + event.ObjectClassRel.toString();
                    objectClassTimes = objectClassTimes + dateStr;
                } else if (event.EventType.get() == 3) {
                    this.missionFrameBuilder.add((Object)GeometryUtils.geometryFromBinary((byte[])event.Geometry.getBytes(), null));
                    this.missionFrameBuilder.add((Object)event.MissionUUID.toString());
                    this.missionFrameBuilder.add((Object)new Date(event.TimeStamp.get()));
                    this.missionFrameBuilder.add((Object)event.FrameNumber.get());
                    geowaveData.add(new GeoWaveData("mission_frame", indexNames, (Object)this.missionFrameBuilder.buildFeature(UUID.randomUUID().toString())));
                } else if (event.EventType.get() == 4) {
                    this.missionSummaryBuilder.add((Object)GeometryUtils.geometryFromBinary((byte[])event.Geometry.getBytes(), null));
                    this.missionSummaryBuilder.add((Object)event.MissionUUID.toString());
                    this.missionSummaryBuilder.add((Object)new Date(event.TimeStamp.get()));
                    this.missionSummaryBuilder.add((Object)new Date(event.EndTimeStamp.get()));
                    this.missionSummaryBuilder.add((Object)event.MissionNumFrames.get());
                    this.missionSummaryBuilder.add((Object)event.MissionName.toString());
                    this.missionSummaryBuilder.add((Object)event.TrackClassification.toString());
                    this.missionSummaryBuilder.add((Object)event.ObjectClass.toString());
                    geowaveData.add(new GeoWaveData("mission_summary", indexNames, (Object)this.missionSummaryBuilder.buildFeature(UUID.randomUUID().toString())));
                }
                if (event.Image == null || (imageBytes = event.Image.getBytes()) == null || imageBytes.length <= 0) continue;
                geowaveData.add(new GeoWaveData("image", IMAGE_CHIP_AS_ARRAY, (Object)new ImageChip(mission, trackUuid, event.TimeStamp.get(), imageBytes)));
            }
            Double[] xy = coord_sequence.toArray(new Double[0]);
            if (firstEvent != null && lastEvent != null && xy.length >= 4) {
                CoordinateSequence2D coordinateSequence = new CoordinateSequence2D(ArrayUtils.toPrimitive((Double[])xy));
                LineString lineString = GeometryUtils.GEOMETRY_FACTORY.createLineString((CoordinateSequence)coordinateSequence);
                Double[] dxy = detail_coord_sequence.toArray(new Double[0]);
                CoordinateSequence2D detailCoordinateSequence = new CoordinateSequence2D(ArrayUtils.toPrimitive((Double[])dxy));
                LineString detailLineString = null;
                if (detailCoordinateSequence.size() > 0) {
                    detailLineString = GeometryUtils.GEOMETRY_FACTORY.createLineString((CoordinateSequence)detailCoordinateSequence);
                }
                this.trackBuilder.add((Object)lineString);
                this.trackBuilder.add((Object)detailLineString);
                this.trackBuilder.add((Object)mission);
                this.trackBuilder.add((Object)trackNumber);
                this.trackBuilder.add((Object)trackUuid);
                this.trackBuilder.add((Object)new Date(firstEvent.TimeStamp.get()));
                this.trackBuilder.add((Object)new Date(lastEvent.TimeStamp.get()));
                double durationSeconds = (double)(lastEvent.TimeStamp.get() - firstEvent.TimeStamp.get()) / 1000.0;
                this.trackBuilder.add((Object)durationSeconds);
                this.trackBuilder.add((Object)minSpeed);
                this.trackBuilder.add((Object)maxSpeed);
                double distanceM = Length.fromKM(distanceKm).getM();
                double avgSpeed = durationSeconds > 0.0 ? distanceM / durationSeconds : 0.0;
                this.trackBuilder.add((Object)avgSpeed);
                this.trackBuilder.add((Object)distanceKm);
                this.trackBuilder.add((Object)new Double(firstEvent.Latitude.get()));
                this.trackBuilder.add((Object)new Double(firstEvent.Longitude.get()));
                this.trackBuilder.add((Object)new Double(lastEvent.Latitude.get()));
                this.trackBuilder.add((Object)new Double(lastEvent.Longitude.get()));
                Double firstEventDetailLatitude = null;
                Double firstEventDetailLongitude = null;
                Double lastEventDetailLatitude = null;
                Double lastEventDetailLongitude = null;
                if (!(FloatCompareUtils.checkDoublesEqual((double)firstEvent.DetailLatitude.get(), (double)Double.MIN_VALUE) || FloatCompareUtils.checkDoublesEqual((double)firstEvent.DetailLongitude.get(), (double)Double.MIN_VALUE) || FloatCompareUtils.checkDoublesEqual((double)lastEvent.DetailLatitude.get(), (double)Double.MIN_VALUE) || FloatCompareUtils.checkDoublesEqual((double)lastEvent.DetailLongitude.get(), (double)Double.MIN_VALUE))) {
                    firstEventDetailLatitude = firstEvent.DetailLatitude.get();
                    firstEventDetailLongitude = firstEvent.DetailLongitude.get();
                    lastEventDetailLatitude = lastEvent.DetailLatitude.get();
                    lastEventDetailLongitude = lastEvent.DetailLongitude.get();
                }
                this.trackBuilder.add(firstEventDetailLatitude);
                this.trackBuilder.add(firstEventDetailLongitude);
                this.trackBuilder.add(lastEventDetailLatitude);
                this.trackBuilder.add(lastEventDetailLongitude);
                this.trackBuilder.add((Object)numTrackPoints);
                this.trackBuilder.add((Object)numMotionPoints);
                this.trackBuilder.add((Object)"");
                this.trackBuilder.add((Object)turnCount);
                this.trackBuilder.add((Object)uturnCount);
                this.trackBuilder.add((Object)stopCount);
                double stopDurationSeconds = (double)stopDuration / 1000.0;
                this.trackBuilder.add((Object)stopDurationSeconds);
                this.trackBuilder.add((Object)(stopDurationContibCount > 0 ? stopDurationSeconds / (double)stopDurationContibCount : 0.0));
                this.trackBuilder.add((Object)trackClassification);
                this.trackBuilder.add((Object)objectClass);
                this.trackBuilder.add((Object)objectClassConf);
                this.trackBuilder.add((Object)objectClassRel);
                this.trackBuilder.add((Object)objectClassTimes);
                geowaveData.add(new GeoWaveData("track", indexNames, (Object)this.trackBuilder.buildFeature(trackUuid)));
            }
            return new CloseableIterator.Wrapper(geowaveData.iterator());
        }

        public CloseableIterator<GeoWaveData<Object>> toGeoWaveData(AvroWholeFile input, String[] indexNames) {
            try (CloseableIterator<KeyValueData<Text, Stanag4676EventWritable>> intermediateData = this.toIntermediateMapReduceData(input);){
                HashMap<WritableComparable, ArrayList<Writable>> trackUuidMap = new HashMap<WritableComparable, ArrayList<Writable>>();
                while (intermediateData.hasNext()) {
                    KeyValueData next = (KeyValueData)intermediateData.next();
                    ArrayList<Writable> trackEvents = (ArrayList<Writable>)trackUuidMap.get(next.getKey());
                    if (trackEvents == null) {
                        trackEvents = new ArrayList<Writable>();
                        trackUuidMap.put(next.getKey(), trackEvents);
                    }
                    trackEvents.add(next.getValue());
                }
                ArrayList<CloseableIterator<GeoWaveData<Object>>> iterators = new ArrayList<CloseableIterator<GeoWaveData<Object>>>();
                for (Map.Entry entry : trackUuidMap.entrySet()) {
                    iterators.add(this.toGeoWaveData((Text)entry.getKey(), indexNames, (Iterable<Stanag4676EventWritable>)((Iterable)entry.getValue())));
                }
                CloseableIterator.Wrapper wrapper = new CloseableIterator.Wrapper(Iterators.concat(iterators.iterator()));
                return wrapper;
            }
        }
    }
}

