/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.stanag4676.image;

import java.util.Map;
import org.locationtech.geowave.core.store.adapter.FieldDescriptor;
import org.locationtech.geowave.core.store.adapter.FieldDescriptorBuilder;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.RowBuilder;
import org.locationtech.geowave.core.store.data.field.FieldReader;
import org.locationtech.geowave.core.store.data.field.FieldUtils;
import org.locationtech.geowave.core.store.data.field.FieldWriter;
import org.locationtech.geowave.format.stanag4676.image.ImageChip;
import org.locationtech.geowave.format.stanag4676.image.ImageChipUtils;

public class ImageChipDataAdapter
implements DataTypeAdapter<ImageChip> {
    public static final String ADAPTER_TYPE_NAME = "image";
    private static final String IMAGE_FIELD_NAME = "image";
    private static final FieldDescriptor<byte[]> IMAGE_FIELD = new FieldDescriptorBuilder(byte[].class).fieldName("image").build();
    private static final FieldDescriptor<?>[] FIELDS = new FieldDescriptor[]{IMAGE_FIELD};

    public String getTypeName() {
        return "image";
    }

    public byte[] getDataId(ImageChip entry) {
        return entry.getDataId();
    }

    public FieldReader<Object> getReader(String fieldId) {
        if ("image".equals(fieldId)) {
            return FieldUtils.getDefaultReaderForClass(byte[].class);
        }
        return null;
    }

    public byte[] toBinary() {
        return new byte[0];
    }

    public void fromBinary(byte[] bytes) {
    }

    public FieldWriter<Object> getWriter(String fieldId) {
        if ("image".equals(fieldId)) {
            return FieldUtils.getDefaultWriterForClass(byte[].class);
        }
        return null;
    }

    public Object getFieldValue(ImageChip entry, String fieldName) {
        return entry.getImageBinary();
    }

    public Class<ImageChip> getDataClass() {
        return ImageChip.class;
    }

    public RowBuilder<ImageChip> newRowBuilder(FieldDescriptor<?>[] outputFieldDescriptors) {
        return new ImageChipRowBuilder();
    }

    public FieldDescriptor<?>[] getFieldDescriptors() {
        return FIELDS;
    }

    public FieldDescriptor<?> getFieldDescriptor(String fieldName) {
        return IMAGE_FIELD;
    }

    private static class ImageChipRowBuilder
    implements RowBuilder<ImageChip> {
        private byte[] imageData;

        private ImageChipRowBuilder() {
        }

        public void setField(String fieldName, Object fieldValue) {
            if (fieldValue instanceof byte[]) {
                this.imageData = (byte[])fieldValue;
            }
        }

        public void setFields(Map<String, Object> values) {
            values.entrySet().forEach(e -> this.setField((String)e.getKey(), e.getValue()));
        }

        public ImageChip buildRow(byte[] dataId) {
            return ImageChipUtils.fromDataIdAndValue(dataId, this.imageData);
        }
    }
}

