/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.stanag4676.parser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.UUID;
import org.locationtech.geowave.format.stanag4676.parser.NATO4676Decoder;
import org.locationtech.geowave.format.stanag4676.parser.TrackDecoder;
import org.locationtech.geowave.format.stanag4676.parser.TrackReader;
import org.locationtech.geowave.format.stanag4676.parser.model.IDdata;
import org.locationtech.geowave.format.stanag4676.parser.model.NATO4676Message;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackFileReader
implements TrackReader {
    private TrackDecoder decoder;
    private static final Logger LOGGER = LoggerFactory.getLogger(TrackFileReader.class);
    private boolean streaming = false;
    private TrackReader.ProcessMessage handler = null;
    private TrackRun run = new TrackRun();
    private String filename;

    public void init() {
        if (this.decoder instanceof NATO4676Decoder) {
            LOGGER.info("*** 4676 enabled " + this.getClass().toString() + " Initialized***");
        }
    }

    @Override
    public void setDecoder(TrackDecoder decoder) {
        this.decoder = decoder;
    }

    @Override
    public void setStreaming(boolean stream) {
        this.streaming = stream;
    }

    @Override
    public void setHandler(TrackReader.ProcessMessage handler) {
        this.handler = handler;
    }

    @Override
    public void initialize(String algorithm, String algorithmVersion, long runDate, String comment, boolean streaming) {
        if (this.run == null) {
            this.run = new TrackRun();
        }
        this.run.clearParameters();
        this.run.clearMessages();
        this.run.setAlgorithm(algorithm);
        this.run.setAlgorithmVersion(algorithmVersion);
        this.run.setRunDate(runDate);
        this.run.setComment(comment);
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void read(byte[] input) {
        ByteArrayInputStream bis = new ByteArrayInputStream(input);
        this.run.setUuid(new UUID(Arrays.hashCode(input), Arrays.hashCode(input)));
        this.run.setRunDate(System.currentTimeMillis());
        this.run.setComment("ByteArray Input");
        this.handler.initialize(this.run);
        this.read(bis);
        try {
            ((InputStream)bis).close();
        }
        catch (IOException e2) {
            LOGGER.error("Unable to close the InputStream", (Throwable)e2);
        }
    }

    @Override
    public void read() {
        FileInputStream fis = null;
        try {
            File f = new File(this.filename);
            this.run.setUuid(UUID.randomUUID());
            this.run.setRunDate(f.lastModified());
            this.run.setComment("Track source is " + this.filename);
            this.run.setSourceFilename(this.filename);
            this.handler.initialize(this.run);
            fis = new FileInputStream(f);
            this.read(fis);
        }
        catch (FileNotFoundException | NullPointerException | SecurityException e) {
            LOGGER.error("Unable to create input stream", (Throwable)e);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException | NullPointerException e2) {
                LOGGER.error("Unable to close the InputStream", (Throwable)e2);
            }
        }
    }

    public void read(InputStream is) {
        this.decoder.initialize();
        if (this.run == null) {
            this.run = new TrackRun();
        }
        IDdata sender = new IDdata();
        sender.setStationId("GeoWave");
        sender.setNationality("US");
        NATO4676Message msg = null;
        boolean finished = false;
        while (!finished) {
            msg = this.decoder.readNext(is);
            if (msg != null) {
                msg.setSenderID(sender);
                if (this.streaming) {
                    try {
                        this.handler.notify(msg);
                    }
                    catch (IOException | InterruptedException ex) {
                        LOGGER.warn("Unable to process notify message", (Throwable)ex);
                    }
                    continue;
                }
                this.run.addMessage(msg);
                continue;
            }
            finished = true;
        }
        this.handler.notify(this.run);
    }
}

