/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.stanag4676.parser.util;

import java.io.Serializable;
import org.locationtech.geowave.core.index.FloatCompareUtils;

public class Length
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final double KMperNM = 1.852;
    public static final double KMperSM = 1.609344;
    public static final double FTperSM = 5280.0;
    public static final double SMperKM = 0.621371192237334;
    public static final double FTperKM = 3280.839895013123;
    public static final double INperKM = 39370.07874015748;
    public static final double YDperKM = 1093.6132983377076;
    private double lengthKM;

    protected Length() {
    }

    private Length(double lengthKM) {
        this.lengthKM = lengthKM;
    }

    public static Double getKM(Length length) {
        return length != null ? Double.valueOf(length.getKM()) : null;
    }

    public static Double getM(Length length) {
        return length != null ? Double.valueOf(length.getM()) : null;
    }

    public static Length fromKM(double lengthKM) {
        return new Length(lengthKM);
    }

    public static Length fromNM(double lengthNM) {
        return new Length(lengthNM * 1.852);
    }

    public static Length fromSM(double lengthSM) {
        return new Length(lengthSM * 1.609344);
    }

    public static Length fromM(double lengthM) {
        return new Length(lengthM / 1000.0);
    }

    public static Length fromDM(double lengthDM) {
        return Length.fromM(lengthDM / 10.0);
    }

    public static Length fromCM(double lengthCM) {
        return Length.fromM(lengthCM / 100.0);
    }

    public static Length fromMM(double lengthMM) {
        return Length.fromM(lengthMM / 1000.0);
    }

    public static Length fromFeet(double lengthFeet) {
        return new Length(lengthFeet / 3280.839895013123);
    }

    public static Length fromYards(double lengthYards) {
        return new Length(lengthYards / 1093.6132983377076);
    }

    public static Length fromInches(double lengthInches) {
        return new Length(lengthInches / 39370.07874015748);
    }

    public static Length from(LengthUnits units, double val) {
        switch (units) {
            case Kilometers: {
                return Length.fromKM(val);
            }
            case Meters: {
                return Length.fromM(val);
            }
            case Decimeters: {
                return Length.fromDM(val);
            }
            case Centimeters: {
                return Length.fromCM(val);
            }
            case Millimeters: {
                return Length.fromMM(val);
            }
            case NauticalMiles: {
                return Length.fromNM(val);
            }
            case StatuteMiles: {
                return Length.fromSM(val);
            }
            case Feet: {
                return Length.fromFeet(val);
            }
            case Yards: {
                return Length.fromYards(val);
            }
            case Inches: {
                return Length.fromInches(val);
            }
        }
        return Length.fromKM(val);
    }

    public static final Length add(Length l1, Length l2) {
        return Length.fromKM(l1.lengthKM + l2.lengthKM);
    }

    public static final Length sub(Length l1, Length l2) {
        return Length.fromKM(l1.lengthKM - l2.lengthKM);
    }

    public final double getLength(LengthUnits units) {
        switch (units) {
            case Kilometers: {
                return this.getKM();
            }
            case Meters: {
                return this.getM();
            }
            case Decimeters: {
                return this.getDM();
            }
            case Centimeters: {
                return this.getCM();
            }
            case Millimeters: {
                return this.getMM();
            }
            case NauticalMiles: {
                return this.getNM();
            }
            case StatuteMiles: {
                return this.getSM();
            }
            case Feet: {
                return this.getFeet();
            }
            case Yards: {
                return this.getYards();
            }
            case Inches: {
                return this.getInches();
            }
        }
        return this.getKM();
    }

    public final double getKM() {
        return this.lengthKM;
    }

    public final double getM() {
        return this.lengthKM * 1000.0;
    }

    public final double getDM() {
        return this.lengthKM * 1000.0 * 10.0;
    }

    public final double getCM() {
        return this.lengthKM * 1000.0 * 100.0;
    }

    public final double getMM() {
        return this.lengthKM * 1000.0 * 1000.0;
    }

    public final double getNM() {
        return this.lengthKM / 1.852;
    }

    public final double getSM() {
        return this.lengthKM / 1.609344;
    }

    public final double getFeet() {
        return this.lengthKM * 3280.839895013123;
    }

    public final double getYards() {
        return this.lengthKM * 1093.6132983377076;
    }

    public final double getInches() {
        return this.lengthKM * 39370.07874015748;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Length) {
            Length objLength = (Length)obj;
            return FloatCompareUtils.checkDoublesEqual((double)objLength.lengthKM, (double)this.lengthKM);
        }
        return false;
    }

    public int hashCode() {
        Double len = new Double(this.lengthKM);
        return len.hashCode();
    }

    public final String toString() {
        return Double.toString(this.lengthKM) + "km";
    }

    public static enum LengthUnits {
        Kilometers,
        Meters,
        Decimeters,
        Centimeters,
        Millimeters,
        NauticalMiles,
        StatuteMiles,
        Yards,
        Feet,
        Inches;

    }
}

