/**
 * Copyright (c) 2013-2022 Contributors to the Eclipse Foundation
 *
 * <p> See the NOTICE file distributed with this work for additional information regarding copyright
 * ownership. All rights reserved. This program and the accompanying materials are made available
 * under the terms of the Apache License, Version 2.0 which accompanies this distribution and is
 * available at http://www.apache.org/licenses/LICENSE-2.0.txt
 */
package org.locationtech.geowave.format.stanag4676.parser.model;

// STANAG 4676
/** The type of tracker that generated a track (i.e. manual, automatic, semi-automatic). */
public enum TrackerType {
  /** A track is approximated/estimated by a human operator/analyst. */
  MANUAL_TRACKER("MANUAL_TRACKER"),

  /** A track generated by an automatic tracker, based on measured data. */
  AUTOMATIC_TRACKER("AUTOMATIC_TRACKER"),

  /**
   * A track generated by an automatic tracker in combination with information
   * approximated/estimated by an operator/analyst.
   */
  SEMIAUTOMATIC_TRACKER("SEMIAUTOMATIC_TRACKER");

  private String value;

  TrackerType() {
    value = TrackStatus.values()[0].toString();
  }

  TrackerType(final String value) {
    this.value = value;
  }

  public static TrackerType fromString(final String value) {
    for (final TrackerType item : TrackerType.values()) {
      if (item.toString().equals(value)) {
        return item;
      }
    }
    return null;
  }

  @Override
  public String toString() {
    return value;
  }
}
