/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.avro;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.io.DatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.locationtech.geowave.adapter.vector.FeatureDataAdapter;
import org.locationtech.geowave.adapter.vector.GeoWaveAvroFeatureUtils;
import org.locationtech.geowave.adapter.vector.avro.AvroAttributeValues;
import org.locationtech.geowave.adapter.vector.avro.AvroFeatureDefinition;
import org.locationtech.geowave.adapter.vector.avro.AvroSimpleFeatureCollection;
import org.locationtech.geowave.adapter.vector.ingest.AbstractSimpleFeatureIngestPlugin;
import org.locationtech.geowave.core.geotime.store.dimension.GeometryWrapper;
import org.locationtech.geowave.core.geotime.store.dimension.Time;
import org.locationtech.geowave.core.ingest.hdfs.mapreduce.IngestWithMapper;
import org.locationtech.geowave.core.ingest.hdfs.mapreduce.IngestWithReducer;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.index.CommonIndexValue;
import org.locationtech.geowave.core.store.ingest.GeoWaveData;
import org.locationtech.geowave.core.store.ingest.IngestPluginBase;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoWaveAvroIngestPlugin
extends AbstractSimpleFeatureIngestPlugin<AvroSimpleFeatureCollection> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoWaveAvroIngestPlugin.class);

    public String[] getFileExtensionFilters() {
        return new String[]{"avro", "dat", "bin", "json"};
    }

    public void init(URL baseDirectory) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean supportsFile(URL file) {
        try (DataFileStream ds = new DataFileStream(file.openStream(), (DatumReader)new SpecificDatumReader(AvroSimpleFeatureCollection.getClassSchema()));){
            if (ds.getHeader() == null) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.info("Unable to read file as Avro vector data '" + file.getPath() + "'", (Throwable)e);
        }
        return false;
    }

    protected SimpleFeatureType[] getTypes() {
        return new SimpleFeatureType[0];
    }

    public Schema getAvroSchema() {
        return AvroSimpleFeatureCollection.getClassSchema();
    }

    public CloseableIterator<AvroSimpleFeatureCollection> toAvroObjects(final URL input) {
        try {
            final DataFileStream reader = new DataFileStream(input.openStream(), (DatumReader)new SpecificDatumReader(AvroSimpleFeatureCollection.getClassSchema()));
            return new CloseableIterator<AvroSimpleFeatureCollection>(){

                public boolean hasNext() {
                    return reader.hasNext();
                }

                public AvroSimpleFeatureCollection next() {
                    return (AvroSimpleFeatureCollection)reader.next();
                }

                public void close() {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        LOGGER.warn("Unable to close file '" + input.getPath() + "'", (Throwable)e);
                    }
                }
            };
        }
        catch (IOException e) {
            LOGGER.warn("Unable to read file '" + input.getPath() + "' as AVRO SimpleFeatureCollection", (Throwable)e);
            return new CloseableIterator.Empty();
        }
    }

    public boolean isUseReducerPreferred() {
        return false;
    }

    public IngestWithMapper<AvroSimpleFeatureCollection, SimpleFeature> ingestWithMapper() {
        return new IngestAvroFeaturesFromHdfs(this);
    }

    public IngestWithReducer<AvroSimpleFeatureCollection, ?, ?, SimpleFeature> ingestWithReducer() {
        throw new UnsupportedOperationException("Avro simple feature collections cannot be ingested with a reducer");
    }

    protected CloseableIterator<GeoWaveData<SimpleFeature>> toGeoWaveDataInternal(AvroSimpleFeatureCollection featureCollection, String[] indexNames, String globalVisibility) {
        AvroFeatureDefinition featureDefinition = featureCollection.getFeatureType();
        ArrayList<GeoWaveData> retVal = new ArrayList<GeoWaveData>();
        try {
            SimpleFeatureType featureType = GeoWaveAvroFeatureUtils.avroFeatureDefinitionToGTSimpleFeatureType((AvroFeatureDefinition)featureDefinition);
            FeatureDataAdapter adapter = new FeatureDataAdapter(featureType);
            List attributeTypes = featureDefinition.getAttributeTypes();
            for (AvroAttributeValues attributeValues : featureCollection.getSimpleFeatureCollection()) {
                try {
                    SimpleFeature simpleFeature = GeoWaveAvroFeatureUtils.avroSimpleFeatureToGTSimpleFeature((SimpleFeatureType)featureType, (List)attributeTypes, (AvroAttributeValues)attributeValues);
                    retVal.add(new GeoWaveData((DataTypeAdapter)adapter, indexNames, (Object)simpleFeature));
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to read simple feature from Avro", (Throwable)e);
                }
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Unable to read simple feature type from Avro", (Throwable)e);
        }
        return new CloseableIterator.Wrapper(retVal.iterator());
    }

    public Index[] getRequiredIndices() {
        return new Index[0];
    }

    public IngestPluginBase<AvroSimpleFeatureCollection, SimpleFeature> getIngestWithAvroPlugin() {
        return new IngestAvroFeaturesFromHdfs(this);
    }

    public Class<? extends CommonIndexValue>[] getSupportedIndexableTypes() {
        return new Class[]{GeometryWrapper.class, Time.class};
    }

    public static class IngestAvroFeaturesFromHdfs
    extends AbstractSimpleFeatureIngestPlugin.AbstractIngestSimpleFeatureWithMapper<AvroSimpleFeatureCollection> {
        public IngestAvroFeaturesFromHdfs() {
            this(new GeoWaveAvroIngestPlugin());
        }

        public IngestAvroFeaturesFromHdfs(GeoWaveAvroIngestPlugin parentPlugin) {
            super((AbstractSimpleFeatureIngestPlugin)parentPlugin);
        }
    }
}

