/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.gdelt;

import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.zip.ZipInputStream;
import org.apache.avro.Schema;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.locationtech.geowave.adapter.vector.ingest.AbstractSimpleFeatureIngestPlugin;
import org.locationtech.geowave.adapter.vector.ingest.DataSchemaOptionProvider;
import org.locationtech.geowave.adapter.vector.util.SimpleFeatureUserDataConfigurationSet;
import org.locationtech.geowave.core.geotime.store.dimension.GeometryWrapper;
import org.locationtech.geowave.core.geotime.store.dimension.Time;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.ingest.avro.AvroWholeFile;
import org.locationtech.geowave.core.ingest.hdfs.mapreduce.IngestWithMapper;
import org.locationtech.geowave.core.ingest.hdfs.mapreduce.IngestWithReducer;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.index.CommonIndexValue;
import org.locationtech.geowave.core.store.ingest.GeoWaveData;
import org.locationtech.geowave.core.store.ingest.IngestPluginBase;
import org.locationtech.geowave.format.gdelt.GDELTUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GDELTIngestPlugin
extends AbstractSimpleFeatureIngestPlugin<AvroWholeFile> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GDELTIngestPlugin.class);
    private SimpleFeatureBuilder gdeltEventBuilder;
    private SimpleFeatureType gdeltEventType;
    private final String eventKey;
    private boolean includeSupplementalFields;

    public GDELTIngestPlugin() {
        this.setIncludeSupplementalFields(false);
        this.eventKey = "gdeltevent";
    }

    public GDELTIngestPlugin(DataSchemaOptionProvider dataSchemaOptionProvider) {
        this.setIncludeSupplementalFields(dataSchemaOptionProvider.includeSupplementalFields());
        this.eventKey = "gdeltevent";
    }

    private void setIncludeSupplementalFields(boolean includeSupplementalFields) {
        this.includeSupplementalFields = includeSupplementalFields;
        this.gdeltEventType = GDELTUtils.createGDELTEventDataType(includeSupplementalFields);
        this.gdeltEventBuilder = new SimpleFeatureBuilder(this.gdeltEventType);
    }

    protected SimpleFeatureType[] getTypes() {
        return new SimpleFeatureType[]{SimpleFeatureUserDataConfigurationSet.configureType((SimpleFeatureType)this.gdeltEventType)};
    }

    public String[] getFileExtensionFilters() {
        return new String[]{"zip"};
    }

    public void init(URL baseDirectory) {
    }

    public boolean supportsFile(URL file) {
        return GDELTUtils.validate(file);
    }

    public Schema getAvroSchema() {
        return AvroWholeFile.getClassSchema();
    }

    public CloseableIterator<AvroWholeFile> toAvroObjects(URL input) {
        AvroWholeFile avroFile = new AvroWholeFile();
        avroFile.setOriginalFilePath(input.getPath());
        try {
            avroFile.setOriginalFile(ByteBuffer.wrap(IOUtils.toByteArray((URL)input)));
        }
        catch (IOException e) {
            LOGGER.warn("Unable to read GDELT file: " + input.getPath(), (Throwable)e);
            return new CloseableIterator.Empty();
        }
        return new CloseableIterator.Wrapper((Iterator)Iterators.singletonIterator((Object)avroFile));
    }

    public boolean isUseReducerPreferred() {
        return false;
    }

    public IngestWithMapper<AvroWholeFile, SimpleFeature> ingestWithMapper() {
        return new IngestGDELTFromHdfs(this);
    }

    public IngestWithReducer<AvroWholeFile, ?, ?, SimpleFeature> ingestWithReducer() {
        throw new UnsupportedOperationException("GDELT events cannot be ingested with a reducer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Intentionally catching any possible exception as there may be unknown format issues in a file and we don't want to error partially through parsing")
    protected CloseableIterator<GeoWaveData<SimpleFeature>> toGeoWaveDataInternal(AvroWholeFile hfile, String[] indexNames, String globalVisibility) {
        ArrayList<GeoWaveData> featureData = new ArrayList<GeoWaveData>();
        ByteArrayInputStream in = new ByteArrayInputStream(hfile.getOriginalFile().array());
        ZipInputStream zip = new ZipInputStream(in);
        try {
            zip.getNextEntry();
        }
        catch (IOException e) {
            LOGGER.error("Failed to read ZipEntry from GDELT input file: " + hfile.getOriginalFilePath(), (Throwable)e);
        }
        InputStreamReader isr = new InputStreamReader((InputStream)zip, StringUtils.UTF8_CHARSET);
        BufferedReader br = new BufferedReader(isr);
        GeometryFactory geometryFactory = new GeometryFactory();
        Date timeStamp = null;
        String timestring = "";
        String eventId = "";
        double lat = 0.0;
        double lon = 0.0;
        String actor1Name = "";
        String actor2Name = "";
        String countryCode = "";
        String sourceUrl = "";
        String actor1CC = "";
        String actor2CC = "";
        String numMentions = "";
        String numSources = "";
        String numArticles = "";
        String avgTone = "";
        int lineNumber = 0;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                ++lineNumber;
                try {
                    String[] vals = line.split("\t");
                    if (vals.length < 57 || vals.length > 58) {
                        LOGGER.debug("Invalid GDELT line length: " + vals.length + " tokens found on line " + lineNumber + " of " + hfile.getOriginalFilePath());
                        continue;
                    }
                    int actionGeoType = Integer.parseInt(vals[49]);
                    if (actionGeoType == 0) continue;
                    eventId = vals[0];
                    try {
                        Pair<Double, Double> latLon = GDELTUtils.parseLatLon(vals);
                        if (latLon == null) {
                            LOGGER.debug("No spatial data on line " + lineNumber + " of " + hfile.getOriginalFilePath());
                            continue;
                        }
                        lat = (Double)latLon.getLeft();
                        lon = (Double)latLon.getRight();
                    }
                    catch (Exception e) {
                        LOGGER.debug("Error reading GDELT lat/lon on line " + lineNumber + " of " + hfile.getOriginalFilePath(), (Throwable)e);
                        continue;
                    }
                    Coordinate cord = new Coordinate(lon, lat);
                    this.gdeltEventBuilder.set("geometry", (Object)geometryFactory.createPoint(cord));
                    this.gdeltEventBuilder.set("eventid", (Object)eventId);
                    timestring = vals[1];
                    timeStamp = GDELTUtils.parseDate(timestring);
                    this.gdeltEventBuilder.set("Timestamp", (Object)timeStamp);
                    this.gdeltEventBuilder.set("Latitude", (Object)lat);
                    this.gdeltEventBuilder.set("Longitude", (Object)lon);
                    actor1Name = vals[6];
                    if (actor1Name != null && !actor1Name.isEmpty()) {
                        this.gdeltEventBuilder.set("actor1Name", (Object)actor1Name);
                    }
                    if ((actor2Name = vals[16]) != null && !actor2Name.isEmpty()) {
                        this.gdeltEventBuilder.set("actor2Name", (Object)actor2Name);
                    }
                    if ((countryCode = vals[51]) != null && !countryCode.isEmpty()) {
                        this.gdeltEventBuilder.set("countryCode", (Object)countryCode);
                    }
                    if (vals.length > 57) {
                        sourceUrl = vals[57];
                    }
                    if (sourceUrl != null && !sourceUrl.isEmpty()) {
                        this.gdeltEventBuilder.set("sourceUrl", (Object)sourceUrl);
                    }
                    if (this.includeSupplementalFields) {
                        actor1CC = vals[37];
                        if (actor1CC != null && !actor1CC.isEmpty()) {
                            this.gdeltEventBuilder.set("actor1CountryCode", (Object)actor1CC);
                        }
                        if ((actor2CC = vals[44]) != null && !actor2CC.isEmpty()) {
                            this.gdeltEventBuilder.set("actor2CountryCode", (Object)actor2CC);
                        }
                        if ((numMentions = vals[31]) != null && !numMentions.isEmpty()) {
                            this.gdeltEventBuilder.set("numMentions", (Object)Integer.parseInt(numMentions));
                        }
                        if ((numSources = vals[32]) != null && !numSources.isEmpty()) {
                            this.gdeltEventBuilder.set("numSources", (Object)Integer.parseInt(numSources));
                        }
                        if ((numArticles = vals[33]) != null && !numArticles.isEmpty()) {
                            this.gdeltEventBuilder.set("numArticles", (Object)Integer.parseInt(numArticles));
                        }
                        if ((avgTone = vals[34]) != null && !avgTone.isEmpty()) {
                            this.gdeltEventBuilder.set("avgTone", (Object)Double.parseDouble(avgTone));
                        }
                    }
                    featureData.add(new GeoWaveData(this.eventKey, indexNames, (Object)this.gdeltEventBuilder.buildFeature(eventId)));
                }
                catch (Exception e) {
                    LOGGER.error("Error parsing line: " + line, (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error reading line from GDELT file: " + hfile.getOriginalFilePath(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Reader)br);
            IOUtils.closeQuietly((Reader)isr);
            IOUtils.closeQuietly((InputStream)in);
        }
        return new CloseableIterator.Wrapper(featureData.iterator());
    }

    public Index[] getRequiredIndices() {
        return new Index[0];
    }

    public IngestPluginBase<AvroWholeFile, SimpleFeature> getIngestWithAvroPlugin() {
        return new IngestGDELTFromHdfs(this);
    }

    public Class<? extends CommonIndexValue>[] getSupportedIndexableTypes() {
        return new Class[]{GeometryWrapper.class, Time.class};
    }

    public static class IngestGDELTFromHdfs
    extends AbstractSimpleFeatureIngestPlugin.AbstractIngestSimpleFeatureWithMapper<AvroWholeFile> {
        public IngestGDELTFromHdfs() {
            this(new GDELTIngestPlugin());
        }

        public IngestGDELTFromHdfs(GDELTIngestPlugin parentPlugin) {
            super((AbstractSimpleFeatureIngestPlugin)parentPlugin);
        }
    }
}

