/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.gpx;

import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.IOUtils;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.ingest.GeoWaveData;
import org.locationtech.geowave.format.gpx.GpxIngestPlugin;
import org.locationtech.geowave.format.gpx.GpxUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPXConsumer
implements CloseableIterator<GeoWaveData<SimpleFeature>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GpxIngestPlugin.class);
    private final SimpleFeatureBuilder pointBuilder;
    private final SimpleFeatureBuilder waypointBuilder;
    private final SimpleFeatureBuilder routeBuilder;
    private final SimpleFeatureBuilder trackBuilder;
    protected static final SimpleFeatureType pointType = GpxUtils.createGPXPointDataType();
    protected static final SimpleFeatureType waypointType = GpxUtils.createGPXWaypointDataType();
    protected static final SimpleFeatureType trackType = GpxUtils.createGPXTrackDataType();
    protected static final SimpleFeatureType routeType = GpxUtils.createGPXRouteDataType();
    final InputStream fileStream;
    final String[] indexNames;
    final String inputID;
    final String globalVisibility;
    final Map<String, Map<String, String>> additionalData;
    final boolean uniqueWayPoints;
    final double maxLength;
    final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    final Stack<GPXDataElement> currentElementStack = new Stack();
    GPXDataElement top = null;
    static final NumberFormat LatLongFormat = new DecimalFormat("0000000000");
    XMLEventReader eventReader;
    GeoWaveData<SimpleFeature> nextFeature = null;
    private final Long backupTimestamp;

    public GPXConsumer(InputStream fileStream, String[] indexNames, String inputID, Map<String, Map<String, String>> additionalData, Long backTimestamp, boolean uniqueWayPoints, String globalVisibility, double maxLength) {
        this.fileStream = fileStream;
        this.indexNames = indexNames;
        this.inputID = inputID != null ? inputID : "";
        this.uniqueWayPoints = uniqueWayPoints;
        this.additionalData = additionalData;
        this.globalVisibility = globalVisibility;
        this.maxLength = maxLength;
        this.backupTimestamp = backTimestamp;
        this.top = new GPXDataElement("gpx", this.maxLength);
        this.pointBuilder = new SimpleFeatureBuilder(pointType);
        this.waypointBuilder = new SimpleFeatureBuilder(waypointType);
        this.trackBuilder = new SimpleFeatureBuilder(trackType);
        this.routeBuilder = new SimpleFeatureBuilder(routeType);
        try {
            this.inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            this.eventReader = this.inputFactory.createXMLEventReader(fileStream);
            this.init();
            this.nextFeature = !this.currentElementStack.isEmpty() ? this.getNext() : null;
        }
        catch (Exception e) {
            LOGGER.error("Error processing GPX input stream", (Throwable)e);
            this.nextFeature = null;
        }
    }

    public boolean hasNext() {
        return this.nextFeature != null;
    }

    public GeoWaveData<SimpleFeature> next() {
        GeoWaveData<SimpleFeature> ret = this.nextFeature;
        try {
            this.nextFeature = this.getNext();
        }
        catch (Exception e) {
            LOGGER.error("Error processing GPX input stream", (Throwable)e);
            this.nextFeature = null;
        }
        return ret;
    }

    public void remove() {
    }

    public void close() {
        try {
            this.eventReader.close();
        }
        catch (Exception e2) {
            LOGGER.warn("Unable to close track XML stream", (Throwable)e2);
        }
        IOUtils.closeQuietly((InputStream)this.fileStream);
    }

    private void init() throws IOException, Exception {
        while (this.eventReader.hasNext()) {
            StartElement node;
            XMLEvent event = this.eventReader.nextEvent();
            if (!event.isStartElement() || !"gpx".equals((node = event.asStartElement()).getName().getLocalPart())) continue;
            this.currentElementStack.push(this.top);
            this.processElementAttributes(node, this.top);
            return;
        }
    }

    private GeoWaveData<SimpleFeature> getNext() throws Exception {
        GPXDataElement currentElement = this.currentElementStack.peek();
        GeoWaveData<SimpleFeature> newFeature = null;
        while (newFeature == null && this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (event.isStartElement()) {
                StartElement node = event.asStartElement();
                if (this.processElementValues(node, currentElement)) continue;
                GPXDataElement newElement = new GPXDataElement(event.asStartElement().getName().getLocalPart(), this.maxLength);
                currentElement.addChild(newElement);
                currentElement = newElement;
                this.currentElementStack.push(currentElement);
                this.processElementAttributes(node, currentElement);
                continue;
            }
            if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals(currentElement.elementType)) continue;
            GPXDataElement child = this.currentElementStack.pop();
            newFeature = this.postProcess(child);
            if (newFeature == null && !this.currentElementStack.isEmpty()) {
                currentElement = this.currentElementStack.peek();
                continue;
            }
            if (this.currentElementStack.size() != 1) continue;
            this.top.children.remove(child);
        }
        return newFeature;
    }

    private String getChildCharacters(XMLEventReader eventReader, String elType) throws Exception {
        StringBuilder buf = new StringBuilder();
        XMLEvent event = eventReader.nextEvent();
        while (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals(elType)) {
            if (event.isCharacters()) {
                buf.append(event.asCharacters().getData());
            }
            event = eventReader.nextEvent();
        }
        return buf.toString().trim();
    }

    private void processElementAttributes(StartElement node, GPXDataElement element) throws Exception {
        Iterator<Attribute> attributes = node.getAttributes();
        while (attributes.hasNext()) {
            Attribute a = attributes.next();
            if (a.getName().getLocalPart().equals("lon")) {
                element.lon = Double.parseDouble(a.getValue());
                continue;
            }
            if (!a.getName().getLocalPart().equals("lat")) continue;
            element.lat = Double.parseDouble(a.getValue());
        }
    }

    private boolean processElementValues(StartElement node, GPXDataElement element) throws Exception {
        switch (node.getName().getLocalPart()) {
            case "ele": {
                element.elevation = Double.parseDouble(this.getChildCharacters(this.eventReader, "ele"));
                break;
            }
            case "magvar": {
                element.magvar = Double.parseDouble(this.getChildCharacters(this.eventReader, "magvar"));
                break;
            }
            case "geoidheight": {
                element.geoidheight = Double.parseDouble(this.getChildCharacters(this.eventReader, "geoidheight"));
                break;
            }
            case "name": {
                element.name = this.getChildCharacters(this.eventReader, "name");
                break;
            }
            case "cmt": {
                element.cmt = this.getChildCharacters(this.eventReader, "cmt");
                break;
            }
            case "desc": {
                element.desc = this.getChildCharacters(this.eventReader, "desc");
                break;
            }
            case "src": {
                element.src = this.getChildCharacters(this.eventReader, "src");
                break;
            }
            case "link": {
                element.link = this.getChildCharacters(this.eventReader, "link");
                break;
            }
            case "sym": {
                element.sym = this.getChildCharacters(this.eventReader, "sym");
                break;
            }
            case "type": {
                element.type = this.getChildCharacters(this.eventReader, "type");
                break;
            }
            case "sat": {
                element.sat = Integer.parseInt(this.getChildCharacters(this.eventReader, "sat"));
                break;
            }
            case "dgpsid": {
                element.dgpsid = Integer.parseInt(this.getChildCharacters(this.eventReader, "dgpsid"));
                break;
            }
            case "vdop": {
                element.vdop = Double.parseDouble(this.getChildCharacters(this.eventReader, "vdop"));
                break;
            }
            case "fix": {
                element.fix = this.getChildCharacters(this.eventReader, "fix");
                break;
            }
            case "course": {
                element.course = Double.parseDouble(this.getChildCharacters(this.eventReader, "course"));
                break;
            }
            case "speed": {
                element.speed = Double.parseDouble(this.getChildCharacters(this.eventReader, "speed"));
                break;
            }
            case "hdop": {
                element.hdop = Double.parseDouble(this.getChildCharacters(this.eventReader, "hdop"));
                break;
            }
            case "pdop": {
                element.pdop = Double.parseDouble(this.getChildCharacters(this.eventReader, "pdop"));
                break;
            }
            case "url": {
                element.url = this.getChildCharacters(this.eventReader, "url");
                break;
            }
            case "number": {
                element.number = this.getChildCharacters(this.eventReader, "number");
                break;
            }
            case "urlname": {
                element.urlname = this.getChildCharacters(this.eventReader, "urlname");
                break;
            }
            case "time": {
                try {
                    element.timestamp = GpxUtils.parseDateSeconds(this.getChildCharacters(this.eventReader, "time")).getTime();
                }
                catch (ParseException e) {
                    LOGGER.warn("Unable to parse date in seconds", (Throwable)e);
                    try {
                        element.timestamp = GpxUtils.parseDateMillis(this.getChildCharacters(this.eventReader, "time")).getTime();
                    }
                    catch (ParseException e2) {
                        LOGGER.warn("Unable to parse date in millis", (Throwable)e2);
                    }
                }
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private GeoWaveData<SimpleFeature> postProcess(GPXDataElement element) {
        switch (element.elementType) {
            case "trk": {
                if (element.children == null || !element.build(this.trackBuilder, this.backupTimestamp, true)) break;
                this.trackBuilder.set("TrackId", (Object)(this.inputID.length() > 0 ? this.inputID : element.composeID("", false, true)));
                return GPXConsumer.buildGeoWaveDataInstance(element.composeID(this.inputID, false, true), this.indexNames, "gpxtrack", this.trackBuilder, this.additionalData.get(element.getPath()));
            }
            case "rte": {
                if (element.children == null || !element.build(this.routeBuilder, this.backupTimestamp, true)) break;
                this.trackBuilder.set("TrackId", (Object)(this.inputID.length() > 0 ? this.inputID : element.composeID("", false, true)));
                return GPXConsumer.buildGeoWaveDataInstance(element.composeID(this.inputID, false, true), this.indexNames, "gpxroute", this.routeBuilder, this.additionalData.get(element.getPath()));
            }
            case "wpt": {
                if (!element.build(this.waypointBuilder, this.backupTimestamp, false)) break;
                return GPXConsumer.buildGeoWaveDataInstance(element.composeID(this.uniqueWayPoints ? "" : this.inputID, true, !this.uniqueWayPoints), this.indexNames, "gpxwaypoint", this.waypointBuilder, this.additionalData.get(element.getPath()));
            }
            case "rtept": {
                if (!element.build(this.waypointBuilder, this.backupTimestamp, false)) break;
                return GPXConsumer.buildGeoWaveDataInstance(element.composeID(this.inputID, true, true), this.indexNames, "gpxwaypoint", this.waypointBuilder, this.additionalData.get(element.getPath()));
            }
            case "trkseg": {
                break;
            }
            case "trkpt": {
                if (!element.build(this.pointBuilder, this.backupTimestamp, false)) break;
                if (element.timestamp == null && this.backupTimestamp == null) {
                    this.pointBuilder.set("Timestamp", null);
                }
                return GPXConsumer.buildGeoWaveDataInstance(element.composeID(this.inputID, false, true), this.indexNames, "gpxpoint", this.pointBuilder, this.additionalData.get(element.getPath()));
            }
        }
        return null;
    }

    private static void setAttribute(SimpleFeatureBuilder builder, String name, Object obj) {
        if (builder.getFeatureType().getDescriptor(name) != null && obj != null) {
            builder.set(name, obj);
        }
    }

    private static GeoWaveData<SimpleFeature> buildGeoWaveDataInstance(String id, String[] indexNames, String key, SimpleFeatureBuilder builder, Map<String, String> additionalDataSet) {
        if (additionalDataSet != null) {
            for (Map.Entry<String, String> entry : additionalDataSet.entrySet()) {
                builder.set(entry.getKey(), (Object)entry.getValue());
            }
        }
        return new GeoWaveData(key, indexNames, (Object)builder.buildFeature(id));
    }

    private static String toID(Double val) {
        return LatLongFormat.format(val * 1.0E7);
    }

    private static class GPXDataElement {
        Long timestamp = null;
        Integer dgpsid = null;
        Double elevation = null;
        Double lat = null;
        Double lon = null;
        Double course = null;
        Double speed = null;
        Double magvar = null;
        Double geoidheight = null;
        String name = null;
        String cmt = null;
        String desc = null;
        String src = null;
        String fix = null;
        String link = null;
        String sym = null;
        String type = null;
        String url = null;
        String urlname = null;
        Integer sat = null;
        Double hdop = null;
        Double pdop = null;
        Double vdop = null;
        String elementType;
        String number = null;
        Coordinate coordinate = null;
        List<GPXDataElement> children = null;
        GPXDataElement parent;
        long id = 0L;
        int childIdCounter = 0;
        double maxLineLength = Double.MAX_VALUE;

        public GPXDataElement(String myElType) {
            this.elementType = myElType;
        }

        public GPXDataElement(String myElType, double maxLength) {
            this.elementType = myElType;
            this.maxLineLength = maxLength;
        }

        public String toString() {
            return this.elementType;
        }

        public String getPath() {
            StringBuffer buf = new StringBuffer();
            GPXDataElement currentGP = this.parent;
            buf.append(this.elementType);
            while (currentGP != null) {
                buf.insert(0, '.');
                buf.insert(0, currentGP.elementType);
                currentGP = currentGP.parent;
            }
            return buf.toString();
        }

        public void addChild(GPXDataElement child) {
            if (this.children == null) {
                this.children = new ArrayList<GPXDataElement>();
            }
            this.children.add(child);
            child.parent = this;
            child.id = ++this.childIdCounter;
        }

        public String composeID(String prefix, boolean includeLatLong, boolean includeParent) {
            if (this.parent == null && prefix != null && prefix.length() > 0) {
                return prefix;
            }
            StringBuffer buf = new StringBuffer();
            if (this.parent != null && includeParent) {
                String parentID = this.parent.composeID(prefix, false, true);
                if (parentID.length() > 0) {
                    buf.append(parentID);
                    buf.append('_');
                }
                if (this.number != null && this.number.length() > 0) {
                    buf.append(this.number);
                } else {
                    buf.append(this.id);
                }
                buf.append('_');
            }
            if (this.name != null && this.name.length() > 0) {
                buf.append(this.name.replaceAll("\\s+", "_"));
                buf.append('_');
            }
            if (includeLatLong && this.lat != null && this.lon != null) {
                buf.append(GPXConsumer.toID(this.lat)).append('_').append(GPXConsumer.toID(this.lon));
                buf.append('_');
            }
            if (buf.length() > 0) {
                buf.deleteCharAt(buf.length() - 1);
            }
            return buf.toString();
        }

        public Coordinate getCoordinate() {
            if (this.coordinate != null) {
                return this.coordinate;
            }
            if (this.lat != null && this.lon != null) {
                this.coordinate = new Coordinate(this.lon.doubleValue(), this.lat.doubleValue());
            }
            return this.coordinate;
        }

        public boolean isCoordinate() {
            return this.lat != null && this.lon != null;
        }

        public List<Coordinate> buildCoordinates() {
            if (this.isCoordinate()) {
                return Arrays.asList(this.getCoordinate());
            }
            ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
            for (int i = 0; this.children != null && i < this.children.size(); ++i) {
                coords.addAll(this.children.get(i).buildCoordinates());
            }
            return coords;
        }

        private Long getStartTime() {
            if (this.children == null) {
                return this.timestamp;
            }
            long minTime = Long.MAX_VALUE;
            for (GPXDataElement element : this.children) {
                Long t = element.getStartTime();
                if (t == null) continue;
                minTime = Math.min(t, minTime);
            }
            return minTime < Long.MAX_VALUE ? Long.valueOf(minTime) : null;
        }

        private Long getEndTime() {
            if (this.children == null) {
                return this.timestamp;
            }
            long maxTime = 0L;
            for (GPXDataElement element : this.children) {
                Long t = element.getEndTime();
                if (t == null) continue;
                maxTime = Math.max(t, maxTime);
            }
            return maxTime > 0L ? Long.valueOf(maxTime) : null;
        }

        public boolean build(SimpleFeatureBuilder builder, Long backupTimestamp, boolean timeRange) {
            if (this.lon != null && this.lat != null) {
                Coordinate p = this.getCoordinate();
                builder.set("geometry", (Object)GeometryUtils.GEOMETRY_FACTORY.createPoint(p));
                builder.set("Latitude", (Object)this.lat);
                builder.set("Longitude", (Object)this.lon);
            }
            GPXConsumer.setAttribute(builder, "Elevation", this.elevation);
            GPXConsumer.setAttribute(builder, "Course", this.course);
            GPXConsumer.setAttribute(builder, "Speed", this.speed);
            GPXConsumer.setAttribute(builder, "Source", this.src);
            GPXConsumer.setAttribute(builder, "Link", this.link);
            GPXConsumer.setAttribute(builder, "URL", this.url);
            GPXConsumer.setAttribute(builder, "URLName", this.urlname);
            GPXConsumer.setAttribute(builder, "MagneticVariation", this.magvar);
            GPXConsumer.setAttribute(builder, "Satellites", this.sat);
            GPXConsumer.setAttribute(builder, "Symbol", this.sym);
            GPXConsumer.setAttribute(builder, "VDOP", this.vdop);
            GPXConsumer.setAttribute(builder, "HDOP", this.hdop);
            GPXConsumer.setAttribute(builder, "GeoHeight", this.geoidheight);
            GPXConsumer.setAttribute(builder, "Fix", this.fix);
            GPXConsumer.setAttribute(builder, "Station", this.dgpsid);
            GPXConsumer.setAttribute(builder, "PDOP", this.pdop);
            GPXConsumer.setAttribute(builder, "Classification", this.type);
            GPXConsumer.setAttribute(builder, "Name", this.name);
            GPXConsumer.setAttribute(builder, "Comment", this.cmt);
            GPXConsumer.setAttribute(builder, "Description", this.desc);
            GPXConsumer.setAttribute(builder, "Symbol", this.sym);
            if (this.timestamp != null) {
                GPXConsumer.setAttribute(builder, "Timestamp", new Date(this.timestamp));
            } else if (backupTimestamp != null && !timeRange) {
                GPXConsumer.setAttribute(builder, "Timestamp", new Date(backupTimestamp));
            }
            if (this.children != null) {
                boolean setDuration = true;
                List<Coordinate> childSequence = this.buildCoordinates();
                int childCoordCount = childSequence.size();
                if (childCoordCount <= 1) {
                    return false;
                }
                LineString geom = GeometryUtils.GEOMETRY_FACTORY.createLineString(childSequence.toArray(new Coordinate[childSequence.size()]));
                if (geom.isEmpty() || geom.getEnvelopeInternal().maxExtent() > this.maxLineLength) {
                    return false;
                }
                builder.set("geometry", (Object)geom);
                GPXConsumer.setAttribute(builder, "NumberPoints", childCoordCount);
                Long minTime = this.getStartTime();
                if (minTime != null) {
                    builder.set("StartTimeStamp", (Object)new Date(minTime));
                } else if (this.timestamp != null && timeRange) {
                    minTime = this.timestamp;
                    builder.set("StartTimeStamp", (Object)new Date(this.timestamp));
                } else if (backupTimestamp != null && timeRange) {
                    minTime = backupTimestamp;
                    builder.set("StartTimeStamp", (Object)new Date(backupTimestamp));
                } else {
                    setDuration = false;
                }
                Long maxTime = this.getEndTime();
                if (maxTime != null) {
                    builder.set("EndTimeStamp", (Object)new Date(maxTime));
                } else if (this.timestamp != null && timeRange) {
                    maxTime = this.timestamp;
                    builder.set("EndTimeStamp", (Object)new Date(this.timestamp));
                } else if (backupTimestamp != null && timeRange) {
                    maxTime = backupTimestamp;
                    builder.set("EndTimeStamp", (Object)new Date(backupTimestamp));
                } else {
                    setDuration = false;
                }
                if (setDuration) {
                    builder.set("Duration", (Object)(maxTime - minTime));
                }
            }
            return true;
        }
    }
}

