/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.gpx;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.stream.XMLStreamException;
import jersey.repackaged.com.google.common.collect.Iterators;
import org.apache.avro.Schema;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.locationtech.geowave.adapter.vector.ingest.AbstractSimpleFeatureIngestPlugin;
import org.locationtech.geowave.adapter.vector.util.SimpleFeatureUserDataConfigurationSet;
import org.locationtech.geowave.core.geotime.store.dimension.GeometryWrapper;
import org.locationtech.geowave.core.geotime.store.dimension.Time;
import org.locationtech.geowave.core.ingest.hdfs.mapreduce.IngestWithMapper;
import org.locationtech.geowave.core.ingest.hdfs.mapreduce.IngestWithReducer;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.index.CommonIndexValue;
import org.locationtech.geowave.core.store.ingest.GeoWaveData;
import org.locationtech.geowave.core.store.ingest.IngestPluginBase;
import org.locationtech.geowave.format.gpx.AvroGpxTrack;
import org.locationtech.geowave.format.gpx.GPXConsumer;
import org.locationtech.geowave.format.gpx.GpxUtils;
import org.locationtech.geowave.format.gpx.MaxExtentOptProvider;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class GpxIngestPlugin
extends AbstractSimpleFeatureIngestPlugin<AvroGpxTrack> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GpxIngestPlugin.class);
    private static final String TAG_SEPARATOR = " ||| ";
    private Map<Long, AvroGpxTrack> metadata = null;
    private MaxExtentOptProvider extentOptProvider = new MaxExtentOptProvider();
    private static final AtomicLong currentFreeTrackId = new AtomicLong(0L);

    public String[] getFileExtensionFilters() {
        return new String[]{"xml", "gpx"};
    }

    public void init(URL baseDirectory) {
        URL f = null;
        try {
            f = new URL(baseDirectory.toString().concat("metadata.xml"));
        }
        catch (MalformedURLException e1) {
            LOGGER.info("Invalid URL for metadata.xml. No metadata will be loaded", (Throwable)e1);
        }
        if (f != null) {
            try {
                long time = System.currentTimeMillis();
                this.metadata = GpxUtils.parseOsmMetadata(f);
                time = System.currentTimeMillis() - time;
                String timespan = String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(time), TimeUnit.MILLISECONDS.toSeconds(time) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(time)));
                LOGGER.info("Metadata parsed in in " + timespan + " for " + this.metadata.size() + " tracks");
            }
            catch (FileNotFoundException | XMLStreamException e) {
                LOGGER.warn("Unable to read OSM metadata file: " + f.getPath(), (Throwable)e);
            }
        }
    }

    public boolean supportsFile(URL file) {
        if (FilenameUtils.getName((String)file.getPath()).toLowerCase(Locale.ENGLISH).endsWith("gpx")) {
            return true;
        }
        if ("metadata.xml".equals(FilenameUtils.getName((String)file.getPath()))) {
            return false;
        }
        try {
            return GpxUtils.validateGpx(file);
        }
        catch (IOException | SAXException e) {
            LOGGER.warn("Unable to read file:" + file.getPath(), (Throwable)e);
            return false;
        }
    }

    protected SimpleFeatureType[] getTypes() {
        return new SimpleFeatureType[]{SimpleFeatureUserDataConfigurationSet.configureType((SimpleFeatureType)GPXConsumer.pointType), SimpleFeatureUserDataConfigurationSet.configureType((SimpleFeatureType)GPXConsumer.waypointType), SimpleFeatureUserDataConfigurationSet.configureType((SimpleFeatureType)GPXConsumer.trackType), SimpleFeatureUserDataConfigurationSet.configureType((SimpleFeatureType)GPXConsumer.routeType)};
    }

    public Schema getAvroSchema() {
        return AvroGpxTrack.getClassSchema();
    }

    public CloseableIterator<AvroGpxTrack> toAvroObjects(URL input) {
        AvroGpxTrack track = null;
        if (this.metadata != null) {
            try {
                long id = Long.parseLong(FilenameUtils.getBaseName((String)input.getPath()));
                track = this.metadata.remove(id);
            }
            catch (NumberFormatException e) {
                LOGGER.info("OSM metadata found, but track file name is not a numeric ID");
            }
        }
        if (track == null) {
            track = new AvroGpxTrack();
            track.setTrackid(currentFreeTrackId.getAndIncrement());
        }
        try {
            track.setGpxfile(ByteBuffer.wrap(IOUtils.toByteArray((URL)input)));
        }
        catch (IOException e) {
            LOGGER.warn("Unable to read GPX file: " + input.getPath(), (Throwable)e);
        }
        return new CloseableIterator.Wrapper((Iterator)Iterators.singletonIterator((Object)((Object)track)));
    }

    public boolean isUseReducerPreferred() {
        return false;
    }

    public IngestWithMapper<AvroGpxTrack, SimpleFeature> ingestWithMapper() {
        return new IngestGpxTrackFromHdfs(this);
    }

    public IngestWithReducer<AvroGpxTrack, ?, ?, SimpleFeature> ingestWithReducer() {
        throw new UnsupportedOperationException("GPX tracks cannot be ingested with a reducer");
    }

    protected CloseableIterator<GeoWaveData<SimpleFeature>> toGeoWaveDataInternal(AvroGpxTrack gpxTrack, String[] indexNames, String globalVisibility) {
        ByteArrayInputStream in = new ByteArrayInputStream(gpxTrack.getGpxfile().array());
        try {
            return new GPXConsumer(in, indexNames, gpxTrack.getTrackid() == null ? "" : gpxTrack.getTrackid().toString(), this.getAdditionalData(gpxTrack), gpxTrack.getTimestamp(), false, globalVisibility, this.extentOptProvider.getMaxExtent());
        }
        catch (Exception e) {
            LOGGER.warn("Unable to convert GpxTrack to GeoWaveData", (Throwable)e);
            return null;
        }
    }

    public Index[] getRequiredIndices() {
        return new Index[0];
    }

    private Map<String, Map<String, String>> getAdditionalData(AvroGpxTrack gpxTrack) {
        HashMap<String, Map<String, String>> pathDataSet = new HashMap<String, Map<String, String>>();
        HashMap<String, String> dataSet = new HashMap<String, String>();
        pathDataSet.put("gpx.trk", dataSet);
        if (gpxTrack.getTrackid() != null) {
            dataSet.put("TrackId", gpxTrack.getTrackid().toString());
        }
        if (gpxTrack.getUserid() != null) {
            dataSet.put("UserId", gpxTrack.getUserid().toString());
        }
        if (gpxTrack.getUser() != null) {
            dataSet.put("User", gpxTrack.getUser().toString());
        }
        if (gpxTrack.getDescription() != null) {
            dataSet.put("Description", gpxTrack.getDescription().toString());
        }
        if (gpxTrack.getTags() != null && gpxTrack.getTags().size() > 0) {
            String tags = StringUtils.join(gpxTrack.getTags(), (String)TAG_SEPARATOR);
            dataSet.put("Tags", tags);
        } else {
            dataSet.put("Tags", null);
        }
        return pathDataSet;
    }

    public IngestPluginBase<AvroGpxTrack, SimpleFeature> getIngestWithAvroPlugin() {
        return new IngestGpxTrackFromHdfs(this);
    }

    public Class<? extends CommonIndexValue>[] getSupportedIndexableTypes() {
        return new Class[]{GeometryWrapper.class, Time.class};
    }

    public void setExtentOptionProvider(MaxExtentOptProvider extentOptProvider) {
        this.extentOptProvider = extentOptProvider;
    }

    public MaxExtentOptProvider getExtentOptionProvider() {
        return this.extentOptProvider;
    }

    public static class IngestGpxTrackFromHdfs
    extends AbstractSimpleFeatureIngestPlugin.AbstractIngestSimpleFeatureWithMapper<AvroGpxTrack> {
        public IngestGpxTrackFromHdfs() {
            this(new GpxIngestPlugin());
        }

        public IngestGpxTrackFromHdfs(GpxIngestPlugin parentPlugin) {
            super((AbstractSimpleFeatureIngestPlugin)parentPlugin);
        }
    }
}

