/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.gpx;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geowave.format.gpx.AvroGpxTrack;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class GpxUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(GpxUtils.class);
    private static final String SCHEMA_RESOURCE_PACKAGE = "org/locationtech/geowave/types/gpx/";
    private static final String SCHEMA_GPX_1_0_LOCATION = "org/locationtech/geowave/types/gpx/gpx-1_0.xsd";
    private static final String SCHEMA_GPX_1_1_LOCATION = "org/locationtech/geowave/types/gpx/gpx-1_1.xsd";
    private static final URL SCHEMA_GPX_1_0_URL = GpxUtils.class.getClassLoader().getResource("org/locationtech/geowave/types/gpx/gpx-1_0.xsd");
    private static final URL SCHEMA_GPX_1_1_URL = GpxUtils.class.getClassLoader().getResource("org/locationtech/geowave/types/gpx/gpx-1_1.xsd");
    private static final Validator SCHEMA_GPX_1_0_VALIDATOR = GpxUtils.getSchemaValidator(SCHEMA_GPX_1_0_URL);
    private static final Validator SCHEMA_GPX_1_1_VALIDATOR = GpxUtils.getSchemaValidator(SCHEMA_GPX_1_1_URL);
    public static final String GPX_POINT_FEATURE = "gpxpoint";
    public static final String GPX_ROUTE_FEATURE = "gpxroute";
    public static final String GPX_TRACK_FEATURE = "gpxtrack";
    public static final String GPX_WAYPOINT_FEATURE = "gpxwaypoint";
    private static final ThreadLocal<DateFormat> dateFormatSeconds = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        }
    };
    private static final ThreadLocal<DateFormat> dateFormatMillis = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        }
    };

    public static Date parseDateSeconds(String source) throws ParseException {
        return dateFormatSeconds.get().parse(source);
    }

    public static Date parseDateMillis(String source) throws ParseException {
        return dateFormatMillis.get().parse(source);
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"})
    public static Map<Long, AvroGpxTrack> parseOsmMetadata(URL metadataFile) throws FileNotFoundException, XMLStreamException {
        HashMap<Long, AvroGpxTrack> metadata = new HashMap<Long, AvroGpxTrack>();
        try (InputStream fis = metadataFile.openStream();
             BufferedInputStream in = new BufferedInputStream(fis);){
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            XMLEventReader eventReader = null;
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            eventReader = inputFactory.createXMLEventReader(in);
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement()) continue;
                StartElement node = event.asStartElement();
                switch (node.getName().getLocalPart()) {
                    case "gpxFile": {
                        AvroGpxTrack gt = new AvroGpxTrack();
                        node = event.asStartElement();
                        Iterator<Attribute> attributes = node.getAttributes();
                        while (attributes.hasNext()) {
                            Attribute a = attributes.next();
                            switch (a.getName().getLocalPart()) {
                                case "id": {
                                    gt.setTrackid(Long.parseLong(a.getValue()));
                                    break;
                                }
                                case "timestamp": {
                                    try {
                                        gt.setTimestamp(GpxUtils.parseDateSeconds(a.getValue()).getTime());
                                    }
                                    catch (Exception t) {
                                        try {
                                            gt.setTimestamp(GpxUtils.parseDateMillis(a.getValue()).getTime());
                                        }
                                        catch (Exception t2) {
                                            LOGGER.warn("Unable to format time: " + a.getValue(), (Throwable)t2);
                                        }
                                    }
                                    break;
                                }
                                case "points": {
                                    gt.setPoints(Long.parseLong(a.getValue()));
                                    break;
                                }
                                case "visibility": {
                                    gt.setVisibility(a.getValue());
                                    break;
                                }
                                case "uid": {
                                    gt.setUserid(Long.parseLong(a.getValue()));
                                    break;
                                }
                                case "user": {
                                    gt.setUser(a.getValue());
                                }
                            }
                        }
                        while (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals("gpxFile")) {
                            if (event.isStartElement()) {
                                node = event.asStartElement();
                                switch (node.getName().getLocalPart()) {
                                    case "description": {
                                        event = eventReader.nextEvent();
                                        if (!event.isCharacters()) break;
                                        gt.setDescription(event.asCharacters().getData());
                                        break;
                                    }
                                    case "tags": {
                                        ArrayList<String> tags = new ArrayList<String>();
                                        while (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals("tags")) {
                                            if (event.isStartElement() && (node = event.asStartElement()).getName().getLocalPart().equals("tag") && (event = eventReader.nextEvent()).isCharacters()) {
                                                tags.add(event.asCharacters().getData());
                                            }
                                            event = eventReader.nextEvent();
                                        }
                                        gt.setTags(tags);
                                        break;
                                    }
                                }
                            }
                            event = eventReader.nextEvent();
                        }
                        metadata.put(gt.getTrackid(), gt);
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.info("Could not create the FileInputStream for OSM metadata.", (Throwable)e);
        }
        return metadata;
    }

    public static SimpleFeatureType createGPXTrackDataType() {
        SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        simpleFeatureTypeBuilder.setName(GPX_TRACK_FEATURE);
        AttributeTypeBuilder attributeTypeBuilder = new AttributeTypeBuilder();
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Geometry.class).nillable(true).buildDescriptor("geometry"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Name"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Date.class).nillable(true).buildDescriptor("StartTimeStamp"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Date.class).nillable(true).buildDescriptor("EndTimeStamp"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Long.class).nillable(true).buildDescriptor("Duration"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Long.class).nillable(true).buildDescriptor("NumberPoints"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("TrackId"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Long.class).nillable(true).buildDescriptor("UserId"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("User"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Description"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Tags"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Source"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Comment"));
        return simpleFeatureTypeBuilder.buildFeatureType();
    }

    public static SimpleFeatureType createGPXRouteDataType() {
        SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        simpleFeatureTypeBuilder.setName(GPX_ROUTE_FEATURE);
        AttributeTypeBuilder attributeTypeBuilder = new AttributeTypeBuilder();
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Geometry.class).nillable(true).buildDescriptor("geometry"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Name"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Long.class).nillable(true).buildDescriptor("NumberPoints"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("TrackId"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Symbol"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("User"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Description"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Source"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Comment"));
        return simpleFeatureTypeBuilder.buildFeatureType();
    }

    public static SimpleFeatureType createGPXPointDataType() {
        SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        simpleFeatureTypeBuilder.setName(GPX_POINT_FEATURE);
        AttributeTypeBuilder attributeTypeBuilder = new AttributeTypeBuilder();
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Geometry.class).nillable(true).buildDescriptor("geometry"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Double.class).nillable(true).buildDescriptor("Latitude"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Double.class).nillable(true).buildDescriptor("Longitude"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Double.class).nillable(true).buildDescriptor("Elevation"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Date.class).nillable(true).buildDescriptor("Timestamp"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Comment"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Integer.class).nillable(true).buildDescriptor("Satellites"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Double.class).nillable(true).buildDescriptor("VDOP"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Double.class).nillable(true).buildDescriptor("HDOP"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Double.class).nillable(true).buildDescriptor("PDOP"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Symbol"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Classification"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Double.class).nillable(true).buildDescriptor("GeoHeight"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Double.class).nillable(true).buildDescriptor("Course"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Double.class).nillable(true).buildDescriptor("MagneticVariation"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Source"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Link"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Fix"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Integer.class).nillable(true).buildDescriptor("Station"));
        return simpleFeatureTypeBuilder.buildFeatureType();
    }

    public static SimpleFeatureType createGPXWaypointDataType() {
        SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        simpleFeatureTypeBuilder.setName(GPX_WAYPOINT_FEATURE);
        AttributeTypeBuilder attributeTypeBuilder = new AttributeTypeBuilder();
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Geometry.class).nillable(true).buildDescriptor("geometry"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Double.class).nillable(true).buildDescriptor("Latitude"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Double.class).nillable(true).buildDescriptor("Longitude"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Double.class).nillable(true).buildDescriptor("Elevation"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Name"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Comment"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Description"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Symbol"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Link"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Source"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Integer.class).nillable(true).buildDescriptor("Station"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("URL"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("URLName"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(String.class).nillable(true).buildDescriptor("Fix"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Double.class).nillable(true).buildDescriptor("MagneticVariation"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Double.class).nillable(true).buildDescriptor("GeoHeight"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Double.class).nillable(true).buildDescriptor("Elevation"));
        return simpleFeatureTypeBuilder.buildFeatureType();
    }

    private static Validator getSchemaValidator(URL schemaUrl) {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = schemaFactory.newSchema(schemaUrl);
            return schema.newValidator();
        }
        catch (SAXException e) {
            LOGGER.warn("Unable to read schema '" + schemaUrl.toString() + "'", (Throwable)e);
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public static boolean validateGpx(URL gpxDocument) throws SAXException, IOException {
        boolean bl;
        StreamSource xmlFile;
        Throwable throwable;
        InputStream in;
        block26: {
            block27: {
                in = gpxDocument.openStream();
                throwable = null;
                xmlFile = new StreamSource(in);
                SCHEMA_GPX_1_1_VALIDATOR.validate(xmlFile);
                bl = true;
                if (in == null) break block26;
                if (throwable == null) break block27;
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block26;
            }
            in.close();
        }
        return bl;
        {
            catch (SAXException e) {
                boolean bl2;
                block28: {
                    block29: {
                        LOGGER.info("XML file '' failed GPX 1.1 validation", (Throwable)e);
                        SCHEMA_GPX_1_0_VALIDATOR.validate(xmlFile);
                        bl2 = true;
                        if (in == null) break block28;
                        if (throwable == null) break block29;
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block28;
                    }
                    in.close();
                }
                return bl2;
                {
                    catch (SAXException e2) {
                        boolean bl3;
                        block30: {
                            block31: {
                                LOGGER.info("XML file '' failed GPX 1.0 validation", (Throwable)e2);
                                bl3 = false;
                                if (in == null) break block30;
                                if (throwable == null) break block31;
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                break block30;
                            }
                            in.close();
                        }
                        return bl3;
                        catch (Throwable throwable5) {
                            try {
                                try {
                                    throwable = throwable5;
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    if (in != null) {
                                        if (throwable != null) {
                                            try {
                                                in.close();
                                            }
                                            catch (Throwable throwable7) {
                                                throwable.addSuppressed(throwable7);
                                            }
                                        } else {
                                            in.close();
                                        }
                                    }
                                    throw throwable6;
                                }
                            }
                            catch (IOException e3) {
                                LOGGER.info("Unable read " + gpxDocument.getPath(), (Throwable)e3);
                                return false;
                            }
                        }
                    }
                }
            }
        }
    }
}

