/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.gpx;

import com.beust.jcommander.Parameter;
import java.nio.ByteBuffer;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.jts.geom.Geometry;

public class MaxExtentOptProvider
implements Persistable {
    @Parameter(names={"--maxLength"}, description="Maximum extent (in both dimensions) for gpx track in degrees. Used to remove excessively long gpx tracks")
    private double maxExtent = Double.MAX_VALUE;

    public byte[] toBinary() {
        byte[] backingBuffer = new byte[8];
        ByteBuffer buf = ByteBuffer.wrap(backingBuffer);
        buf.putDouble(this.maxExtent);
        return backingBuffer;
    }

    public void fromBinary(byte[] bytes) {
        this.maxExtent = ByteBuffer.wrap(bytes).getDouble();
    }

    public double getMaxExtent() {
        return this.maxExtent;
    }

    public boolean filterMaxExtent(Geometry geom) {
        return geom.getEnvelopeInternal().maxExtent() < this.maxExtent;
    }
}

