/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.tdrive;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.avro.Schema;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.locationtech.geowave.adapter.vector.ingest.AbstractSimpleFeatureIngestPlugin;
import org.locationtech.geowave.adapter.vector.util.SimpleFeatureUserDataConfigurationSet;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.ingest.hdfs.mapreduce.IngestWithMapper;
import org.locationtech.geowave.core.ingest.hdfs.mapreduce.IngestWithReducer;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.ingest.GeoWaveData;
import org.locationtech.geowave.core.store.ingest.IngestPluginBase;
import org.locationtech.geowave.format.tdrive.AvroTdrivePoint;
import org.locationtech.geowave.format.tdrive.TdriveUtils;
import org.locationtech.jts.geom.Coordinate;
import org.mortbay.log.Log;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TdriveIngestPlugin
extends AbstractSimpleFeatureIngestPlugin<AvroTdrivePoint> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TdriveIngestPlugin.class);
    private final SimpleFeatureBuilder tdrivepointBuilder;
    private final SimpleFeatureType tdrivepointType = TdriveUtils.createTdrivePointDataType();

    public TdriveIngestPlugin() {
        this.tdrivepointBuilder = new SimpleFeatureBuilder(this.tdrivepointType);
    }

    public String[] getFileExtensionFilters() {
        return new String[]{"csv", "txt"};
    }

    public void init(URL baseDirectory) {
    }

    public boolean supportsFile(URL file) {
        return TdriveUtils.validate(file);
    }

    protected SimpleFeatureType[] getTypes() {
        return new SimpleFeatureType[]{SimpleFeatureUserDataConfigurationSet.configureType((SimpleFeatureType)this.tdrivepointType)};
    }

    public Schema getAvroSchema() {
        return AvroTdrivePoint.getClassSchema();
    }

    public CloseableIterator<AvroTdrivePoint> toAvroObjects(final URL input) {
        try {
            final InputStream fis = input.openStream();
            final BufferedReader fr = new BufferedReader(new InputStreamReader(fis, StringUtils.UTF8_CHARSET));
            final BufferedReader br = new BufferedReader(fr);
            return new CloseableIterator<AvroTdrivePoint>(){
                AvroTdrivePoint next = null;
                long pointInstance = 0L;

                private void computeNext() {
                    block5: {
                        if (this.next == null) {
                            try {
                                String line = br.readLine();
                                if (line == null) break block5;
                                String[] vals = line.split(",");
                                this.next = new AvroTdrivePoint();
                                this.next.setTaxiid(Integer.parseInt(vals[0]));
                                try {
                                    this.next.setTimestamp(TdriveUtils.parseDate(vals[1]).getTime());
                                }
                                catch (ParseException e) {
                                    this.next.setTimestamp(0L);
                                    LOGGER.warn("Couldn't parse time format: " + vals[1], (Throwable)e);
                                }
                                this.next.setLongitude(Double.parseDouble(vals[2]));
                                this.next.setLatitude(Double.parseDouble(vals[3]));
                                this.next.setPointinstance(this.pointInstance);
                                ++this.pointInstance;
                            }
                            catch (Exception e) {
                                Log.warn((String)("Error parsing tdrive file: " + input.getPath()), (Throwable)e);
                            }
                        }
                    }
                }

                public boolean hasNext() {
                    this.computeNext();
                    return this.next != null;
                }

                public AvroTdrivePoint next() {
                    this.computeNext();
                    AvroTdrivePoint retVal = this.next;
                    this.next = null;
                    return retVal;
                }

                public void close() {
                    try {
                        br.close();
                        fr.close();
                        fis.close();
                    }
                    catch (IOException e) {
                        LOGGER.warn("unable to close native resources", (Throwable)e);
                    }
                }
            };
        }
        catch (IOException e) {
            Log.warn((String)("Error parsing tdrive file: " + input.getPath()), (Throwable)e);
            return new CloseableIterator.Empty();
        }
    }

    public boolean isUseReducerPreferred() {
        return false;
    }

    public IngestWithMapper<AvroTdrivePoint, SimpleFeature> ingestWithMapper() {
        return new IngestTdrivePointFromHdfs(this);
    }

    public IngestWithReducer<AvroTdrivePoint, ?, ?, SimpleFeature> ingestWithReducer() {
        throw new UnsupportedOperationException("GPX tracks cannot be ingested with a reducer");
    }

    protected CloseableIterator<GeoWaveData<SimpleFeature>> toGeoWaveDataInternal(AvroTdrivePoint tdrivePoint, String[] indexNames) {
        ArrayList<GeoWaveData> featureData = new ArrayList<GeoWaveData>();
        this.tdrivepointBuilder.set("geometry", (Object)GeometryUtils.GEOMETRY_FACTORY.createPoint(new Coordinate(tdrivePoint.getLongitude().doubleValue(), tdrivePoint.getLatitude().doubleValue())));
        this.tdrivepointBuilder.set("taxiid", (Object)tdrivePoint.getTaxiid());
        this.tdrivepointBuilder.set("pointinstance", (Object)tdrivePoint.getPointinstance());
        this.tdrivepointBuilder.set("Timestamp", (Object)new Date(tdrivePoint.getTimestamp()));
        this.tdrivepointBuilder.set("Latitude", (Object)tdrivePoint.getLatitude());
        this.tdrivepointBuilder.set("Longitude", (Object)tdrivePoint.getLongitude());
        featureData.add(new GeoWaveData("tdrivepoint", indexNames, (Object)this.tdrivepointBuilder.buildFeature(tdrivePoint.getTaxiid() + "_" + tdrivePoint.getPointinstance())));
        return new CloseableIterator.Wrapper(featureData.iterator());
    }

    public Index[] getRequiredIndices() {
        return new Index[0];
    }

    public IngestPluginBase<AvroTdrivePoint, SimpleFeature> getIngestWithAvroPlugin() {
        return new IngestTdrivePointFromHdfs(this);
    }

    public String[] getSupportedIndexTypes() {
        return new String[]{"default_geom_dimension", "default_time_dimension"};
    }

    public static class IngestTdrivePointFromHdfs
    extends AbstractSimpleFeatureIngestPlugin.AbstractIngestSimpleFeatureWithMapper<AvroTdrivePoint> {
        public IngestTdrivePointFromHdfs() {
            this(new TdriveIngestPlugin());
        }

        public IngestTdrivePointFromHdfs(TdriveIngestPlugin parentPlugin) {
            super((AbstractSimpleFeatureIngestPlugin)parentPlugin);
        }
    }
}

