/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.tdrive;

import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Scanner;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.mortbay.log.Log;
import org.opengis.feature.simple.SimpleFeatureType;

public class TdriveUtils {
    public static final String TDRIVE_POINT_FEATURE = "tdrivepoint";
    private static final ThreadLocal<DateFormat> dateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };

    public static Date parseDate(String source) throws ParseException {
        return dateFormat.get().parse(source);
    }

    public static SimpleFeatureType createTdrivePointDataType() {
        SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        simpleFeatureTypeBuilder.setName(TDRIVE_POINT_FEATURE);
        AttributeTypeBuilder attributeTypeBuilder = new AttributeTypeBuilder();
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Geometry.class).nillable(false).buildDescriptor("geometry"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Double.class).nillable(false).buildDescriptor("taxiid"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Double.class).nillable(true).buildDescriptor("pointinstance"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Date.class).nillable(true).buildDescriptor("Timestamp"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Double.class).nillable(true).buildDescriptor("Latitude"));
        simpleFeatureTypeBuilder.add(attributeTypeBuilder.binding(Double.class).nillable(true).buildDescriptor("Longitude"));
        return simpleFeatureTypeBuilder.buildFeatureType();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean validate(URL file) {
        try (Scanner scanner = new Scanner(file.openStream(), StringUtils.getGeoWaveCharset().toString());){
            if (!scanner.hasNextLine()) return false;
            String line = scanner.nextLine();
            boolean bl = line.split(",").length == 4;
            return bl;
        }
        catch (Exception e) {
            Log.warn((String)("Error validating file: " + file.getPath()), (Throwable)e);
            return false;
        }
    }
}

