/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.migration.legacy.adapter.vector;

import java.nio.ByteBuffer;
import org.geotools.data.DataUtilities;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.locationtech.geowave.adapter.vector.FeatureDataAdapter;
import org.locationtech.geowave.adapter.vector.util.FeatureDataUtils;
import org.locationtech.geowave.adapter.vector.util.SimpleFeatureUserDataConfigurationSet;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.geotime.util.SimpleFeatureUserDataConfiguration;
import org.locationtech.geowave.core.geotime.util.TimeDescriptors;
import org.locationtech.geowave.core.index.ByteArrayUtils;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.store.adapter.FieldDescriptor;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.RowBuilder;
import org.locationtech.geowave.core.store.api.VisibilityHandler;
import org.locationtech.geowave.core.store.data.visibility.JsonFieldLevelVisibilityHandler;
import org.locationtech.geowave.core.store.data.visibility.UnconstrainedVisibilityHandler;
import org.locationtech.geowave.migration.legacy.adapter.vector.LegacyVisibilityConfiguration;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyFeatureDataAdapter
implements DataTypeAdapter<SimpleFeature> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegacyFeatureDataAdapter.class);
    private SimpleFeatureType persistedFeatureType;
    private SimpleFeatureType reprojectedFeatureType;
    private FeatureDataAdapter updatedAdapter;

    public LegacyFeatureDataAdapter() {
    }

    public LegacyFeatureDataAdapter(SimpleFeatureType featureType, String indexCRSCode) {
        this.persistedFeatureType = featureType;
        this.initCRS(indexCRSCode);
    }

    private void initCRS(String indexCrsCode) {
        CoordinateReferenceSystem indexCRS;
        CoordinateReferenceSystem persistedCRS;
        if (indexCrsCode == null || indexCrsCode.isEmpty()) {
            indexCrsCode = "EPSG:4326";
        }
        if ((persistedCRS = this.persistedFeatureType.getCoordinateReferenceSystem()) == null) {
            persistedCRS = GeometryUtils.getDefaultCRS();
        }
        this.reprojectedFeatureType = (indexCRS = this.decodeCRS(indexCrsCode)).equals(persistedCRS) ? SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.persistedFeatureType, (CoordinateReferenceSystem)persistedCRS) : SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.persistedFeatureType, (CoordinateReferenceSystem)indexCRS);
    }

    private CoordinateReferenceSystem decodeCRS(String crsCode) {
        CoordinateReferenceSystem crs = null;
        try {
            crs = CRS.decode((String)crsCode, (boolean)true);
        }
        catch (FactoryException e) {
            LOGGER.error("Unable to decode '" + crsCode + "' CRS", (Throwable)e);
            throw new RuntimeException("Unable to initialize '" + crsCode + "' object", e);
        }
        return crs;
    }

    public FeatureDataAdapter getUpdatedAdapter() {
        return this.updatedAdapter;
    }

    public VisibilityHandler getVisibilityHandler() {
        UnconstrainedVisibilityHandler visibilityHandler = new UnconstrainedVisibilityHandler();
        for (AttributeDescriptor attrDesc : this.persistedFeatureType.getAttributeDescriptors()) {
            if (!attrDesc.getUserData().containsKey("visibility") || !Boolean.TRUE.equals(attrDesc.getUserData().get("visibility"))) continue;
            Object visMgr = this.persistedFeatureType.getUserData().get("visibilityManagerClass");
            if (visMgr == null) break;
            if (visMgr.toString().equals("org.locationtech.geowave.adapter.vector.plugin.visibility.JsonDefinitionColumnVisibilityManagement") || visMgr.toString().equals("org.locationtech.geowave.adapter.vector.plugin.visibility.VisibilityConfiguration")) {
                visibilityHandler = new JsonFieldLevelVisibilityHandler(attrDesc.getLocalName());
                continue;
            }
            LOGGER.warn("Custom visibility manager '" + visMgr + "' is not supported by the migration, a default unconstrained visibility handler will be used.");
        }
        return visibilityHandler;
    }

    public SimpleFeatureType getFeatureType() {
        return this.persistedFeatureType;
    }

    public byte[] toBinary() {
        String encodedType = DataUtilities.encodeType((SimpleFeatureType)this.persistedFeatureType);
        String axis = FeatureDataUtils.getAxis((CoordinateReferenceSystem)this.persistedFeatureType.getCoordinateReferenceSystem());
        String typeName = this.reprojectedFeatureType.getTypeName();
        byte[] typeNameBytes = StringUtils.stringToBinary((String)typeName);
        byte[] axisBytes = StringUtils.stringToBinary((String)axis);
        SimpleFeatureUserDataConfigurationSet userDataConfiguration = new SimpleFeatureUserDataConfigurationSet();
        userDataConfiguration.addConfigurations(typeName, (SimpleFeatureUserDataConfiguration)new TimeDescriptors.TimeDescriptorConfiguration(this.persistedFeatureType));
        userDataConfiguration.addConfigurations(typeName, (SimpleFeatureUserDataConfiguration)new LegacyVisibilityConfiguration(this.persistedFeatureType));
        byte[] attrBytes = userDataConfiguration.toBinary();
        String namespace = this.reprojectedFeatureType.getName().getNamespaceURI();
        byte[] namespaceBytes = namespace != null && namespace.length() > 0 ? StringUtils.stringToBinary((String)namespace) : new byte[]{};
        byte[] encodedTypeBytes = StringUtils.stringToBinary((String)encodedType);
        CoordinateReferenceSystem crs = this.reprojectedFeatureType.getCoordinateReferenceSystem();
        byte[] indexCrsBytes = crs != null ? StringUtils.stringToBinary((String)CRS.toSRS((CoordinateReferenceSystem)crs)) : new byte[]{};
        ByteBuffer buf = ByteBuffer.allocate(encodedTypeBytes.length + indexCrsBytes.length + typeNameBytes.length + namespaceBytes.length + attrBytes.length + axisBytes.length + VarintUtils.unsignedIntByteLength((int)typeNameBytes.length) + VarintUtils.unsignedIntByteLength((int)indexCrsBytes.length) + VarintUtils.unsignedIntByteLength((int)namespaceBytes.length) + VarintUtils.unsignedIntByteLength((int)attrBytes.length) + VarintUtils.unsignedIntByteLength((int)axisBytes.length) + VarintUtils.unsignedIntByteLength((int)encodedTypeBytes.length));
        VarintUtils.writeUnsignedInt((int)typeNameBytes.length, (ByteBuffer)buf);
        VarintUtils.writeUnsignedInt((int)indexCrsBytes.length, (ByteBuffer)buf);
        VarintUtils.writeUnsignedInt((int)namespaceBytes.length, (ByteBuffer)buf);
        VarintUtils.writeUnsignedInt((int)attrBytes.length, (ByteBuffer)buf);
        VarintUtils.writeUnsignedInt((int)axisBytes.length, (ByteBuffer)buf);
        VarintUtils.writeUnsignedInt((int)encodedTypeBytes.length, (ByteBuffer)buf);
        buf.put(typeNameBytes);
        buf.put(indexCrsBytes);
        buf.put(namespaceBytes);
        buf.put(attrBytes);
        buf.put(axisBytes);
        buf.put(encodedTypeBytes);
        byte[] defaultTypeDataBinary = buf.array();
        byte[] persistablesBytes = new byte[]{};
        buf = ByteBuffer.allocate(defaultTypeDataBinary.length + persistablesBytes.length + VarintUtils.unsignedIntByteLength((int)defaultTypeDataBinary.length));
        VarintUtils.writeUnsignedInt((int)defaultTypeDataBinary.length, (ByteBuffer)buf);
        buf.put(defaultTypeDataBinary);
        buf.put(persistablesBytes);
        return buf.array();
    }

    public void fromBinary(byte[] bytes) {
        GeometryUtils.initClassLoader();
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        int defaultTypeDataBinaryLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
        if (defaultTypeDataBinaryLength > 0) {
            byte[] defaultTypeDataBinary = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)defaultTypeDataBinaryLength);
            buf = ByteBuffer.wrap(defaultTypeDataBinary);
            int typeNameByteLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
            int indexCrsByteLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
            int namespaceByteLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
            int attrByteLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
            int axisByteLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
            int encodedTypeByteLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
            byte[] typeNameBytes = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)typeNameByteLength);
            ByteArrayUtils.safeRead((ByteBuffer)buf, (int)indexCrsByteLength);
            byte[] namespaceBytes = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)namespaceByteLength);
            byte[] attrBytes = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)attrByteLength);
            byte[] axisBytes = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)axisByteLength);
            byte[] encodedTypeBytes = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)encodedTypeByteLength);
            String typeName = StringUtils.stringFromBinary((byte[])typeNameBytes);
            String namespace = StringUtils.stringFromBinary((byte[])namespaceBytes);
            if (namespace.length() == 0) {
                namespace = null;
            }
            byte[] secondaryIndexBytes = new byte[buf.remaining()];
            buf.get(secondaryIndexBytes);
            String encodedType = StringUtils.stringFromBinary((byte[])encodedTypeBytes);
            try {
                SimpleFeatureType myType = FeatureDataUtils.decodeType((String)namespace, (String)typeName, (String)encodedType, (String)StringUtils.stringFromBinary((byte[])axisBytes));
                SimpleFeatureUserDataConfigurationSet userDataConfiguration = new SimpleFeatureUserDataConfigurationSet();
                userDataConfiguration.fromBinary(attrBytes);
                userDataConfiguration.updateType(myType);
                this.persistedFeatureType = myType;
                this.updatedAdapter = new FeatureDataAdapter(myType);
            }
            catch (SchemaException e) {
                LOGGER.error("Unable to deserialized feature type", (Throwable)e);
            }
        }
    }

    public String getTypeName() {
        return this.updatedAdapter.getTypeName();
    }

    public byte[] getDataId(SimpleFeature entry) {
        return this.updatedAdapter.getDataId(entry);
    }

    public Object getFieldValue(SimpleFeature entry, String fieldName) {
        return this.updatedAdapter.getFieldValue(entry, fieldName);
    }

    public Class<SimpleFeature> getDataClass() {
        return this.updatedAdapter.getDataClass();
    }

    public RowBuilder<SimpleFeature> newRowBuilder(FieldDescriptor<?>[] outputFieldDescriptors) {
        return this.updatedAdapter.newRowBuilder(outputFieldDescriptors);
    }

    public FieldDescriptor<?>[] getFieldDescriptors() {
        return this.updatedAdapter.getFieldDescriptors();
    }

    public FieldDescriptor<?> getFieldDescriptor(String fieldName) {
        return this.updatedAdapter.getFieldDescriptor(fieldName);
    }
}

