/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.migration.legacy.adapter.vector;

import java.nio.ByteBuffer;
import org.locationtech.geowave.core.geotime.util.SimpleFeatureUserDataConfiguration;
import org.locationtech.geowave.core.index.ByteArrayUtils;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class LegacyVisibilityConfiguration
implements SimpleFeatureUserDataConfiguration {
    private static final long serialVersionUID = -664252700036603897L;
    private String attributeName = "GEOWAVE_VISIBILITY";
    private String managerClassName = "";

    public LegacyVisibilityConfiguration() {
    }

    public LegacyVisibilityConfiguration(SimpleFeatureType persistType) {
        this.configureFromType(persistType);
    }

    public void updateType(SimpleFeatureType persistType) {
        for (AttributeDescriptor attrDesc : persistType.getAttributeDescriptors()) {
            attrDesc.getUserData().remove("visibility");
        }
        AttributeDescriptor attrDesc = persistType.getDescriptor(this.attributeName);
        if (attrDesc != null) {
            attrDesc.getUserData().put("visibility", Boolean.TRUE);
        }
        persistType.getUserData().put("visibilityManagerClass", this.managerClassName);
    }

    public void configureFromType(SimpleFeatureType persistType) {
        for (AttributeDescriptor attrDesc : persistType.getAttributeDescriptors()) {
            if (!attrDesc.getUserData().containsKey("visibility") || !Boolean.TRUE.equals(attrDesc.getUserData().get("visibility"))) continue;
            Object visMgr = persistType.getUserData().get("visibilityManagerClass");
            if (visMgr == null) break;
            this.attributeName = attrDesc.getLocalName();
            this.managerClassName = visMgr.toString();
        }
    }

    public byte[] toBinary() {
        byte[] managerClassBytes = this.managerClassName != null ? StringUtils.stringToBinary((String)this.managerClassName) : new byte[]{};
        byte[] attributeBytes = this.attributeName != null ? StringUtils.stringToBinary((String)this.attributeName) : new byte[]{};
        ByteBuffer buf = ByteBuffer.allocate(attributeBytes.length + managerClassBytes.length + VarintUtils.unsignedIntByteLength((int)attributeBytes.length) + VarintUtils.unsignedIntByteLength((int)managerClassBytes.length));
        VarintUtils.writeUnsignedInt((int)attributeBytes.length, (ByteBuffer)buf);
        buf.put(attributeBytes);
        VarintUtils.writeUnsignedInt((int)managerClassBytes.length, (ByteBuffer)buf);
        buf.put(managerClassBytes);
        return buf.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        int attributeBytesLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
        if (attributeBytesLength > 0) {
            byte[] attributeBytes = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)attributeBytesLength);
            this.attributeName = StringUtils.stringFromBinary((byte[])attributeBytes);
        } else {
            this.attributeName = null;
        }
        int managerClassBytesLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
        if (managerClassBytesLength > 0) {
            byte[] managerClassBytes = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)managerClassBytesLength);
            this.managerClassName = StringUtils.stringFromBinary((byte[])managerClassBytes);
        } else {
            this.managerClassName = null;
        }
    }
}

