/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.migration.legacy.core.store;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.core.index.ByteArrayUtils;
import org.locationtech.geowave.core.store.AdapterToIndexMapping;
import org.locationtech.geowave.core.store.DataStoreOptions;
import org.locationtech.geowave.core.store.metadata.AbstractGeoWavePersistence;
import org.locationtech.geowave.core.store.operations.DataStoreOperations;
import org.locationtech.geowave.core.store.operations.MetadataType;
import org.locationtech.geowave.migration.legacy.core.store.LegacyAdapterToIndexMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyAdapterIndexMappingStore
extends AbstractGeoWavePersistence<LegacyAdapterToIndexMapping> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegacyAdapterIndexMappingStore.class);

    public LegacyAdapterIndexMappingStore(DataStoreOperations operations, DataStoreOptions options) {
        super(operations, options, MetadataType.LEGACY_INDEX_MAPPINGS);
    }

    public boolean mappingExists(AdapterToIndexMapping persistedObject) {
        return this.objectExists(new ByteArray(ByteArrayUtils.shortToByteArray((short)persistedObject.getAdapterId())), null, new String[0]);
    }

    protected ByteArray getPrimaryId(LegacyAdapterToIndexMapping persistedObject) {
        return new ByteArray(ByteArrayUtils.shortToByteArray((short)persistedObject.getAdapterId()));
    }

    public LegacyAdapterToIndexMapping getIndicesForAdapter(short adapterId) {
        LegacyAdapterToIndexMapping mapping = (LegacyAdapterToIndexMapping)super.internalGetObject(new ByteArray(ByteArrayUtils.shortToByteArray((short)adapterId)), null, false, new String[0]);
        return mapping != null ? mapping : new LegacyAdapterToIndexMapping(adapterId, new String[0]);
    }

    public void addAdapterIndexMapping(LegacyAdapterToIndexMapping mapping) {
        ByteArray adapterId = new ByteArray(ByteArrayUtils.shortToByteArray((short)mapping.getAdapterId()));
        if (this.objectExists(adapterId, null, new String[0])) {
            LegacyAdapterToIndexMapping oldMapping = (LegacyAdapterToIndexMapping)super.getObject(adapterId, null, new String[0]);
            if (!oldMapping.equals(mapping)) {
                String[] uniqueCombinedIndices = (String[])Streams.concat((Stream[])new Stream[]{Arrays.stream(mapping.getIndexNames()), Arrays.stream(oldMapping.getIndexNames())}).distinct().toArray(String[]::new);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Updating indices for datatype to " + ArrayUtils.toString((Object)uniqueCombinedIndices));
                }
                this.remove(adapterId);
                this.addObject(new LegacyAdapterToIndexMapping(mapping.getAdapterId(), uniqueCombinedIndices));
            }
        } else {
            this.addObject(mapping);
        }
    }

    public void remove(short internalAdapterId) {
        super.remove(new ByteArray(ByteArrayUtils.shortToByteArray((short)internalAdapterId)));
    }

    public boolean remove(short internalAdapterId, String indexName) {
        ByteArray adapterId = new ByteArray(ByteArrayUtils.shortToByteArray((short)internalAdapterId));
        if (!this.objectExists(adapterId, null, new String[0])) {
            return false;
        }
        LegacyAdapterToIndexMapping oldMapping = (LegacyAdapterToIndexMapping)super.getObject(adapterId, null, new String[0]);
        boolean found = false;
        String[] indexNames = oldMapping.getIndexNames();
        for (int i = 0; i < indexNames.length; ++i) {
            if (indexNames[i].compareTo(indexName) != 0) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        if (indexNames.length > 1) {
            String[] newIndices = new String[indexNames.length - 1];
            int count = 0;
            for (int i = 0; i < indexNames.length; ++i) {
                if (indexNames[i].compareTo(indexName) == 0) continue;
                newIndices[count] = indexNames[i];
                ++count;
            }
            this.remove(adapterId);
            this.addObject(new LegacyAdapterToIndexMapping(internalAdapterId, newIndices));
        } else {
            this.remove(adapterId);
        }
        return true;
    }
}

