/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.migration.legacy.core.store;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.index.IndexStore;

public class LegacyAdapterToIndexMapping
implements Persistable {
    private short adapterId;
    private String[] indexNames;

    public LegacyAdapterToIndexMapping() {
    }

    public LegacyAdapterToIndexMapping(short adapterId, Index[] indices) {
        this.adapterId = adapterId;
        this.indexNames = new String[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            this.indexNames[i] = indices[i].getName();
        }
    }

    public LegacyAdapterToIndexMapping(short adapterId, String ... indexNames) {
        this.adapterId = adapterId;
        this.indexNames = indexNames;
    }

    public short getAdapterId() {
        return this.adapterId;
    }

    public String[] getIndexNames() {
        return this.indexNames;
    }

    public Index[] getIndices(IndexStore indexStore) {
        Index[] indices = new Index[this.indexNames.length];
        for (int i = 0; i < this.indexNames.length; ++i) {
            indices[i] = indexStore.getIndex(this.indexNames[i]);
        }
        return indices;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.adapterId == 0 ? 0 : Short.hashCode(this.adapterId));
        result = 31 * result + Arrays.hashCode(this.indexNames);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LegacyAdapterToIndexMapping other = (LegacyAdapterToIndexMapping)obj;
        if (this.adapterId == 0 ? other.adapterId != 0 : this.adapterId != other.adapterId) {
            return false;
        }
        return Arrays.equals(this.indexNames, other.indexNames);
    }

    public boolean contains(String indexName) {
        for (String id : this.indexNames) {
            if (!id.equals(indexName)) continue;
            return true;
        }
        return false;
    }

    public boolean isNotEmpty() {
        return this.indexNames.length > 0;
    }

    public byte[] toBinary() {
        byte[] indexIdBytes = StringUtils.stringsToBinary((String[])this.indexNames);
        ByteBuffer buf = ByteBuffer.allocate(VarintUtils.unsignedShortByteLength((short)this.adapterId) + indexIdBytes.length);
        VarintUtils.writeUnsignedShort((short)this.adapterId, (ByteBuffer)buf);
        buf.put(indexIdBytes);
        return buf.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        this.adapterId = VarintUtils.readUnsignedShort((ByteBuffer)buf);
        byte[] indexNamesBytes = new byte[buf.remaining()];
        buf.get(indexNamesBytes);
        this.indexNames = StringUtils.stringsFromBinary((byte[])indexNamesBytes);
    }
}

