/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.migration.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.internal.Console;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.geowave.adapter.vector.FeatureDataAdapter;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.Command;
import org.locationtech.geowave.core.cli.api.DefaultOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.operations.util.UtilSection;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.DataStoreProperty;
import org.locationtech.geowave.core.store.PropertyStore;
import org.locationtech.geowave.core.store.adapter.AdapterIndexMappingStore;
import org.locationtech.geowave.core.store.adapter.InternalDataAdapter;
import org.locationtech.geowave.core.store.adapter.PersistentAdapterStore;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.api.Statistic;
import org.locationtech.geowave.core.store.api.VisibilityHandler;
import org.locationtech.geowave.core.store.base.BaseDataStoreUtils;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.locationtech.geowave.core.store.cli.store.StoreLoader;
import org.locationtech.geowave.core.store.dimension.NumericDimensionField;
import org.locationtech.geowave.core.store.index.BasicIndexModel;
import org.locationtech.geowave.core.store.index.CommonIndexModel;
import org.locationtech.geowave.core.store.index.IndexStore;
import org.locationtech.geowave.core.store.operations.DataStoreOperations;
import org.locationtech.geowave.core.store.operations.MetadataDeleter;
import org.locationtech.geowave.core.store.operations.MetadataQuery;
import org.locationtech.geowave.core.store.operations.MetadataType;
import org.locationtech.geowave.core.store.statistics.DefaultStatisticsProvider;
import org.locationtech.geowave.migration.legacy.adapter.LegacyInternalDataAdapterWrapper;
import org.locationtech.geowave.migration.legacy.adapter.vector.LegacyFeatureDataAdapter;
import org.locationtech.geowave.migration.legacy.core.geotime.LegacySpatialField;
import org.locationtech.geowave.migration.legacy.core.store.LegacyAdapterIndexMappingStore;
import org.locationtech.geowave.migration.legacy.core.store.LegacyAdapterToIndexMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GeowaveOperation(name={"migrate"}, parentOperation=UtilSection.class)
@Parameters(commandDescription="Migrates data in a GeoWave data store to be compatible with the CLI version")
public class MigrationCommand
extends DefaultOperation
implements Command {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationCommand.class);
    @Parameter(description="<store name>", required=true)
    private final List<String> parameters = new ArrayList<String>();

    public void execute(OperationParams params) {
        int dataVersion;
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires arguments: <store name>");
        }
        String storeName = this.parameters.get(0);
        StoreLoader inputStoreLoader = new StoreLoader(storeName);
        if (!inputStoreLoader.loadFromConfig(this.getGeoWaveConfigFile(), params.getConsole())) {
            throw new ParameterException("Cannot find store name: " + inputStoreLoader.getStoreName());
        }
        DataStorePluginOptions storeOptions = inputStoreLoader.getDataStorePlugin();
        DataStoreOperations operations = storeOptions.createDataStoreOperations();
        PropertyStore propertyStore = storeOptions.createPropertyStore();
        try {
            if (!operations.metadataExists(MetadataType.ADAPTER) && !operations.metadataExists(MetadataType.INDEX)) {
                throw new ParameterException("There is no data in the data store to migrate.");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to determine if metadata tables exist for data store.", e);
        }
        DataStoreProperty dataVersionProperty = propertyStore.getProperty("DATA_VERSION");
        int n = dataVersion = dataVersionProperty == null ? 0 : (Integer)dataVersionProperty.getValue();
        if (dataVersion == BaseDataStoreUtils.DATA_VERSION) {
            throw new ParameterException("The data version matches the CLI version, there are no migrations to apply.");
        }
        if (dataVersion > BaseDataStoreUtils.DATA_VERSION) {
            throw new ParameterException("The data store is using a newer serialization format.  Please update to a newer version of the CLI that is compatible with the data store.");
        }
        if (dataVersion < 1) {
            this.migrate0to1(storeOptions, operations, params.getConsole());
        }
        propertyStore.setProperty(new DataStoreProperty("DATA_VERSION", (Object)BaseDataStoreUtils.DATA_VERSION));
        params.getConsole().println("Migration completed successfully!");
    }

    public void migrate0to1(DataStorePluginOptions options, DataStoreOperations operations, Console console) {
        InternalDataAdapter[] adapters;
        console.println("Migration 1.x -> 2.x");
        DataStore dataStore = options.createDataStore();
        console.println("  Migrating data type adapters...");
        PersistentAdapterStore adapterStore = options.createAdapterStore();
        ArrayList adapterIDs = Lists.newArrayList();
        int migratedAdapters = 0;
        for (InternalDataAdapter internalDataAdapter : adapters = (InternalDataAdapter[])adapterStore.getAdapters()) {
            adapterIDs.add(internalDataAdapter.getAdapterId());
            if (internalDataAdapter instanceof LegacyInternalDataAdapterWrapper) {
                adapterStore.removeAdapter((Object)internalDataAdapter.getAdapterId());
                adapterStore.addAdapter(((LegacyInternalDataAdapterWrapper)internalDataAdapter).getUpdatedAdapter());
                ++migratedAdapters;
                continue;
            }
            if (!(internalDataAdapter.getAdapter() instanceof LegacyFeatureDataAdapter)) continue;
            FeatureDataAdapter updatedAdapter = ((LegacyFeatureDataAdapter)internalDataAdapter.getAdapter()).getUpdatedAdapter();
            VisibilityHandler visibilityHandler = ((LegacyFeatureDataAdapter)internalDataAdapter.getAdapter()).getVisibilityHandler();
            adapterStore.removeAdapter((Object)internalDataAdapter.getAdapterId());
            adapterStore.addAdapter((DataTypeAdapter)updatedAdapter.asInternalAdapter(internalDataAdapter.getAdapterId(), visibilityHandler));
            ++migratedAdapters;
        }
        if (migratedAdapters > 0) {
            console.println("    Migrated " + migratedAdapters + " data type adapters.");
        } else {
            console.println("    No data type adapters needed to be migrated.");
        }
        console.println("  Migrating indices...");
        IndexStore indexStore = options.createIndexStore();
        int migratedIndices = 0;
        Throwable throwable = null;
        try (CloseableIterator indices = indexStore.getIndices();){
            while (indices.hasNext()) {
                Index index = (Index)indices.next();
                CommonIndexModel indexModel = index.getIndexModel();
                if (indexModel == null || !(indexModel instanceof BasicIndexModel)) continue;
                NumericDimensionField[] oldFields = indexModel.getDimensions();
                NumericDimensionField[] updatedFields = new NumericDimensionField[oldFields.length];
                boolean updated = false;
                for (int i = 0; i < oldFields.length; ++i) {
                    if (oldFields[i] instanceof LegacySpatialField) {
                        updatedFields[i] = ((LegacySpatialField)oldFields[i]).getUpdatedField(index);
                        updated = true;
                        continue;
                    }
                    updatedFields[i] = oldFields[i];
                }
                if (!updated) continue;
                ((BasicIndexModel)indexModel).init(updatedFields);
                indexStore.removeIndex(index.getName());
                indexStore.addIndex(index);
                ++migratedIndices;
            }
        }
        catch (Throwable index) {
            Throwable throwable2 = index;
            throw index;
        }
        if (migratedIndices > 0) {
            console.println("    Migrated " + migratedIndices + " indices.");
        } else {
            console.println("    No indices needed to be migrated.");
        }
        console.println("  Migrating index mappings...");
        LegacyAdapterIndexMappingStore legacyIndexMappings = new LegacyAdapterIndexMappingStore(operations, options.getFactoryOptions().getStoreOptions());
        AdapterIndexMappingStore adapterIndexMappingStore = options.createAdapterIndexMappingStore();
        console.println("    Writing new mappings...");
        int indexMappingCount = 0;
        for (Object adapterId : adapterIDs) {
            LegacyAdapterToIndexMapping mapping = legacyIndexMappings.getIndicesForAdapter((Short)adapterId);
            InternalDataAdapter adapter3 = (InternalDataAdapter)adapterStore.getAdapter(adapterId);
            for (String indexName : mapping.getIndexNames()) {
                adapterIndexMappingStore.addAdapterIndexMapping(BaseDataStoreUtils.mapAdapterToIndex((InternalDataAdapter)adapter3, (Index)indexStore.getIndex(indexName)));
                ++indexMappingCount;
            }
        }
        if (indexMappingCount > 0) {
            console.println("    Migrated " + indexMappingCount + " index mappings.");
            console.println("    Deleting legacy index mappings...");
            try {
                Object adapterId;
                MetadataDeleter deleter = operations.createMetadataDeleter(MetadataType.LEGACY_INDEX_MAPPINGS);
                adapterId = null;
                try {
                    deleter.delete(new MetadataQuery(null, new String[0]));
                }
                catch (Throwable throwable3) {
                    adapterId = throwable3;
                    throw throwable3;
                }
                finally {
                    if (deleter != null) {
                        if (adapterId != null) {
                            try {
                                deleter.close();
                            }
                            catch (Throwable throwable4) {
                                ((Throwable)adapterId).addSuppressed(throwable4);
                            }
                        } else {
                            deleter.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error deleting legacy index mappings", (Throwable)e);
            }
        } else {
            console.println("    No index mappings to migrate.");
        }
        console.println("  Migrating statistics...");
        ArrayList defaultStatistics = new ArrayList();
        for (Index index : dataStore.getIndices()) {
            if (!(index instanceof DefaultStatisticsProvider)) continue;
            defaultStatistics.addAll(((DefaultStatisticsProvider)index).getDefaultStatistics());
        }
        for (DataTypeAdapter adapter4 : dataStore.getTypes()) {
            DefaultStatisticsProvider defaultStatProvider = BaseDataStoreUtils.getDefaultStatisticsProvider((DataTypeAdapter)adapter4);
            if (defaultStatProvider == null) continue;
            defaultStatistics.addAll(defaultStatProvider.getDefaultStatistics());
        }
        console.println("    Calculating updated statistics...");
        dataStore.addStatistic(defaultStatistics.toArray(new Statistic[defaultStatistics.size()]));
        console.println("    Deleting legacy statistics...");
        try (MetadataDeleter deleter = operations.createMetadataDeleter(MetadataType.LEGACY_STATISTICS);){
            deleter.delete(new MetadataQuery(null, new String[0]));
        }
        catch (Exception e) {
            LOGGER.warn("Error deleting legacy statistics", (Throwable)e);
        }
    }
}

