/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.migration.legacy.adapter;

import java.nio.ByteBuffer;
import org.locationtech.geowave.core.index.persist.PersistenceUtils;
import org.locationtech.geowave.core.store.AdapterToIndexMapping;
import org.locationtech.geowave.core.store.adapter.AdapterPersistenceEncoding;
import org.locationtech.geowave.core.store.adapter.FieldDescriptor;
import org.locationtech.geowave.core.store.adapter.IndexedAdapterPersistenceEncoding;
import org.locationtech.geowave.core.store.adapter.InternalDataAdapter;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.api.RowBuilder;
import org.locationtech.geowave.core.store.api.VisibilityHandler;
import org.locationtech.geowave.core.store.data.visibility.UnconstrainedVisibilityHandler;
import org.locationtech.geowave.core.store.index.CommonIndexModel;
import org.locationtech.geowave.migration.legacy.adapter.vector.LegacyFeatureDataAdapter;

public class LegacyInternalDataAdapterWrapper<T>
implements InternalDataAdapter<T> {
    private InternalDataAdapter<T> updatedAdapter;
    private DataTypeAdapter<T> adapter;
    private short adapterId;

    public LegacyInternalDataAdapterWrapper() {
    }

    public LegacyInternalDataAdapterWrapper(DataTypeAdapter<T> adapter, short adapterId) {
        this.adapter = adapter;
        this.adapterId = adapterId;
    }

    public InternalDataAdapter<T> getUpdatedAdapter() {
        return this.updatedAdapter;
    }

    public byte[] toBinary() {
        byte[] adapterBytes = PersistenceUtils.toBinary(this.adapter);
        ByteBuffer buffer = ByteBuffer.allocate(adapterBytes.length + 2);
        buffer.putShort(this.adapterId);
        buffer.put(adapterBytes);
        return buffer.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        this.adapterId = buffer.getShort();
        byte[] adapterBytes = new byte[buffer.remaining()];
        buffer.get(adapterBytes);
        this.adapter = (DataTypeAdapter)PersistenceUtils.fromBinary((byte[])adapterBytes);
        UnconstrainedVisibilityHandler visibilityHandler = new UnconstrainedVisibilityHandler();
        if (this.adapter instanceof LegacyFeatureDataAdapter) {
            visibilityHandler = ((LegacyFeatureDataAdapter)this.adapter).getVisibilityHandler();
            this.adapter = ((LegacyFeatureDataAdapter)this.adapter).getUpdatedAdapter();
        }
        this.updatedAdapter = this.adapter.asInternalAdapter(this.adapterId, (VisibilityHandler)visibilityHandler);
    }

    public VisibilityHandler getVisibilityHandler() {
        return this.updatedAdapter.getVisibilityHandler();
    }

    public short getAdapterId() {
        return this.updatedAdapter.getAdapterId();
    }

    public String getTypeName() {
        return this.updatedAdapter.getTypeName();
    }

    public byte[] getDataId(T entry) {
        return this.updatedAdapter.getDataId(entry);
    }

    public Object getFieldValue(T entry, String fieldName) {
        return this.updatedAdapter.getFieldValue(entry, fieldName);
    }

    public Class<T> getDataClass() {
        return this.updatedAdapter.getDataClass();
    }

    public RowBuilder<T> newRowBuilder(FieldDescriptor<?>[] outputFieldDescriptors) {
        return this.updatedAdapter.newRowBuilder(outputFieldDescriptors);
    }

    public FieldDescriptor<?>[] getFieldDescriptors() {
        return this.updatedAdapter.getFieldDescriptors();
    }

    public FieldDescriptor<?> getFieldDescriptor(String fieldName) {
        return this.updatedAdapter.getFieldDescriptor(fieldName);
    }

    public DataTypeAdapter<T> getAdapter() {
        return this.updatedAdapter.getAdapter();
    }

    public int getPositionOfOrderedField(CommonIndexModel model, String fieldName) {
        return this.updatedAdapter.getPositionOfOrderedField(model, fieldName);
    }

    public String getFieldNameForPosition(CommonIndexModel model, int position) {
        return this.updatedAdapter.getFieldNameForPosition(model, position);
    }

    public AdapterPersistenceEncoding encode(T entry, AdapterToIndexMapping indexMapping, Index index) {
        return this.updatedAdapter.encode(entry, indexMapping, index);
    }

    public T decode(IndexedAdapterPersistenceEncoding data, AdapterToIndexMapping indexMapping, Index index) {
        return (T)this.updatedAdapter.decode(data, indexMapping, index);
    }

    public boolean isCommonIndexField(AdapterToIndexMapping indexMapping, String fieldName) {
        return this.updatedAdapter.isCommonIndexField(indexMapping, fieldName);
    }
}

