/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.migration.legacy.core.geotime;

import java.nio.ByteBuffer;
import java.util.Set;
import javax.annotation.Nullable;
import org.locationtech.geowave.core.geotime.store.dimension.SpatialField;
import org.locationtech.geowave.core.index.ByteArrayUtils;
import org.locationtech.geowave.core.index.IndexDimensionHint;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.index.dimension.NumericDimensionDefinition;
import org.locationtech.geowave.core.index.dimension.bin.BinRange;
import org.locationtech.geowave.core.index.numeric.NumericData;
import org.locationtech.geowave.core.index.numeric.NumericRange;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.geowave.core.index.persist.PersistenceUtils;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.data.field.FieldReader;
import org.locationtech.geowave.core.store.data.field.FieldWriter;
import org.locationtech.geowave.core.store.dimension.NumericDimensionField;
import org.locationtech.jts.geom.Geometry;

public abstract class LegacySpatialField<T extends SpatialField>
implements Persistable,
NumericDimensionField<Geometry> {
    protected String fieldName;
    protected NumericDimensionDefinition baseDefinition;
    protected Integer geometryPrecision;
    protected T updatedField = null;

    public LegacySpatialField() {
    }

    public LegacySpatialField(NumericDimensionDefinition baseDefinition, @Nullable Integer geometryPrecision) {
        this.baseDefinition = baseDefinition;
        this.geometryPrecision = geometryPrecision;
        this.fieldName = "default_geom_dimension";
    }

    public abstract T getUpdatedField(Index var1);

    public byte[] toBinary() {
        byte[] dimensionBinary = PersistenceUtils.toBinary((Persistable)this.baseDefinition);
        byte[] fieldNameBytes = StringUtils.stringToBinary((String)this.fieldName);
        ByteBuffer buf = ByteBuffer.allocate(dimensionBinary.length + fieldNameBytes.length + VarintUtils.unsignedIntByteLength((int)fieldNameBytes.length) + 1);
        VarintUtils.writeUnsignedInt((int)fieldNameBytes.length, (ByteBuffer)buf);
        buf.put(fieldNameBytes);
        buf.put(dimensionBinary);
        if (this.geometryPrecision == null) {
            buf.put((byte)127);
        } else {
            buf.put((byte)this.geometryPrecision.intValue());
        }
        return buf.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        int fieldNameLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
        byte[] fieldNameBytes = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)fieldNameLength);
        this.fieldName = StringUtils.stringFromBinary((byte[])fieldNameBytes);
        byte[] dimensionBinary = new byte[buf.remaining() - 1];
        buf.get(dimensionBinary);
        this.baseDefinition = (NumericDimensionDefinition)PersistenceUtils.fromBinary((byte[])dimensionBinary);
        byte precision = buf.get();
        this.geometryPrecision = precision == 127 ? null : Integer.valueOf(precision);
        this.updatedField = this.getUpdatedField(null);
    }

    public double getRange() {
        return this.updatedField.getRange();
    }

    public double normalize(double value) {
        return this.updatedField.normalize(value);
    }

    public double denormalize(double value) {
        return this.updatedField.denormalize(value);
    }

    public BinRange[] getNormalizedRanges(NumericData range) {
        return this.updatedField.getNormalizedRanges(range);
    }

    public NumericRange getDenormalizedRange(BinRange range) {
        return this.updatedField.getDenormalizedRange(range);
    }

    public int getFixedBinIdSize() {
        return this.updatedField.getFixedBinIdSize();
    }

    public NumericRange getBounds() {
        return this.updatedField.getBounds();
    }

    public NumericData getFullRange() {
        return this.updatedField.getFullRange();
    }

    public NumericData getNumericData(Geometry dataElement) {
        return this.updatedField.getNumericData((Object)dataElement);
    }

    public String getFieldName() {
        return this.updatedField.getFieldName();
    }

    public Set<IndexDimensionHint> getDimensionHints() {
        return this.updatedField.getDimensionHints();
    }

    public FieldWriter<Geometry> getWriter() {
        return this.updatedField.getWriter();
    }

    public FieldReader<Geometry> getReader() {
        return this.updatedField.getReader();
    }

    public NumericDimensionDefinition getBaseDefinition() {
        return this.updatedField.getBaseDefinition();
    }

    public Class<Geometry> getFieldClass() {
        return this.updatedField.getFieldClass();
    }
}

