/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.python;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.locationtech.geowave.python.Debug;
import org.locationtech.geowave.python.cli.PythonRunGatewayOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import py4j.GatewayServer;

public class GeoWavePy4JGateway {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoWavePy4JGateway.class);
    private final Debug debug = new Debug();

    public Debug getDebug() {
        return this.debug;
    }

    public static void runGateway(PythonRunGatewayOptions options) throws InterruptedException, UnknownHostException {
        final GatewayServer server = new GatewayServer((Object)new GeoWavePy4JGateway(), options.getPort(), options.getPythonPort(), InetAddress.getByName(options.getAddress()), InetAddress.getByName(options.getPythonAddress()), 0, 0, null);
        GatewayServer.turnLoggingOn();
        server.start();
        System.out.println("GeoWave Py4J Gateway started...");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("Shutting down GeoWave Py4J Gateway!");
                try {
                    server.shutdown();
                }
                catch (Exception e) {
                    LOGGER.warn("Error shutting down Py4J Gateway", (Throwable)e);
                    System.out.println("Error shutting down Py4J Gateway.");
                }
            }
        });
        while (true) {
            Thread.sleep(TimeUnit.MILLISECONDS.convert(Long.MAX_VALUE, TimeUnit.DAYS));
        }
    }

    public static void main(String[] args) throws InterruptedException, UnknownHostException {
        GeoWavePy4JGateway.runGateway(new PythonRunGatewayOptions());
    }
}

