/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.client;

import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.proxy.WebResourceFactory;
import org.locationtech.geowave.service.ConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigServiceClient
implements ConfigService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigServiceClient.class);
    private final ConfigService configService;
    private final WebTarget addStoreTarget;

    public ConfigServiceClient(String baseUrl) {
        this(baseUrl, null, null);
    }

    public ConfigServiceClient(String baseUrl, String user, String password) {
        WebTarget target = ClientBuilder.newClient().target(baseUrl);
        this.configService = (ConfigService)WebResourceFactory.newResource(ConfigService.class, (WebTarget)target);
        this.addStoreTarget = ConfigServiceClient.createAddStoreTarget(target);
    }

    private static WebTarget createAddStoreTarget(WebTarget baseTarget) {
        WebTarget addStoreTarget = ConfigServiceClient.addPathFromAnnotation(ConfigService.class, baseTarget);
        try {
            addStoreTarget = ConfigServiceClient.addPathFromAnnotation(ConfigService.class.getMethod("addStoreReRoute", String.class, String.class, String.class, Map.class), addStoreTarget);
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOGGER.warn("Unable to derive path from method annotations", (Throwable)e);
            addStoreTarget = addStoreTarget.path("/addstore/{type}");
        }
        return addStoreTarget;
    }

    private static WebTarget addPathFromAnnotation(AnnotatedElement ae, WebTarget target) {
        Path p = ae.getAnnotation(Path.class);
        if (p != null) {
            target = target.path(p.value());
        }
        return target;
    }

    public Response list(String filter) {
        Response resp = this.configService.list(filter);
        resp.bufferEntity();
        return resp;
    }

    public Response list() {
        return this.configService.list(null);
    }

    public Response addHBaseStore(String name, String zookeeper) {
        return this.addHBaseStore(name, zookeeper, null, null, null, null, null, null, null, null, null, null);
    }

    public Response addHBaseStore(String name, String zookeeper, Boolean makeDefault, String geowaveNamespace, Boolean disableServiceSide, String coprocessorjar, Boolean persistAdapter, Boolean persistIndex, Boolean persistDataStatistics, Boolean createTable, Boolean useAltIndex, Boolean enableBlockCache) {
        Response resp = this.configService.addHBaseStore(name, zookeeper, makeDefault, geowaveNamespace, disableServiceSide, coprocessorjar, persistAdapter, persistIndex, persistDataStatistics, createTable, useAltIndex, enableBlockCache);
        return resp;
    }

    public Response addAccumuloStore(String name, String zookeeper, String instance, String user, String password) {
        return this.addAccumuloStore(name, zookeeper, instance, user, password, null, null, null, null, null, null, null, null, null);
    }

    public Response addAccumuloStore(String name, String zookeeper, String instance, String user, String password, Boolean makeDefault, String geowaveNamespace, Boolean useLocalityGroups, Boolean persistAdapter, Boolean persistIndex, Boolean persistDataStatistics, Boolean createTable, Boolean useAltIndex, Boolean enableBlockCache) {
        Response resp = this.configService.addAccumuloStore(name, zookeeper, instance, user, password, makeDefault, geowaveNamespace, useLocalityGroups, persistAdapter, persistIndex, persistDataStatistics, createTable, useAltIndex, enableBlockCache);
        return resp;
    }

    public Response addBigTableStore(String name) {
        return this.addBigTableStore(name, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public Response addBigTableStore(String name, Boolean makeDefault, Integer scanCacheSize, String projectId, String instanceId, String geowaveNamespace, Boolean useLocalityGroups, Boolean persistAdapter, Boolean persistIndex, Boolean persistDataStatistics, Boolean createTable, Boolean useAltIndex, Boolean enableBlockCache) {
        Response resp = this.configService.addBigTableStore(name, makeDefault, scanCacheSize, projectId, instanceId, geowaveNamespace, useLocalityGroups, persistAdapter, persistIndex, persistDataStatistics, createTable, useAltIndex, enableBlockCache);
        return resp;
    }

    public Response addDynamoDBStore(String name) {
        return this.addDynamoDBStore(name, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public Response addDynamoDBStore(String name, Boolean makeDefault, String endpoint, String region, Long writeCapacity, Long readCapacity, Integer maxConnections, String protocol, Boolean enableCacheResponseMetadata, String geowaveNamespace, Boolean persistAdapter, Boolean persistIndex, Boolean persistDataStatistics, Boolean createTable, Boolean useAltIndex, Boolean enableBlockCache, Boolean enableServerSideLibrary) {
        Response resp = this.configService.addDynamoDBStore(name, makeDefault, endpoint, region, writeCapacity, readCapacity, maxConnections, protocol, enableCacheResponseMetadata, geowaveNamespace, persistAdapter, persistIndex, persistDataStatistics, createTable, useAltIndex, enableBlockCache, enableServerSideLibrary);
        return resp;
    }

    public Response addCassandraStore(String name) {
        return this.addCassandraStore(name, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public Response addCassandraStore(String name, Boolean makeDefault, String contactPoint, Integer batchWriteSize, Boolean durableWrites, Integer replicationFactor, String geowaveNamespace, Boolean persistAdapter, Boolean persistIndex, Boolean persistDataStatistics, Boolean createTable, Boolean useAltIndex, Boolean enableBlockCache, Boolean enableServerSideLibrary) {
        Response resp = this.configService.addCassandraStore(name, makeDefault, contactPoint, batchWriteSize, durableWrites, replicationFactor, geowaveNamespace, persistAdapter, persistIndex, persistDataStatistics, createTable, useAltIndex, enableBlockCache, enableServerSideLibrary);
        return resp;
    }

    public Response addSpatialIndex(String name) {
        return this.addSpatialIndex(name, null, null, null, null, null, null);
    }

    public Response addSpatialIndex(String name, Boolean makeDefault, String nameOverride, Integer numPartitions, String partitionStrategy, Boolean storeTime, String crs) {
        Response resp = this.configService.addSpatialIndex(name, makeDefault, nameOverride, numPartitions, partitionStrategy, storeTime, crs);
        return resp;
    }

    public Response addIndexGroup(String name, String[] indexes) {
        Response resp = this.configService.addIndexGroup(name, String.join((CharSequence)",", indexes));
        return resp;
    }

    public Response addSpatialTemporalIndex(String name) {
        return this.addSpatialTemporalIndex(name, null, null, null, null, null, null, null, null);
    }

    public Response addSpatialTemporalIndex(String name, Boolean makeDefault, String nameOverride, Integer numPartitions, String partitionStrategy, String periodicity, String bias, Long maxDuplicates, String crs) {
        Response resp = this.configService.addSpatialTemporalIndex(name, makeDefault, nameOverride, numPartitions, partitionStrategy, periodicity, bias, maxDuplicates, crs);
        return resp;
    }

    public Response addIndex(String name, String type) {
        return this.addIndex(name, type, null, null, null, null, null, null, null, null, null);
    }

    public Response addIndex(String name, String type, Boolean makeDefault, String nameOverride, Integer numPartitions, String partitionStrategy, Boolean storeTime, String periodicity, String bias, Long maxDuplicates, String crs) {
        Response resp = this.configService.addIndex(name, type, makeDefault, nameOverride, numPartitions, partitionStrategy, storeTime, periodicity, bias, maxDuplicates, crs);
        return resp;
    }

    public Response configGeoServer(String GeoServer_URL) {
        return this.configGeoServer(GeoServer_URL, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public Response configGeoServer(String GeoServer_URL, String username, String pass, String workspace, String sslSecurityProtocol, String sslTrustStorePath, String sslTrustStorePassword, String sslTrustStoreType, String sslTruststoreProvider, String sslTrustManagerAlgorithm, String sslTrustManagerProvider, String sslKeyStorePath, String sslKeyStorePassword, String sslKeyStoreProvider, String sslKeyPassword, String sslKeyStoreType, String sslKeyManagerAlgorithm, String sslKeyManagerProvider) {
        Response resp = this.configService.configGeoServer(GeoServer_URL, username, pass, workspace, sslSecurityProtocol, sslTrustStorePath, sslTrustStorePassword, sslTrustStoreType, sslTruststoreProvider, sslTrustManagerAlgorithm, sslTrustManagerProvider, sslKeyStorePath, sslKeyStorePassword, sslKeyStoreProvider, sslKeyPassword, sslKeyStoreType, sslKeyManagerAlgorithm, sslKeyManagerProvider);
        return resp;
    }

    public Response configHDFS(String HDFS_DefaultFS_URL) {
        Response resp = this.configService.configHDFS(HDFS_DefaultFS_URL);
        return resp;
    }

    public Response removeIndex(String name) {
        Response resp = this.configService.removeIndex(name);
        return resp;
    }

    public Response removeIndexGroup(String name) {
        Response resp = this.configService.removeIndexGroup(name);
        return resp;
    }

    public Response removeStore(String name) {
        Response resp = this.configService.removeStore(name);
        return resp;
    }

    public Response set(String name, String value) {
        return this.set(name, value, null);
    }

    public Response set(String name, String value, Boolean password) {
        Response resp = this.configService.set(name, value, password);
        return resp;
    }

    public Response addStoreReRoute(String name, String type, String geowaveNamespace, Map<String, String> additionalQueryParams) {
        WebTarget internalAddStoreTarget = this.addStoreTarget.resolveTemplate("type", (Object)type);
        internalAddStoreTarget = internalAddStoreTarget.queryParam("name", new Object[]{name});
        if (geowaveNamespace != null && !geowaveNamespace.isEmpty()) {
            internalAddStoreTarget = internalAddStoreTarget.queryParam("geowaveNamespace", new Object[]{name});
        }
        for (Map.Entry<String, String> e : additionalQueryParams.entrySet()) {
            if (e.getKey().equals("protocol")) {
                internalAddStoreTarget = internalAddStoreTarget.queryParam(e.getKey(), new Object[]{e.getValue().toUpperCase()});
                continue;
            }
            internalAddStoreTarget = internalAddStoreTarget.queryParam(e.getKey(), new Object[]{e.getValue()});
        }
        return internalAddStoreTarget.request().accept(new String[]{"application/json"}).method("POST");
    }

    public Response addIndexGroup(String name, String indexes) {
        Response resp = this.configService.addIndexGroup(name, indexes);
        return resp;
    }
}

