/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.client;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.proxy.WebResourceFactory;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.locationtech.geowave.service.GeoServerService;

public class GeoServerServiceClient {
    private final GeoServerService geoServerService;

    public GeoServerServiceClient(String baseUrl) {
        this(baseUrl, null, null);
    }

    public GeoServerServiceClient(String baseUrl, String user, String password) {
        this.geoServerService = (GeoServerService)WebResourceFactory.newResource(GeoServerService.class, (WebTarget)((Client)ClientBuilder.newClient().register(MultiPartFeature.class)).target(baseUrl));
    }

    public Response getCoverageStore(String coverage_store_name, String workspace) {
        Response resp = this.geoServerService.getCoverageStore(coverage_store_name, workspace);
        return resp;
    }

    public Response getCoverageStore(String coverage_store_name) {
        return this.getCoverageStore(coverage_store_name, null);
    }

    public Response getCoverage(String cvgstore, String coverage_name, String workspace) {
        Response resp = this.geoServerService.getCoverage(cvgstore, coverage_name, workspace);
        return resp;
    }

    public Response getCoverage(String cvgstore, String coverage_name) {
        return this.getCoverage(cvgstore, coverage_name, null);
    }

    public Response getDataStore(String datastore_name, String workspace) {
        Response resp = this.geoServerService.getDataStore(datastore_name, workspace);
        return resp;
    }

    public Response getDataStore(String datastore_name) {
        return this.getDataStore(datastore_name, null);
    }

    public Response getFeatureLayer(String layer_name) {
        Response resp = this.geoServerService.getFeatureLayer(layer_name);
        return resp;
    }

    public Response getStoreAdapters(String store_name) {
        Response resp = this.geoServerService.getStoreAdapters(store_name);
        return resp;
    }

    public Response getStyle(String style_name) {
        Response resp = this.geoServerService.getStyle(style_name);
        return resp;
    }

    public Response listCoverageStores(String workspace) {
        Response resp = this.geoServerService.listCoverageStores(workspace);
        return resp;
    }

    public Response listCoverageStores() {
        return this.listCoverageStores(null);
    }

    public Response listCoverages(String coverage_store_name, String workspace) {
        Response resp = this.geoServerService.listCoverages(coverage_store_name, workspace);
        return resp;
    }

    public Response listCoverages(String coverage_store_name) {
        return this.listCoverages(coverage_store_name, null);
    }

    public Response listDataStores(String workspace) {
        Response resp = this.geoServerService.listDataStores(workspace);
        return resp;
    }

    public Response listDataStores() {
        return this.listDataStores(null);
    }

    public Response listFeatureLayers(String workspace, String datastore, Boolean geowaveOnly) {
        Response resp = this.geoServerService.listFeatureLayers(workspace, datastore, geowaveOnly);
        return resp;
    }

    public Response listFeatureLayers() {
        return this.listFeatureLayers(null, null, null);
    }

    public Response listStyles() {
        return this.geoServerService.listStyles();
    }

    public Response listWorkspaces() {
        return this.geoServerService.listWorkspaces();
    }

    public Response addCoverageStore(String GeoWave_store_name, String workspace, Boolean equalizerHistogramOverride, String interpolationOverride, Boolean scaleTo8Bit) {
        Response resp = this.geoServerService.addCoverageStore(GeoWave_store_name, workspace, equalizerHistogramOverride, interpolationOverride, scaleTo8Bit);
        return resp;
    }

    public Response addCoverageStore(String GeoWave_store_name) {
        return this.addCoverageStore(GeoWave_store_name, null, null, null, null);
    }

    public Response addCoverage(String cvgstore, String coverage_name, String workspace) {
        Response resp = this.geoServerService.addCoverage(cvgstore, coverage_name, workspace);
        return resp;
    }

    public Response addCoverage(String cvgstore, String coverage_name) {
        return this.addCoverage(cvgstore, coverage_name, null);
    }

    public Response addDataStore(String GeoWave_store_name, String workspace, String datastore) {
        Response resp = this.geoServerService.addDataStore(GeoWave_store_name, workspace, datastore);
        return resp;
    }

    public Response addDataStore(String GeoWave_store_name) {
        return this.addDataStore(GeoWave_store_name, null, null);
    }

    public Response addFeatureLayer(String datastore, String layer_name, String workspace) {
        Response resp = this.geoServerService.addFeatureLayer(datastore, layer_name, workspace);
        return resp;
    }

    public Response addFeatureLayer(String datastore, String layer_name) {
        return this.addFeatureLayer(datastore, layer_name, null);
    }

    public Response addLayer(String GeoWave_store_name, String workspace, String addOption, String adapterId, String style) {
        Response resp = this.geoServerService.addLayer(GeoWave_store_name, workspace, addOption, adapterId, style);
        return resp;
    }

    public Response addLayer(String GeoWave_store_name) {
        return this.addLayer(GeoWave_store_name, null, null, null, null);
    }

    public Response addStyle(String stylesld, String GeoWave_style_name) {
        Response resp = this.geoServerService.addStyle(stylesld, GeoWave_style_name);
        return resp;
    }

    public Response addWorkspace(String workspace_name) {
        Response resp = this.geoServerService.addWorkspace(workspace_name);
        return resp;
    }

    public Response removeCoverageStore(String coverage_store_name, String workspace) {
        Response resp = this.geoServerService.removeCoverageStore(coverage_store_name, workspace);
        return resp;
    }

    public Response removeCoverageStore(String coverage_store_name) {
        return this.removeCoverageStore(coverage_store_name, null);
    }

    public Response removeCoverage(String cvgstore, String coverage_name, String workspace) {
        Response resp = this.geoServerService.removeCoverage(cvgstore, coverage_name, workspace);
        return resp;
    }

    public Response removeCoverage(String cvgstore, String coverage_name) {
        return this.removeCoverage(cvgstore, coverage_name, null);
    }

    public Response removeDataStore(String datastore_name, String workspace) {
        Response resp = this.geoServerService.removeDataStore(datastore_name, workspace);
        return resp;
    }

    public Response removeDataStore(String datastore_name) {
        return this.removeDataStore(datastore_name, null);
    }

    public Response removeFeatureLayer(String layer_name) {
        Response resp = this.geoServerService.removeFeatureLayer(layer_name);
        return resp;
    }

    public Response removeStyle(String style_name) {
        Response resp = this.geoServerService.removeStyle(style_name);
        return resp;
    }

    public Response removeWorkspace(String workspace_name) {
        Response resp = this.geoServerService.removeWorkspace(workspace_name);
        return resp;
    }

    public Response setLayerStyle(String styleName, String layer_name) {
        Response resp = this.geoServerService.setLayerStyle(styleName, layer_name);
        return resp;
    }
}

