/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.client;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.proxy.WebResourceFactory;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.locationtech.geowave.service.RemoteService;

public class RemoteServiceClient {
    private final RemoteService remoteService;

    public RemoteServiceClient(String baseUrl) {
        this(baseUrl, null, null);
    }

    public RemoteServiceClient(String baseUrl, String user, String password) {
        this.remoteService = (RemoteService)WebResourceFactory.newResource(RemoteService.class, (WebTarget)((Client)ClientBuilder.newClient().register(MultiPartFeature.class)).target(baseUrl));
    }

    public Response listTypes(String store_name) {
        Response resp = this.remoteService.listTypes(store_name);
        return resp;
    }

    public Response listIndices(String store_name) {
        Response resp = this.remoteService.listIndices(store_name);
        return resp;
    }

    public Response version(String storename) {
        Response resp = this.remoteService.version(storename);
        return resp;
    }

    public Response listStats(String store_name) {
        return this.listStats(store_name, null, null, null);
    }

    public Response listStats(String store_name, String typeName, String authorizations, Boolean jsonFormatFlag) {
        Response resp = this.remoteService.listStats(store_name, typeName, authorizations, jsonFormatFlag);
        return resp;
    }

    public Response calcStat(String store_name, String typeName, String statId) {
        return this.calcStat(store_name, typeName, statId, null, null);
    }

    public Response calcStat(String store_name, String typeName, String statType, String authorizations, Boolean jsonFormatFlag) {
        Response resp = this.remoteService.calcStat(store_name, typeName, statType, authorizations, jsonFormatFlag);
        return resp;
    }

    public Response clear(String store_name) {
        Response resp = this.remoteService.clear(store_name);
        return resp;
    }

    public Response recalcStats(String store_name) {
        return this.recalcStats(store_name, null, null, null);
    }

    public Response recalcStats(String store_name, String typeName, String authorizations, Boolean jsonFormatFlag) {
        Response resp = this.remoteService.recalcStats(store_name, typeName, authorizations, jsonFormatFlag);
        return resp;
    }

    public Response removeType(String store_name, String typeName) {
        Response resp = this.remoteService.removeType(store_name, typeName);
        return resp;
    }

    public Response removeStat(String store_name, String typeName, String statType, String authorizations, Boolean jsonFormatFlag) {
        Response resp = this.remoteService.removeStat(store_name, typeName, statType, authorizations, jsonFormatFlag);
        return resp;
    }

    public Response removeStat(String store_name, String typeName, String statType) {
        return this.removeStat(store_name, typeName, statType, null, null);
    }
}

