/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.client;

import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.proxy.WebResourceFactory;
import org.locationtech.geowave.service.IndexService;
import org.locationtech.geowave.service.StoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexServiceClient
implements IndexService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexServiceClient.class);
    private final IndexService indexService;
    private final WebTarget addIndexTarget;

    public IndexServiceClient(String baseUrl) {
        this(baseUrl, null, null);
    }

    public IndexServiceClient(String baseUrl, String user, String password) {
        WebTarget target = ClientBuilder.newClient().target(baseUrl);
        this.indexService = (IndexService)WebResourceFactory.newResource(IndexService.class, (WebTarget)target);
        this.addIndexTarget = IndexServiceClient.createAddIndexTarget(target);
    }

    private static WebTarget createAddIndexTarget(WebTarget baseTarget) {
        WebTarget addIndexTarget = IndexServiceClient.addPathFromAnnotation(StoreService.class, baseTarget);
        try {
            addIndexTarget = IndexServiceClient.addPathFromAnnotation(IndexService.class.getMethod("addIndexReRoute", String.class, String.class, Map.class), addIndexTarget);
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOGGER.warn("Unable to derive path from method annotations", (Throwable)e);
            addIndexTarget = addIndexTarget.path("/add/{type}");
        }
        return addIndexTarget;
    }

    private static WebTarget addPathFromAnnotation(AnnotatedElement ae, WebTarget target) {
        Path p = ae.getAnnotation(Path.class);
        if (p != null) {
            target = target.path(p.value());
        }
        return target;
    }

    public Response listIndices(String storeName) {
        Response resp = this.indexService.listIndices(storeName);
        return resp;
    }

    public Response addSpatialIndex(String storeName, String indexName) {
        return this.addSpatialIndex(storeName, indexName, null, null, null, null, null);
    }

    public Response addSpatialIndex(String storeName, String indexName, Boolean makeDefault, Integer numPartitions, String partitionStrategy, Boolean storeTime, String crs) {
        Response resp = this.indexService.addSpatialIndex(storeName, indexName, makeDefault, numPartitions, partitionStrategy, storeTime, crs);
        return resp;
    }

    public Response addSpatialTemporalIndex(String storeName, String indexName) {
        return this.addSpatialTemporalIndex(storeName, indexName, null, null, null, null, null, null, null);
    }

    public Response addSpatialTemporalIndex(String storeName, String indexName, Boolean makeDefault, Integer numPartitions, String partitionStrategy, String periodicity, String bias, Long maxDuplicates, String crs) {
        Response resp = this.indexService.addSpatialTemporalIndex(storeName, indexName, makeDefault, numPartitions, partitionStrategy, periodicity, bias, maxDuplicates, crs);
        return resp;
    }

    public Response removeIndex(String storeName, String indexName) {
        Response resp = this.indexService.removeIndex(storeName, indexName);
        return resp;
    }

    public Response addIndexReRoute(String storeName, String indexName, String type, Map<String, String> additionalQueryParams) {
        WebTarget internalAddStoreTarget = this.addIndexTarget.resolveTemplate("type", (Object)type);
        internalAddStoreTarget = internalAddStoreTarget.queryParam("storeName", new Object[]{storeName});
        internalAddStoreTarget = internalAddStoreTarget.queryParam("indexName", new Object[]{indexName});
        for (Map.Entry<String, String> e : additionalQueryParams.entrySet()) {
            internalAddStoreTarget = internalAddStoreTarget.queryParam(e.getKey(), new Object[]{e.getValue()});
        }
        return internalAddStoreTarget.request().accept(new String[]{"application/json"}).method("POST");
    }
}

