/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.client;

import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.proxy.WebResourceFactory;
import org.locationtech.geowave.service.ConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigServiceClient
implements ConfigService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigServiceClient.class);
    private final ConfigService configService;

    public ConfigServiceClient(String baseUrl) {
        this(baseUrl, null, null);
    }

    public ConfigServiceClient(String baseUrl, String user, String password) {
        WebTarget target = ClientBuilder.newClient().target(baseUrl);
        this.configService = (ConfigService)WebResourceFactory.newResource(ConfigService.class, (WebTarget)target);
    }

    public Response list(String filter) {
        Response resp = this.configService.list(filter);
        resp.bufferEntity();
        return resp;
    }

    public Response list() {
        return this.configService.list(null);
    }

    public Response configGeoServer(String GeoServerURL) {
        return this.configGeoServer(GeoServerURL, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public Response configGeoServer(String GeoServerURL, String username, String pass, String workspace, String sslSecurityProtocol, String sslTrustStorePath, String sslTrustStorePassword, String sslTrustStoreType, String sslTruststoreProvider, String sslTrustManagerAlgorithm, String sslTrustManagerProvider, String sslKeyStorePath, String sslKeyStorePassword, String sslKeyStoreProvider, String sslKeyPassword, String sslKeyStoreType, String sslKeyManagerAlgorithm, String sslKeyManagerProvider) {
        Response resp = this.configService.configGeoServer(GeoServerURL, username, pass, workspace, sslSecurityProtocol, sslTrustStorePath, sslTrustStorePassword, sslTrustStoreType, sslTruststoreProvider, sslTrustManagerAlgorithm, sslTrustManagerProvider, sslKeyStorePath, sslKeyStorePassword, sslKeyStoreProvider, sslKeyPassword, sslKeyStoreType, sslKeyManagerAlgorithm, sslKeyManagerProvider);
        return resp;
    }

    public Response configHDFS(String HDFSDefaultFSURL) {
        Response resp = this.configService.configHDFS(HDFSDefaultFSURL);
        return resp;
    }

    public Response set(String name, String value) {
        return this.set(name, value, null);
    }

    public Response set(String name, String value, Boolean password) {
        Response resp = this.configService.set(name, value, password);
        return resp;
    }
}

