/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.client;

import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.proxy.WebResourceFactory;
import org.locationtech.geowave.service.StoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreServiceClient
implements StoreService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreServiceClient.class);
    private final StoreService storeService;
    private final WebTarget addStoreTarget;

    public StoreServiceClient(String baseUrl) {
        this(baseUrl, null, null);
    }

    public StoreServiceClient(String baseUrl, String user, String password) {
        WebTarget target = ClientBuilder.newClient().target(baseUrl);
        this.storeService = (StoreService)WebResourceFactory.newResource(StoreService.class, (WebTarget)target);
        this.addStoreTarget = StoreServiceClient.createAddStoreTarget(target);
    }

    private static WebTarget createAddStoreTarget(WebTarget baseTarget) {
        WebTarget addStoreTarget = StoreServiceClient.addPathFromAnnotation(StoreService.class, baseTarget);
        try {
            addStoreTarget = StoreServiceClient.addPathFromAnnotation(StoreService.class.getMethod("addStoreReRoute", String.class, String.class, String.class, Map.class), addStoreTarget);
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOGGER.warn("Unable to derive path from method annotations", (Throwable)e);
            addStoreTarget = addStoreTarget.path("/add/{type}");
        }
        return addStoreTarget;
    }

    private static WebTarget addPathFromAnnotation(AnnotatedElement ae, WebTarget target) {
        Path p = ae.getAnnotation(Path.class);
        if (p != null) {
            target = target.path(p.value());
        }
        return target;
    }

    public Response listPlugins() {
        Response resp = this.storeService.listPlugins();
        resp.bufferEntity();
        return resp;
    }

    public Response version(String storeName) {
        Response resp = this.storeService.version(storeName);
        return resp;
    }

    public Response clear(String storeName) {
        Response resp = this.storeService.clear(storeName);
        return resp;
    }

    public Response addHBaseStore(String name, String zookeeper) {
        return this.addHBaseStore(name, zookeeper, null, null, null, null, null, null, null, null, null, null);
    }

    public Response addHBaseStore(String name, String zookeeper, Boolean makeDefault, String geowaveNamespace, Boolean disableServiceSide, String coprocessorjar, Boolean persistAdapter, Boolean persistIndex, Boolean persistDataStatistics, Boolean createTable, Boolean useAltIndex, Boolean enableBlockCache) {
        Response resp = this.storeService.addHBaseStore(name, zookeeper, makeDefault, geowaveNamespace, disableServiceSide, coprocessorjar, persistAdapter, persistIndex, persistDataStatistics, createTable, useAltIndex, enableBlockCache);
        return resp;
    }

    public Response addAccumuloStore(String name, String zookeeper, String instance, String user, String password) {
        return this.addAccumuloStore(name, zookeeper, instance, user, password, null, null, null, null, null, null, null, null, null);
    }

    public Response addAccumuloStore(String name, String zookeeper, String instance, String user, String password, Boolean makeDefault, String geowaveNamespace, Boolean useLocalityGroups, Boolean persistAdapter, Boolean persistIndex, Boolean persistDataStatistics, Boolean createTable, Boolean useAltIndex, Boolean enableBlockCache) {
        Response resp = this.storeService.addAccumuloStore(name, zookeeper, instance, user, password, makeDefault, geowaveNamespace, useLocalityGroups, persistAdapter, persistIndex, persistDataStatistics, createTable, useAltIndex, enableBlockCache);
        return resp;
    }

    public Response addBigTableStore(String name) {
        return this.addBigTableStore(name, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public Response addBigTableStore(String name, Boolean makeDefault, Integer scanCacheSize, String projectId, String instanceId, String geowaveNamespace, Boolean useLocalityGroups, Boolean persistAdapter, Boolean persistIndex, Boolean persistDataStatistics, Boolean createTable, Boolean useAltIndex, Boolean enableBlockCache) {
        Response resp = this.storeService.addBigTableStore(name, makeDefault, scanCacheSize, projectId, instanceId, geowaveNamespace, useLocalityGroups, persistAdapter, persistIndex, persistDataStatistics, createTable, useAltIndex, enableBlockCache);
        return resp;
    }

    public Response addDynamoDBStore(String name) {
        return this.addDynamoDBStore(name, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public Response addDynamoDBStore(String name, Boolean makeDefault, String endpoint, String region, Long writeCapacity, Long readCapacity, Integer maxConnections, String protocol, Boolean enableCacheResponseMetadata, String geowaveNamespace, Boolean persistAdapter, Boolean persistIndex, Boolean persistDataStatistics, Boolean createTable, Boolean useAltIndex, Boolean enableBlockCache, Boolean enableServerSideLibrary) {
        Response resp = this.storeService.addDynamoDBStore(name, makeDefault, endpoint, region, writeCapacity, readCapacity, maxConnections, protocol, enableCacheResponseMetadata, geowaveNamespace, persistAdapter, persistIndex, persistDataStatistics, createTable, useAltIndex, enableBlockCache, enableServerSideLibrary);
        return resp;
    }

    public Response addCassandraStore(String name) {
        return this.addCassandraStore(name, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public Response addCassandraStore(String name, Boolean makeDefault, String contactPoint, Integer batchWriteSize, Boolean durableWrites, Integer replicationFactor, String geowaveNamespace, Boolean persistAdapter, Boolean persistIndex, Boolean persistDataStatistics, Boolean createTable, Boolean useAltIndex, Boolean enableBlockCache, Boolean enableServerSideLibrary) {
        Response resp = this.storeService.addCassandraStore(name, makeDefault, contactPoint, batchWriteSize, durableWrites, replicationFactor, geowaveNamespace, persistAdapter, persistIndex, persistDataStatistics, createTable, useAltIndex, enableBlockCache, enableServerSideLibrary);
        return resp;
    }

    public Response removeStore(String name) {
        Response resp = this.storeService.removeStore(name);
        return resp;
    }

    public Response addStoreReRoute(String name, String type, String geowaveNamespace, Map<String, String> additionalQueryParams) {
        WebTarget internalAddStoreTarget = this.addStoreTarget.resolveTemplate("type", (Object)type);
        internalAddStoreTarget = internalAddStoreTarget.queryParam("name", new Object[]{name});
        if (geowaveNamespace != null && !geowaveNamespace.isEmpty()) {
            internalAddStoreTarget = internalAddStoreTarget.queryParam("geowaveNamespace", new Object[]{name});
        }
        for (Map.Entry<String, String> e : additionalQueryParams.entrySet()) {
            if (e.getKey().equals("protocol")) {
                internalAddStoreTarget = internalAddStoreTarget.queryParam(e.getKey(), new Object[]{e.getValue().toUpperCase()});
                continue;
            }
            internalAddStoreTarget = internalAddStoreTarget.queryParam(e.getKey(), new Object[]{e.getValue()});
        }
        return internalAddStoreTarget.request().accept(new String[]{"application/json"}).method("POST");
    }
}

