/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.client;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.proxy.WebResourceFactory;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.locationtech.geowave.service.GeoServerService;

public class GeoServerServiceClient {
    private final GeoServerService geoServerService;

    public GeoServerServiceClient(String baseUrl) {
        this(baseUrl, null, null);
    }

    public GeoServerServiceClient(String baseUrl, String user, String password) {
        this.geoServerService = (GeoServerService)WebResourceFactory.newResource(GeoServerService.class, (WebTarget)((Client)ClientBuilder.newClient().register(MultiPartFeature.class)).target(baseUrl));
    }

    public Response getCoverageStore(String coverageStoreName, String workspace) {
        Response resp = this.geoServerService.getCoverageStore(coverageStoreName, workspace);
        return resp;
    }

    public Response getCoverageStore(String coverageStoreName) {
        return this.getCoverageStore(coverageStoreName, null);
    }

    public Response getCoverage(String cvgstore, String coverageName, String workspace) {
        Response resp = this.geoServerService.getCoverage(cvgstore, coverageName, workspace);
        return resp;
    }

    public Response getCoverage(String cvgstore, String coverageName) {
        return this.getCoverage(cvgstore, coverageName, null);
    }

    public Response getDataStore(String datastoreName, String workspace) {
        Response resp = this.geoServerService.getDataStore(datastoreName, workspace);
        return resp;
    }

    public Response getDataStore(String datastoreName) {
        return this.getDataStore(datastoreName, null);
    }

    public Response getFeatureLayer(String layerName) {
        Response resp = this.geoServerService.getFeatureLayer(layerName);
        return resp;
    }

    public Response getStoreAdapters(String storeName) {
        Response resp = this.geoServerService.getStoreAdapters(storeName);
        return resp;
    }

    public Response getStyle(String styleName) {
        Response resp = this.geoServerService.getStyle(styleName);
        return resp;
    }

    public Response listCoverageStores(String workspace) {
        Response resp = this.geoServerService.listCoverageStores(workspace);
        return resp;
    }

    public Response listCoverageStores() {
        return this.listCoverageStores(null);
    }

    public Response listCoverages(String coverageStoreName, String workspace) {
        Response resp = this.geoServerService.listCoverages(coverageStoreName, workspace);
        return resp;
    }

    public Response listCoverages(String coverageStoreName) {
        return this.listCoverages(coverageStoreName, null);
    }

    public Response listDataStores(String workspace) {
        Response resp = this.geoServerService.listDataStores(workspace);
        return resp;
    }

    public Response listDataStores() {
        return this.listDataStores(null);
    }

    public Response listFeatureLayers(String workspace, String datastore, Boolean geowaveOnly) {
        Response resp = this.geoServerService.listFeatureLayers(workspace, datastore, geowaveOnly);
        return resp;
    }

    public Response listFeatureLayers() {
        return this.listFeatureLayers(null, null, null);
    }

    public Response listStyles() {
        return this.geoServerService.listStyles();
    }

    public Response listWorkspaces() {
        return this.geoServerService.listWorkspaces();
    }

    public Response addCoverageStore(String geoWaveStoreName, String workspace, Boolean equalizerHistogramOverride, String interpolationOverride, Boolean scaleTo8Bit) {
        Response resp = this.geoServerService.addCoverageStore(geoWaveStoreName, workspace, equalizerHistogramOverride, interpolationOverride, scaleTo8Bit);
        return resp;
    }

    public Response addCoverageStore(String GeoWaveStoreName) {
        return this.addCoverageStore(GeoWaveStoreName, null, null, null, null);
    }

    public Response addCoverage(String cvgstore, String coverageName, String workspace) {
        Response resp = this.geoServerService.addCoverage(cvgstore, coverageName, workspace);
        return resp;
    }

    public Response addCoverage(String cvgstore, String coverageName) {
        return this.addCoverage(cvgstore, coverageName, null);
    }

    public Response addDataStore(String geoWaveStoreName, String workspace, String datastore) {
        Response resp = this.geoServerService.addDataStore(geoWaveStoreName, workspace, datastore);
        return resp;
    }

    public Response addDataStore(String geoWaveStoreName) {
        return this.addDataStore(geoWaveStoreName, null, null);
    }

    public Response addFeatureLayer(String datastore, String layerName, String workspace) {
        Response resp = this.geoServerService.addFeatureLayer(datastore, layerName, workspace);
        return resp;
    }

    public Response addFeatureLayer(String datastore, String layerName) {
        return this.addFeatureLayer(datastore, layerName, null);
    }

    public Response addLayer(String geoWaveStoreName, String workspace, String addOption, String adapterId, String style) {
        Response resp = this.geoServerService.addLayer(geoWaveStoreName, workspace, addOption, adapterId, style);
        return resp;
    }

    public Response addLayer(String geoWaveStoreName) {
        return this.addLayer(geoWaveStoreName, null, null, null, null);
    }

    public Response addStyle(String stylesld, String geoWaveStyleName) {
        Response resp = this.geoServerService.addStyle(stylesld, geoWaveStyleName);
        return resp;
    }

    public Response addWorkspace(String workspaceName) {
        Response resp = this.geoServerService.addWorkspace(workspaceName);
        return resp;
    }

    public Response removeCoverageStore(String coverageStoreName, String workspace) {
        Response resp = this.geoServerService.removeCoverageStore(coverageStoreName, workspace);
        return resp;
    }

    public Response removeCoverageStore(String coverageStoreName) {
        return this.removeCoverageStore(coverageStoreName, null);
    }

    public Response removeCoverage(String cvgstore, String coverageName, String workspace) {
        Response resp = this.geoServerService.removeCoverage(cvgstore, coverageName, workspace);
        return resp;
    }

    public Response removeCoverage(String cvgstore, String coverageName) {
        return this.removeCoverage(cvgstore, coverageName, null);
    }

    public Response removeDataStore(String datastoreName, String workspace) {
        Response resp = this.geoServerService.removeDataStore(datastoreName, workspace);
        return resp;
    }

    public Response removeDataStore(String datastoreName) {
        return this.removeDataStore(datastoreName, null);
    }

    public Response removeFeatureLayer(String layerName) {
        Response resp = this.geoServerService.removeFeatureLayer(layerName);
        return resp;
    }

    public Response removeStyle(String styleName) {
        Response resp = this.geoServerService.removeStyle(styleName);
        return resp;
    }

    public Response removeWorkspace(String workspaceName) {
        Response resp = this.geoServerService.removeWorkspace(workspaceName);
        return resp;
    }

    public Response setLayerStyle(String styleName, String layerName) {
        Response resp = this.geoServerService.setLayerStyle(styleName, layerName);
        return resp;
    }
}

