/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.client;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.proxy.WebResourceFactory;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.locationtech.geowave.service.IngestService;

public class IngestServiceClient {
    private final IngestService ingestService;

    public IngestServiceClient(String baseUrl) {
        this(baseUrl, null, null);
    }

    public IngestServiceClient(String baseUrl, String user, String password) {
        this.ingestService = (IngestService)WebResourceFactory.newResource(IngestService.class, (WebTarget)((Client)ClientBuilder.newClient().register(MultiPartFeature.class)).target(baseUrl));
    }

    public Response listPlugins() {
        Response resp = this.ingestService.listPlugins();
        resp.bufferEntity();
        return resp;
    }

    public Response kafkaToGW(String storeName, String indexList) {
        return this.kafkaToGW(storeName, indexList, null, null, null, null, null, null, null, null, null, null, null);
    }

    public Response kafkaToGW(String storeName, String indexList, String kafkaPropertyFile, String visibility, String groupId, String bootstrapServers, String autoOffsetReset, String maxPartitionFetchBytes, String consumerTimeoutMs, Boolean reconnectOnTimeout, Integer batchSize, String extensions, String formats) {
        Response resp = this.ingestService.kafkaToGW(storeName, indexList, kafkaPropertyFile, visibility, groupId, bootstrapServers, autoOffsetReset, maxPartitionFetchBytes, consumerTimeoutMs, reconnectOnTimeout, batchSize, extensions, formats);
        return resp;
    }

    public Response localToGW(String fileOrDirectory, String storeName, String indexList) {
        return this.localToGW(fileOrDirectory, storeName, indexList, null, null, null, null);
    }

    public Response localToGW(String fileOrDirectory, String storeName, String indexList, Integer threads, String visibility, String extensions, String formats) {
        Response resp = this.ingestService.localToGW(fileOrDirectory, storeName, indexList, threads, visibility, extensions, formats);
        return resp;
    }

    public Response localToHdfs(String fileOrDirectory, String pathToBaseDirectoryToWriteTo) {
        return this.localToHdfs(fileOrDirectory, pathToBaseDirectoryToWriteTo, null, null);
    }

    public Response localToHdfs(String fileOrDirectory, String pathToBaseDirectoryToWriteTo, String extensions, String formats) {
        Response resp = this.ingestService.localToHdfs(fileOrDirectory, pathToBaseDirectoryToWriteTo, extensions, formats);
        return resp;
    }

    public Response localToKafka(String fileOrDirectory, String kafkaPropertyFile, String bootstrapServers, String retryBackoffMs, String extensions, String formats) {
        Response resp = this.ingestService.localToKafka(fileOrDirectory, kafkaPropertyFile, bootstrapServers, retryBackoffMs, extensions, formats);
        return resp;
    }

    public Response localToKafka(String fileOrDirectory, String bootstrapServers) {
        return this.localToKafka(fileOrDirectory, null, bootstrapServers, null, null, null);
    }

    public Response localToMrGW(String fileOrDirectory, String pathToBaseDirectoryToWriteTo, String storeName, String indexList, String visibility, String jobTrackerHostPort, String resourceManger, String extensions, String formats) {
        Response resp = this.ingestService.localToMrGW(fileOrDirectory, pathToBaseDirectoryToWriteTo, storeName, indexList, visibility, jobTrackerHostPort, resourceManger, extensions, formats);
        return resp;
    }

    public Response localToMrGW(String fileOrDirectory, String pathToBaseDirectoryToWriteTo, String storeName, String indexList) {
        return this.localToMrGW(fileOrDirectory, pathToBaseDirectoryToWriteTo, storeName, indexList, null, null, null, null, null);
    }

    public Response mrToGW(String pathToBaseDirectoryToWriteTo, String storeName, String indexList, String visibility, String jobTrackerHostPort, String resourceManger, String extensions, String formats) {
        Response resp = this.ingestService.mrToGW(pathToBaseDirectoryToWriteTo, storeName, indexList, visibility, jobTrackerHostPort, resourceManger, extensions, formats);
        return resp;
    }

    public Response mrToGW(String pathToBaseDirectoryToWriteTo, String storeName, String indexList) {
        return this.mrToGW(pathToBaseDirectoryToWriteTo, storeName, indexList, null, null, null, null, null);
    }

    public Response sparkToGW(String inputDirectory, String storeName, String indexList, String visibility, String appName, String host, String master, Integer numExecutors, Integer numCores, String extensions, String formats) {
        Response resp = this.ingestService.sparkToGW(inputDirectory, storeName, indexList, visibility, appName, host, master, numExecutors, numCores, extensions, formats);
        return resp;
    }

    public Response sparkToGW(String inputDirectory, String storeName, String indexList) {
        return this.sparkToGW(inputDirectory, storeName, indexList, null, null, null, null, null, null, null, null);
    }
}

