/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.gc.SimpleGarbageCollector;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.init.Initialize;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.junit.Assert;
import org.locationtech.geowave.core.store.GenericStoreFactory;
import org.locationtech.geowave.core.store.StoreFactoryOptions;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.datastore.accumulo.AccumuloStoreFactoryFamily;
import org.locationtech.geowave.datastore.accumulo.cli.MiniAccumuloClusterFactory;
import org.locationtech.geowave.datastore.accumulo.cli.config.AccumuloRequiredOptions;
import org.locationtech.geowave.test.StoreTestEnvironment;
import org.locationtech.geowave.test.TestEnvironment;
import org.locationtech.geowave.test.TestUtils;
import org.locationtech.geowave.test.ZookeeperTestEnvironment;
import org.locationtech.geowave.test.annotation.GeoWaveTestStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloStoreTestEnvironment
extends StoreTestEnvironment {
    private static final GenericStoreFactory<DataStore> STORE_FACTORY = new AccumuloStoreFactoryFamily().getDataStoreFactory();
    private static AccumuloStoreTestEnvironment singletonInstance = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(AccumuloStoreTestEnvironment.class);
    private static final boolean KEEP_LOGS = false;
    private static final int NUM_TABLET_SERVERS = 2;
    protected static final String DEFAULT_MINI_ACCUMULO_PASSWORD = "Ge0wave";
    protected static final String HADOOP_WINDOWS_UTIL = "winutils.exe";
    protected static final String HADOOP_DLL = "hadoop.dll";
    protected static final File TEMP_DIR = new File("./target/accumulo_temp");
    protected String zookeeper;
    protected String accumuloInstance;
    protected String accumuloUser;
    protected String accumuloPassword;
    protected MiniAccumuloClusterImpl miniAccumulo;
    private final List<Process> cleanup = new ArrayList<Process>();

    public static synchronized AccumuloStoreTestEnvironment getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new AccumuloStoreTestEnvironment();
        }
        return singletonInstance;
    }

    private AccumuloStoreTestEnvironment() {
    }

    @Override
    public void setup() {
        if (!TestUtils.isSet(this.zookeeper)) {
            this.zookeeper = System.getProperty("zookeeperUrl");
            if (!TestUtils.isSet(this.zookeeper)) {
                this.zookeeper = ZookeeperTestEnvironment.getInstance().getZookeeper();
                LOGGER.debug("Using local zookeeper URL: " + this.zookeeper);
            }
        }
        if (!(TestUtils.isSet(this.accumuloInstance) && TestUtils.isSet(this.accumuloUser) && TestUtils.isSet(this.accumuloPassword))) {
            this.accumuloInstance = System.getProperty("instance");
            this.accumuloUser = System.getProperty("username");
            this.accumuloPassword = System.getProperty("password");
            if (!(TestUtils.isSet(this.accumuloInstance) && TestUtils.isSet(this.accumuloUser) && TestUtils.isSet(this.accumuloPassword))) {
                try {
                    if (!TEMP_DIR.exists() && !TEMP_DIR.mkdirs()) {
                        throw new IOException("Could not create temporary directory");
                    }
                    TEMP_DIR.deleteOnExit();
                    MiniAccumuloConfigImpl config = new MiniAccumuloConfigImpl(TEMP_DIR, DEFAULT_MINI_ACCUMULO_PASSWORD);
                    config.setZooKeeperPort(Integer.parseInt(this.zookeeper.split(":")[1]));
                    config.setNumTservers(2);
                    this.miniAccumulo = MiniAccumuloClusterFactory.newAccumuloCluster((MiniAccumuloConfigImpl)config, AccumuloStoreTestEnvironment.class, (URL[])new URL[0]);
                    this.startMiniAccumulo(config);
                    this.accumuloUser = "root";
                    this.accumuloInstance = this.miniAccumulo.getInstanceName();
                    this.accumuloPassword = DEFAULT_MINI_ACCUMULO_PASSWORD;
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.warn("Unable to start mini accumulo instance", (Throwable)e);
                    LOGGER.info("Check '" + TEMP_DIR.getAbsolutePath() + File.separator + "logs' for more info");
                    if (SystemUtils.IS_OS_WINDOWS) {
                        LOGGER.warn("For windows, make sure that Cygwin is installed and set a CYGPATH environment variable to %CYGWIN_HOME%/bin/cygpath to successfully run a mini accumulo cluster");
                    }
                    Assert.fail((String)("Unable to start mini accumulo instance: '" + e.getLocalizedMessage() + "'"));
                }
            }
        }
    }

    private void startMiniAccumulo(MiniAccumuloConfigImpl config) throws IOException, InterruptedException {
        LinkedList<String> jvmArgs = new LinkedList<String>();
        jvmArgs.add("-XX:CompressedClassSpaceSize=512m");
        jvmArgs.add("-XX:MaxMetaspaceSize=512m");
        jvmArgs.add("-Xmx512m");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AccumuloStoreTestEnvironment.this.tearDown();
            }
        });
        Map siteConfig = config.getSiteConfig();
        siteConfig.put(Property.INSTANCE_ZK_HOST.getKey(), this.zookeeper);
        config.setSiteConfig(siteConfig);
        LinkedList<String> args = new LinkedList<String>();
        args.add("--instance-name");
        args.add(config.getInstanceName());
        args.add("--password");
        args.add(config.getRootPassword());
        Process initProcess = this.miniAccumulo.exec(Initialize.class, jvmArgs, args.toArray(new String[0]));
        this.cleanup.add(initProcess);
        int ret = initProcess.waitFor();
        if (ret != 0) {
            throw new RuntimeException("Initialize process returned " + ret + ". Check the logs in " + config.getLogDir() + " for errors.");
        }
        LOGGER.info("Starting MAC against instance " + config.getInstanceName() + " and zookeeper(s)  " + config.getZooKeepers());
        for (int i = 0; i < config.getNumTservers(); ++i) {
            this.cleanup.add(this.miniAccumulo.exec(TabletServer.class, jvmArgs, new String[0]));
        }
        this.cleanup.add(this.miniAccumulo.exec(Master.class, jvmArgs, new String[0]));
        this.cleanup.add(this.miniAccumulo.exec(SimpleGarbageCollector.class, jvmArgs, new String[0]));
    }

    @Override
    public void tearDown() {
        this.zookeeper = null;
        this.accumuloInstance = null;
        this.accumuloUser = null;
        this.accumuloPassword = null;
        if (this.miniAccumulo != null) {
            try {
                for (Process p : this.cleanup) {
                    p.destroy();
                    p.waitFor();
                }
                for (Process p : this.cleanup) {
                    p.destroy();
                    p.waitFor();
                }
                this.miniAccumulo = null;
            }
            catch (InterruptedException e) {
                LOGGER.warn("Unable to stop mini accumulo instance", (Throwable)e);
            }
        }
        if (TEMP_DIR != null) {
            try {
                Thread.sleep(2000L);
                FileUtils.deleteDirectory((File)TEMP_DIR);
            }
            catch (IOException | InterruptedException e) {
                LOGGER.warn("Unable to delete mini Accumulo temporary directory", (Throwable)e);
            }
        }
    }

    @Override
    protected void initOptions(StoreFactoryOptions options) {
        AccumuloRequiredOptions accumuloOpts = (AccumuloRequiredOptions)options;
        accumuloOpts.setUser(this.accumuloUser);
        accumuloOpts.setPassword(this.accumuloPassword);
        accumuloOpts.setInstance(this.accumuloInstance);
        accumuloOpts.setZookeeper(this.zookeeper);
    }

    @Override
    protected GenericStoreFactory<DataStore> getDataStoreFactory() {
        return STORE_FACTORY;
    }

    @Override
    protected GeoWaveTestStore.GeoWaveStoreType getStoreType() {
        return GeoWaveTestStore.GeoWaveStoreType.ACCUMULO;
    }

    public String getZookeeper() {
        return this.zookeeper;
    }

    public String getAccumuloInstance() {
        return this.accumuloInstance;
    }

    public String getAccumuloUser() {
        return this.accumuloUser;
    }

    public String getAccumuloPassword() {
        return this.accumuloPassword;
    }

    @Override
    public TestEnvironment[] getDependentEnvironments() {
        return new TestEnvironment[]{ZookeeperTestEnvironment.getInstance()};
    }
}

