/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.exec.CommandLine;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.cassandra.AbstractCassandraMojo;
import org.codehaus.mojo.cassandra.StartCassandraClusterMojo;
import org.codehaus.mojo.cassandra.StartCassandraMojo;
import org.codehaus.mojo.cassandra.StopCassandraClusterMojo;
import org.codehaus.mojo.cassandra.StopCassandraMojo;
import org.codehaus.plexus.util.FileUtils;
import org.locationtech.geowave.core.store.GenericStoreFactory;
import org.locationtech.geowave.core.store.StoreFactoryOptions;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.core.store.util.ClasspathUtils;
import org.locationtech.geowave.datastore.cassandra.CassandraStoreFactoryFamily;
import org.locationtech.geowave.datastore.cassandra.config.CassandraOptions;
import org.locationtech.geowave.datastore.cassandra.config.CassandraRequiredOptions;
import org.locationtech.geowave.test.StoreTestEnvironment;
import org.locationtech.geowave.test.TestEnvironment;
import org.locationtech.geowave.test.annotation.GeoWaveTestStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraStoreTestEnvironment
extends StoreTestEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraStoreTestEnvironment.class);
    private static final GenericStoreFactory<DataStore> STORE_FACTORY = new CassandraStoreFactoryFamily().getDataStoreFactory();
    private static CassandraStoreTestEnvironment singletonInstance = null;
    protected static final File TEMP_DIR = new File(System.getProperty("user.dir") + File.separator + "target", "cassandra_temp");
    protected static final String NODE_DIRECTORY_PREFIX = "cassandra";
    private static final boolean CLUSTERED_MODE = false;
    private boolean running = false;

    public static synchronized CassandraStoreTestEnvironment getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new CassandraStoreTestEnvironment();
        }
        return singletonInstance;
    }

    private CassandraStoreTestEnvironment() {
    }

    @Override
    protected void initOptions(StoreFactoryOptions options) {
        CassandraRequiredOptions cassandraOpts = (CassandraRequiredOptions)options;
        cassandraOpts.setContactPoint("127.0.0.1");
        ((CassandraOptions)cassandraOpts.getStoreOptions()).setBatchWriteSize(5);
    }

    @Override
    protected GenericStoreFactory<DataStore> getDataStoreFactory() {
        return STORE_FACTORY;
    }

    @Override
    public void setup() {
        if (!this.running) {
            if (TEMP_DIR.exists()) {
                CassandraStoreTestEnvironment.cleanTempDir();
            }
            if (!TEMP_DIR.mkdirs()) {
                LOGGER.warn("Unable to create temporary cassandra directory");
            }
            new StartGeoWaveStandalone().start();
            this.running = true;
        }
    }

    @Override
    public void tearDown() {
        if (this.running) {
            new StopGeoWaveStandalone().stop();
            this.running = false;
        }
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Unable to sleep waiting to delete directory", (Throwable)e);
        }
        CassandraStoreTestEnvironment.cleanTempDir();
    }

    private static void cleanTempDir() {
        try {
            FileUtils.deleteDirectory((File)TEMP_DIR);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to delete temp cassandra directory", (Throwable)e);
        }
    }

    @Override
    protected GeoWaveTestStore.GeoWaveStoreType getStoreType() {
        return GeoWaveTestStore.GeoWaveStoreType.CASSANDRA;
    }

    @Override
    public TestEnvironment[] getDependentEnvironments() {
        return new TestEnvironment[0];
    }

    private static class StopGeoWaveStandalone
    extends StopCassandraMojo {
        public StopGeoWaveStandalone() {
            this.rpcPort = 9160;
            this.stopPort = 8081;
            this.stopKey = "cassandra-maven-plugin";
            try {
                Field f = StopCassandraMojo.class.getDeclaredField("rpcAddress");
                f.setAccessible(true);
                f.set((Object)this, "127.0.0.1");
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                LOGGER.error("Unable to initialize stop cassandra cluster", (Throwable)e);
            }
        }

        public void stop() {
            try {
                super.execute();
            }
            catch (MojoExecutionException | MojoFailureException e) {
                LOGGER.error("Unable to stop cassandra cluster", e);
            }
        }
    }

    private static class StartGeoWaveStandalone
    extends StartCassandraMojo {
        private StartGeoWaveStandalone() {
            this.startWaitSeconds = 180;
            this.rpcAddress = "127.0.0.1";
            this.rpcPort = 9160;
            this.jmxPort = 7199;
            this.startNativeTransport = true;
            this.nativeTransportPort = 9042;
            this.listenAddress = "127.0.0.1";
            this.storagePort = 7000;
            this.stopPort = 8081;
            this.stopKey = "cassandra-maven-plugin";
            this.maxMemory = 512;
            this.cassandraDir = TEMP_DIR;
            this.logLevel = "ERROR";
            this.project = new MavenProject();
            this.project.setFile(this.cassandraDir);
            try {
                Field f = AbstractCassandraMojo.class.getDeclaredField("pluginArtifact");
                f.setAccessible(true);
                DefaultArtifact a = new DefaultArtifact("group", "artifact", VersionRange.createFromVersionSpec((String)"version"), null, "type", null, (ArtifactHandler)new DefaultArtifactHandler());
                a.setFile(this.cassandraDir);
                f.set((Object)this, a);
                f = AbstractCassandraMojo.class.getDeclaredField("pluginDependencies");
                f.setAccessible(true);
                f.set((Object)this, new ArrayList());
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException | InvalidVersionSpecificationException e) {
                LOGGER.error("Unable to initialize start cassandra cluster", e);
            }
        }

        protected void createCassandraJar(File jarFile, String mainClass, File cassandraDir) throws IOException {
            ClasspathUtils.setupPathingJarClassPath((File)jarFile, (String)mainClass, ((Object)((Object)this)).getClass(), (URL[])new URL[]{new File(cassandraDir, "conf").toURI().toURL()});
        }

        public void start() {
            try {
                super.execute();
            }
            catch (MojoExecutionException | MojoFailureException e) {
                LOGGER.error("Unable to start cassandra cluster", e);
            }
        }
    }

    private static class StopGeoWaveCluster
    extends StopCassandraClusterMojo {
        private StopGeoWaveCluster() {
            this.rpcPort = 9160;
            this.stopPort = 8081;
            this.stopKey = "cassandra-maven-plugin";
            try {
                Field f = StopCassandraClusterMojo.class.getDeclaredField("clusterSize");
                f.setAccessible(true);
                f.set((Object)this, 4);
                f = StopCassandraClusterMojo.class.getDeclaredField("rpcAddress");
                f.setAccessible(true);
                f.set((Object)this, "127.0.0.1");
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                LOGGER.error("Unable to initialize stop cassandra cluster", (Throwable)e);
            }
        }

        public void stop() {
            try {
                super.execute();
            }
            catch (MojoExecutionException | MojoFailureException e) {
                LOGGER.error("Unable to stop cassandra cluster", e);
            }
        }
    }

    private static class StartGeoWaveCluster
    extends StartCassandraClusterMojo {
        private StartGeoWaveCluster() {
            this.startWaitSeconds = 180;
            this.rpcAddress = "127.0.0.1";
            this.rpcPort = 9160;
            this.jmxPort = 7199;
            this.startNativeTransport = true;
            this.nativeTransportPort = 9042;
            this.listenAddress = "127.0.0.1";
            this.storagePort = 7000;
            this.stopPort = 8081;
            this.stopKey = "cassandra-maven-plugin";
            this.maxMemory = 512;
            this.cassandraDir = new File(TEMP_DIR, CassandraStoreTestEnvironment.NODE_DIRECTORY_PREFIX);
            this.logLevel = "ERROR";
            this.project = new MavenProject();
            this.project.setFile(this.cassandraDir);
            try {
                Field f = StartCassandraClusterMojo.class.getDeclaredField("clusterSize");
                f.setAccessible(true);
                f.set((Object)this, 4);
                f = AbstractCassandraMojo.class.getDeclaredField("pluginArtifact");
                f.setAccessible(true);
                DefaultArtifact a = new DefaultArtifact("group", "artifact", VersionRange.createFromVersionSpec((String)"version"), null, "type", null, (ArtifactHandler)new DefaultArtifactHandler());
                a.setFile(this.cassandraDir);
                f.set((Object)this, a);
                f = AbstractCassandraMojo.class.getDeclaredField("pluginDependencies");
                f.setAccessible(true);
                f.set((Object)this, new ArrayList());
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException | InvalidVersionSpecificationException e) {
                LOGGER.error("Unable to initialize start cassandra cluster", e);
            }
        }

        protected CommandLine newServiceCommandLine(File cassandraDir, String listenAddress, String rpcAddress, BigInteger initialToken, String[] seeds, boolean jmxRemoteEnabled, int jmxPort) throws IOException {
            return super.newServiceCommandLine(cassandraDir, listenAddress, rpcAddress, BigInteger.valueOf(initialToken.longValue()), seeds, false, jmxPort);
        }

        protected void createCassandraJar(File jarFile, String mainClass, File cassandraDir) throws IOException {
            ClasspathUtils.setupPathingJarClassPath((File)jarFile, (String)mainClass, ((Object)((Object)this)).getClass(), (URL[])new URL[]{new File(cassandraDir, "conf").toURI().toURL()});
        }

        public void start() {
            try {
                super.execute();
            }
            catch (MojoExecutionException | MojoFailureException e) {
                LOGGER.error("Unable to start cassandra cluster", e);
            }
        }
    }
}

