/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.locationtech.geowave.core.store.GenericStoreFactory;
import org.locationtech.geowave.core.store.StoreFactoryOptions;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.datastore.rocksdb.RocksDBStoreFactoryFamily;
import org.locationtech.geowave.datastore.rocksdb.config.RocksDBOptions;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBClientCache;
import org.locationtech.geowave.test.StoreTestEnvironment;
import org.locationtech.geowave.test.TestEnvironment;
import org.locationtech.geowave.test.annotation.GeoWaveTestStore;

public class RocksDBStoreTestEnvironment
extends StoreTestEnvironment {
    private static final GenericStoreFactory<DataStore> STORE_FACTORY = new RocksDBStoreFactoryFamily().getDataStoreFactory();
    private static RocksDBStoreTestEnvironment singletonInstance = null;
    private static final String DEFAULT_DB_DIRECTORY = "./target/rocksdb";

    public static synchronized RocksDBStoreTestEnvironment getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new RocksDBStoreTestEnvironment();
        }
        return singletonInstance;
    }

    @Override
    public void setup() throws Exception {
    }

    @Override
    public void tearDown() throws Exception {
        RocksDBClientCache.getInstance().closeAll();
        FileUtils.deleteDirectory((File)new File(DEFAULT_DB_DIRECTORY));
    }

    @Override
    public TestEnvironment[] getDependentEnvironments() {
        return new TestEnvironment[0];
    }

    @Override
    protected GenericStoreFactory<DataStore> getDataStoreFactory() {
        return STORE_FACTORY;
    }

    @Override
    protected GeoWaveTestStore.GeoWaveStoreType getStoreType() {
        return GeoWaveTestStore.GeoWaveStoreType.ROCKSDB;
    }

    @Override
    protected void initOptions(StoreFactoryOptions options) {
        ((RocksDBOptions)options).setDirectory(DEFAULT_DB_DIRECTORY);
    }
}

