/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test;

import com.beust.jcommander.ParameterException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.util.VersionUtil;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.parser.ManualOperationParams;
import org.locationtech.geowave.core.geotime.ingest.SpatialDimensionalityTypeProvider;
import org.locationtech.geowave.core.geotime.ingest.SpatialOptions;
import org.locationtech.geowave.core.geotime.ingest.SpatialTemporalDimensionalityTypeProvider;
import org.locationtech.geowave.core.geotime.ingest.SpatialTemporalOptions;
import org.locationtech.geowave.core.geotime.ingest.TemporalDimensionalityTypeProvider;
import org.locationtech.geowave.core.geotime.ingest.TemporalOptions;
import org.locationtech.geowave.core.geotime.store.query.ExplicitSpatialQuery;
import org.locationtech.geowave.core.geotime.store.query.ExplicitSpatialTemporalQuery;
import org.locationtech.geowave.core.geotime.store.query.OptimalCQLQuery;
import org.locationtech.geowave.core.geotime.store.query.SpatialQuery;
import org.locationtech.geowave.core.geotime.store.query.SpatialTemporalQuery;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.geotime.util.TWKBReader;
import org.locationtech.geowave.core.geotime.util.TWKBWriter;
import org.locationtech.geowave.core.geotime.util.TimeUtils;
import org.locationtech.geowave.core.ingest.operations.ConfigAWSCommand;
import org.locationtech.geowave.core.ingest.operations.LocalToGeowaveCommand;
import org.locationtech.geowave.core.ingest.operations.options.IngestFormatPluginOptions;
import org.locationtech.geowave.core.ingest.spark.SparkCommandLineOptions;
import org.locationtech.geowave.core.ingest.spark.SparkIngestDriver;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.api.Query;
import org.locationtech.geowave.core.store.api.QueryBuilder;
import org.locationtech.geowave.core.store.cli.config.AddIndexCommand;
import org.locationtech.geowave.core.store.cli.config.AddStoreCommand;
import org.locationtech.geowave.core.store.cli.remote.ListStatsCommand;
import org.locationtech.geowave.core.store.cli.remote.options.DataStorePluginOptions;
import org.locationtech.geowave.core.store.cli.remote.options.IndexPluginOptions;
import org.locationtech.geowave.core.store.cli.remote.options.VisibilityOptions;
import org.locationtech.geowave.core.store.ingest.LocalInputCommandLineOptions;
import org.locationtech.geowave.core.store.query.constraints.QueryConstraints;
import org.locationtech.geowave.test.StoreTestEnvironment;
import org.locationtech.geowave.test.annotation.GeoWaveTestStore;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.Name;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestUtils.class);
    public static final File TEMP_DIR = new File("./target/temp");
    public static final String TEST_FILTER_START_TIME_ATTRIBUTE_NAME = "StartTime";
    public static final String TEST_FILTER_END_TIME_ATTRIBUTE_NAME = "EndTime";
    public static final String TEST_NAMESPACE = "mil_nga_giat_geowave_test";
    public static final String TEST_NAMESPACE_BAD = "mil_nga_giat_geowave_test_BAD";
    public static final String TEST_RESOURCE_PACKAGE = "org/locationtech/geowave/test/";
    public static final String TEST_CASE_BASE = "data/";
    public static final Index DEFAULT_SPATIAL_INDEX = new SpatialDimensionalityTypeProvider.SpatialIndexBuilder().createIndex();
    public static final Index DEFAULT_TEMPORAL_INDEX = new TemporalDimensionalityTypeProvider.TemporalIndexBuilder().createIndex();
    public static final Index DEFAULT_SPATIAL_TEMPORAL_INDEX = new SpatialTemporalDimensionalityTypeProvider.SpatialTemporalIndexBuilder().createIndex();
    public static String CUSTOM_CRSCODE = "EPSG:3857";
    public static final CoordinateReferenceSystem CUSTOM_CRS;
    public static final double DOUBLE_EPSILON = 1.0E-8;
    public static final String S3_INPUT_PATH = "s3://geowave-test/data/gdelt";
    public static final String S3URL = "s3.amazonaws.com";
    private static int i;
    private static Random rng;

    public static Index createWebMercatorSpatialIndex() {
        SpatialDimensionalityTypeProvider sdp = new SpatialDimensionalityTypeProvider();
        SpatialOptions so = sdp.createOptions();
        so.setCrs(CUSTOM_CRSCODE);
        Index primaryIndex = sdp.createIndex(so);
        return primaryIndex;
    }

    public static Index createWebMercatorSpatialTemporalIndex() {
        SpatialTemporalDimensionalityTypeProvider p = new SpatialTemporalDimensionalityTypeProvider();
        SpatialTemporalOptions o = p.createOptions();
        o.setCrs(CUSTOM_CRSCODE);
        Index primaryIndex = p.createIndex(o);
        return primaryIndex;
    }

    public static boolean isYarn() {
        return VersionUtil.compareVersions((String)VersionInfo.getVersion(), (String)"2.2.0") >= 0;
    }

    public static boolean isOracleJDK() {
        return System.getProperty("java.vm.name") != null && System.getProperty("java.vm.name").contains("HotSpot");
    }

    public static void testLocalIngest(DataStorePluginOptions dataStore, DimensionalityType dimensionalityType, String ingestFilePath, int nthreads) throws Exception {
        TestUtils.testLocalIngest(dataStore, dimensionalityType, ingestFilePath, "geotools-vector", nthreads);
    }

    public static void testLocalIngest(DataStorePluginOptions dataStore, DimensionalityType dimensionalityType, String ingestFilePath) throws Exception {
        TestUtils.testLocalIngest(dataStore, dimensionalityType, ingestFilePath, "geotools-vector", 1);
    }

    public static boolean isSet(String str) {
        return str != null && !str.isEmpty();
    }

    public static void deleteAll(DataStorePluginOptions dataStore) {
        dataStore.createDataStore().delete((Query)QueryBuilder.newBuilder().build());
    }

    public static void testLocalIngest(DataStorePluginOptions dataStore, DimensionalityType dimensionalityType, String ingestFilePath, String format, int nthreads) throws Exception {
        TestUtils.testLocalIngest(dataStore, dimensionalityType, null, ingestFilePath, format, nthreads, true);
    }

    public static void testLocalIngest(DataStorePluginOptions dataStore, DimensionalityType dimensionalityType, String crsCode, String ingestFilePath, String format, int nthreads) throws Exception {
        TestUtils.testLocalIngest(dataStore, dimensionalityType, crsCode, ingestFilePath, format, nthreads, true);
    }

    public static void testLocalIngest(DataStorePluginOptions dataStore, DimensionalityType dimensionalityType, String crsCode, String ingestFilePath, String format, int nthreads, boolean supportTimeRange) throws Exception {
        IngestFormatPluginOptions ingestFormatOptions = new IngestFormatPluginOptions();
        ingestFormatOptions.selectPlugin(format);
        String[] indexTypes = dimensionalityType.getDimensionalityArg().split(",");
        ArrayList<IndexPluginOptions> indexOptions = new ArrayList<IndexPluginOptions>(indexTypes.length);
        for (String indexType : indexTypes) {
            IndexPluginOptions indexOption = new IndexPluginOptions();
            indexOption.selectPlugin(indexType);
            if (crsCode != null) {
                if (indexOption.getDimensionalityOptions() instanceof SpatialOptions) {
                    ((SpatialOptions)indexOption.getDimensionalityOptions()).setCrs(crsCode);
                } else {
                    ((SpatialTemporalOptions)indexOption.getDimensionalityOptions()).setCrs(crsCode);
                }
            }
            if (indexOption.getDimensionalityOptions() instanceof TemporalOptions) {
                ((TemporalOptions)indexOption.getDimensionalityOptions()).setNoTimeRanges(!supportTimeRange);
            }
            indexOptions.add(indexOption);
        }
        File configFile = File.createTempFile("test_stats", null);
        ManualOperationParams params = new ManualOperationParams();
        params.getContext().put("properties-file", configFile);
        StringBuilder indexParam = new StringBuilder();
        for (int i = 0; i < indexOptions.size(); ++i) {
            AddIndexCommand addIndex = new AddIndexCommand();
            addIndex.setParameters("test-index" + i);
            addIndex.setPluginOptions((IndexPluginOptions)indexOptions.get(i));
            addIndex.execute((OperationParams)params);
            indexParam.append("test-index" + i + ",");
        }
        LocalToGeowaveCommand localIngester = new LocalToGeowaveCommand();
        localIngester.setPluginFormats(ingestFormatOptions);
        localIngester.setParameters(ingestFilePath, "test-store", indexParam.toString());
        localIngester.setThreads(nthreads);
        AddStoreCommand addStore = new AddStoreCommand();
        addStore.setParameters("test-store");
        addStore.setPluginOptions(dataStore);
        addStore.execute((OperationParams)params);
        localIngester.execute((OperationParams)params);
        TestUtils.verifyStats(dataStore);
    }

    public static void testS3LocalIngest(DataStorePluginOptions dataStore, DimensionalityType dimensionalityType, String s3Url, String ingestFilePath, String format, int nthreads) throws Exception {
        IngestFormatPluginOptions ingestFormatOptions = new IngestFormatPluginOptions();
        ingestFormatOptions.selectPlugin(format);
        String[] indexTypes = dimensionalityType.getDimensionalityArg().split(",");
        ArrayList<IndexPluginOptions> indexOptions = new ArrayList<IndexPluginOptions>(indexTypes.length);
        for (String indexType : indexTypes) {
            IndexPluginOptions indexOption = new IndexPluginOptions();
            indexOption.selectPlugin(indexType);
            indexOptions.add(indexOption);
        }
        File configFile = File.createTempFile("test_s3_local_ingest", null);
        ManualOperationParams operationParams = new ManualOperationParams();
        operationParams.getContext().put("properties-file", configFile);
        StringBuilder indexParam = new StringBuilder();
        for (int i = 0; i < indexOptions.size(); ++i) {
            AddIndexCommand addIndex = new AddIndexCommand();
            addIndex.setParameters("test-index" + i);
            addIndex.setPluginOptions((IndexPluginOptions)indexOptions.get(i));
            addIndex.execute((OperationParams)operationParams);
            indexParam.append("test-index" + i + ",");
        }
        ConfigAWSCommand configS3 = new ConfigAWSCommand();
        configS3.setS3UrlParameter(s3Url);
        configS3.execute((OperationParams)operationParams);
        LocalToGeowaveCommand localIngester = new LocalToGeowaveCommand();
        localIngester.setPluginFormats(ingestFormatOptions);
        localIngester.setParameters(ingestFilePath, "test-store", indexParam.toString());
        localIngester.setThreads(nthreads);
        AddStoreCommand addStore = new AddStoreCommand();
        addStore.setParameters("test-store");
        addStore.setPluginOptions(dataStore);
        addStore.execute((OperationParams)operationParams);
        localIngester.execute((OperationParams)operationParams);
        TestUtils.verifyStats(dataStore);
    }

    public static void testSparkIngest(DataStorePluginOptions dataStore, DimensionalityType dimensionalityType, String format) throws Exception {
        TestUtils.testSparkIngest(dataStore, dimensionalityType, S3URL, S3_INPUT_PATH, format);
    }

    public static void testSparkIngest(DataStorePluginOptions dataStore, DimensionalityType dimensionalityType, String s3Url, String ingestFilePath, String format) throws Exception {
        String[] indexTypes;
        String indexes = dimensionalityType.getDimensionalityArg();
        File configFile = File.createTempFile("test_spark_ingest", null);
        ManualOperationParams operationParams = new ManualOperationParams();
        operationParams.getContext().put("properties-file", configFile);
        ConfigAWSCommand configS3 = new ConfigAWSCommand();
        configS3.setS3UrlParameter(s3Url);
        configS3.execute((OperationParams)operationParams);
        LocalInputCommandLineOptions localOptions = new LocalInputCommandLineOptions();
        localOptions.setFormats(format);
        SparkCommandLineOptions sparkOptions = new SparkCommandLineOptions();
        sparkOptions.setAppName("SparkIngestTest");
        sparkOptions.setMaster("local");
        sparkOptions.setHost("localhost");
        SparkIngestDriver sparkIngester = new SparkIngestDriver();
        Properties props = new Properties();
        dataStore.save(props, DataStorePluginOptions.getStoreNamespace((String)"test"));
        AddStoreCommand addStore = new AddStoreCommand();
        addStore.setParameters("test");
        addStore.setPluginOptions(dataStore);
        addStore.execute((OperationParams)operationParams);
        for (String indexType : indexTypes = dimensionalityType.getDimensionalityArg().split(",")) {
            IndexPluginOptions pluginOptions = new IndexPluginOptions();
            pluginOptions.selectPlugin(indexType);
            pluginOptions.save(props, IndexPluginOptions.getIndexNamespace((String)indexType));
            AddIndexCommand addIndex = new AddIndexCommand();
            addIndex.setParameters(indexType);
            addIndex.setPluginOptions(pluginOptions);
            addIndex.execute((OperationParams)operationParams);
        }
        props.setProperty("s3.endpoint.url", s3Url);
        sparkIngester.runOperation(configFile, localOptions, "test", indexes, new VisibilityOptions(), sparkOptions, ingestFilePath);
        TestUtils.verifyStats(dataStore);
    }

    private static void verifyStats(DataStorePluginOptions dataStore) throws Exception {
        ListStatsCommand listStats = new ListStatsCommand();
        listStats.setParameters("test", null);
        File configFile = File.createTempFile("test_stats", null);
        ManualOperationParams params = new ManualOperationParams();
        params.getContext().put("properties-file", configFile);
        AddStoreCommand addStore = new AddStoreCommand();
        addStore.setParameters("test");
        addStore.setPluginOptions(dataStore);
        addStore.execute((OperationParams)params);
        try {
            listStats.execute((OperationParams)params);
        }
        catch (ParameterException e) {
            throw new RuntimeException(e);
        }
    }

    public static long hashCentroid(Geometry geometry) {
        Point centroid = geometry.getCentroid();
        return Double.doubleToLongBits(centroid.getX()) + Double.doubleToLongBits(centroid.getY() * 31.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExpectedResults getExpectedResults(CloseableIterator<?> results) throws IOException {
        HashSet<Long> hashedCentroids = new HashSet<Long>();
        int expectedResultCount = 0;
        try {
            while (results.hasNext()) {
                Object obj = results.next();
                if (!(obj instanceof SimpleFeature)) continue;
                ++expectedResultCount;
                SimpleFeature feature = (SimpleFeature)obj;
                hashedCentroids.add(TestUtils.hashCentroid((Geometry)feature.getDefaultGeometry()));
            }
        }
        finally {
            results.close();
        }
        return new ExpectedResults(hashedCentroids, expectedResultCount);
    }

    public static ExpectedResults getExpectedResults(URL[] expectedResultsResources) throws IOException {
        return TestUtils.getExpectedResults(expectedResultsResources, null);
    }

    public static MathTransform transformFromCrs(CoordinateReferenceSystem crs) {
        MathTransform mathTransform = null;
        if (crs != null) {
            try {
                mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)GeometryUtils.getDefaultCRS(), (CoordinateReferenceSystem)crs, (boolean)true);
            }
            catch (FactoryException e) {
                LOGGER.warn("Unable to create coordinate reference system transform", (Throwable)e);
            }
        }
        return mathTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExpectedResults getExpectedResults(URL[] expectedResultsResources, CoordinateReferenceSystem crs) throws IOException {
        HashMap<String, URL> map = new HashMap<String, URL>();
        DataStore dataStore = null;
        HashSet<Long> hashedCentroids = new HashSet<Long>();
        int expectedResultCount = 0;
        MathTransform mathTransform = TestUtils.transformFromCrs(crs);
        TWKBWriter writer = new TWKBWriter();
        TWKBReader reader = new TWKBReader();
        for (URL expectedResultsResource : expectedResultsResources) {
            map.put("url", expectedResultsResource);
            SimpleFeatureIterator featureIterator = null;
            try {
                dataStore = DataStoreFinder.getDataStore(map);
                if (dataStore == null) {
                    LOGGER.error("Could not get dataStore instance, getDataStore returned null");
                    throw new IOException("Could not get dataStore instance, getDataStore returned null");
                }
                SimpleFeatureCollection expectedResults = dataStore.getFeatureSource((Name)dataStore.getNames().get(0)).getFeatures();
                expectedResultCount += expectedResults.size();
                featureIterator = expectedResults.features();
                while (featureIterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)featureIterator.next();
                    Geometry geometry = (Geometry)feature.getDefaultGeometry();
                    long centroid = TestUtils.hashCentroid(reader.read(writer.write(mathTransform != null ? JTS.transform((Geometry)geometry, (MathTransform)mathTransform) : geometry)));
                    hashedCentroids.add(centroid);
                }
                IOUtils.closeQuietly((Closeable)featureIterator);
                if (dataStore == null) continue;
            }
            catch (ParseException | MismatchedDimensionException | TransformException e) {
                LOGGER.warn("Unable to transform geometry", e);
                Assert.fail((String)("Unable to transform geometry to CRS: " + crs.toString()));
                continue;
            }
            finally {
                IOUtils.closeQuietly(featureIterator);
                if (dataStore != null) {
                    dataStore.dispose();
                }
            }
            dataStore.dispose();
        }
        return new ExpectedResults(hashedCentroids, expectedResultCount);
    }

    public static QueryConstraints resourceToQuery(URL filterResource) throws IOException {
        return TestUtils.featureToQuery(TestUtils.resourceToFeature(filterResource), null, null, true);
    }

    public static QueryConstraints resourceToQuery(URL filterResource, Pair<String, String> optimalCqlQueryGeometryAndTimeFields, boolean useDuring) throws IOException {
        return TestUtils.featureToQuery(TestUtils.resourceToFeature(filterResource), optimalCqlQueryGeometryAndTimeFields, null, useDuring);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleFeature resourceToFeature(URL filterResource) throws IOException {
        SimpleFeature savedFilter;
        HashMap<String, URL> map = new HashMap<String, URL>();
        DataStore dataStore = null;
        map.put("url", filterResource);
        SimpleFeatureIterator sfi = null;
        try {
            dataStore = DataStoreFinder.getDataStore(map);
            if (dataStore == null) {
                LOGGER.error("Could not get dataStore instance, getDataStore returned null");
                throw new IOException("Could not get dataStore instance, getDataStore returned null");
            }
            sfi = dataStore.getFeatureSource((Name)dataStore.getNames().get(0)).getFeatures().features();
            savedFilter = (SimpleFeature)sfi.next();
        }
        finally {
            if (sfi != null) {
                sfi.close();
            }
            if (dataStore != null) {
                dataStore.dispose();
            }
        }
        return savedFilter;
    }

    public static QueryConstraints featureToQuery(SimpleFeature savedFilter, Pair<String, String> optimalCqlQueryGeometryAndTimeField, String crsCode, boolean useDuring) {
        Geometry filterGeometry = (Geometry)savedFilter.getDefaultGeometry();
        Object startObj = savedFilter.getAttribute(TEST_FILTER_START_TIME_ATTRIBUTE_NAME);
        Object endObj = savedFilter.getAttribute(TEST_FILTER_END_TIME_ATTRIBUTE_NAME);
        if (startObj != null && endObj != null) {
            Date startDate = null;
            Date endDate = null;
            if (startObj instanceof Calendar) {
                startDate = ((Calendar)startObj).getTime();
            } else if (startObj instanceof Date) {
                startDate = (Date)startObj;
            }
            if (endObj instanceof Calendar) {
                endDate = ((Calendar)endObj).getTime();
            } else if (endObj instanceof Date) {
                endDate = (Date)endObj;
            }
            if (startDate != null && endDate != null) {
                if (optimalCqlQueryGeometryAndTimeField != null) {
                    FilterFactory2 factory = CommonFactoryFinder.getFilterFactory2();
                    Filter timeConstraint = useDuring ? TimeUtils.toDuringFilter((long)startDate.getTime(), (long)endDate.getTime(), (String)((String)optimalCqlQueryGeometryAndTimeField.getRight())) : TimeUtils.toFilter((long)startDate.getTime(), (long)endDate.getTime(), (String)((String)optimalCqlQueryGeometryAndTimeField.getRight()), (String)((String)optimalCqlQueryGeometryAndTimeField.getRight()));
                    And expression = factory.and((Filter)GeometryUtils.geometryToSpatialOperator((Geometry)filterGeometry, (String)((String)optimalCqlQueryGeometryAndTimeField.getLeft())), timeConstraint);
                    return new OptimalCQLQuery((Filter)expression);
                }
                return new SpatialTemporalQuery(new ExplicitSpatialTemporalQuery(startDate, endDate, filterGeometry, crsCode));
            }
        }
        if (optimalCqlQueryGeometryAndTimeField != null) {
            return new OptimalCQLQuery((Filter)GeometryUtils.geometryToSpatialOperator((Geometry)filterGeometry, (String)((String)optimalCqlQueryGeometryAndTimeField.getLeft())));
        }
        return new SpatialQuery(new ExplicitSpatialQuery(filterGeometry, crsCode));
    }

    protected static void replaceParameters(Map<String, String> values, File file) throws IOException {
        String str = FileUtils.readFileToString((File)file);
        for (Map.Entry<String, String> entry : values.entrySet()) {
            str = str.replaceAll(entry.getKey(), entry.getValue());
        }
        FileUtils.deleteQuietly((File)file);
        FileUtils.write((File)file, (CharSequence)str);
    }

    public static void printStartOfTest(Logger logger, String testName) {
        String paddedName = StringUtils.center((String)("RUNNING " + testName), (int)37);
        logger.warn("-----------------------------------------");
        logger.warn("*                                       *");
        logger.warn("* " + paddedName + " *");
        logger.warn("*                                       *");
        logger.warn("-----------------------------------------");
    }

    public static void printEndOfTest(Logger logger, String testName, long startMillis) {
        double elapsedS = (double)(System.currentTimeMillis() - startMillis) / 1000.0;
        String paddedName = StringUtils.center((String)("FINISHED " + testName), (int)37);
        String paddedElapsed = StringUtils.center((String)(elapsedS + "s elapsed."), (int)37);
        logger.warn("-----------------------------------------");
        logger.warn("*                                       *");
        logger.warn("* " + paddedName + " *");
        logger.warn("* " + paddedElapsed + " *");
        logger.warn("*                                       *");
        logger.warn("-----------------------------------------");
    }

    public static void testTileAgainstReference(BufferedImage actual, BufferedImage expected, double minPctError, double maxPctError) {
        Assert.assertEquals((long)expected.getWidth(), (long)actual.getWidth());
        Assert.assertEquals((long)expected.getHeight(), (long)actual.getHeight());
        int totalPixels = expected.getWidth() * expected.getHeight();
        int minErrorPixels = (int)Math.round(minPctError * (double)totalPixels);
        int maxErrorPixels = (int)Math.round(maxPctError * (double)totalPixels);
        int errorPixels = 0;
        for (int x = 0; x < expected.getWidth(); ++x) {
            for (int y = 0; y < expected.getHeight(); ++y) {
                if (actual.getRGB(x, y) == expected.getRGB(x, y) || ++errorPixels <= maxErrorPixels) continue;
                Assert.fail((String)String.format("[%d,%d] failed to match ref=%d gen=%d", x, y, expected.getRGB(x, y), actual.getRGB(x, y)));
            }
        }
        if (errorPixels < minErrorPixels) {
            Assert.fail((String)String.format("Subsampling did not work as expected; error pixels (%d) did not exceed the minimum threshold (%d)", errorPixels, minErrorPixels));
        }
        if (errorPixels > 0) {
            System.out.println((float)errorPixels / (float)totalPixels + "% pixels differed from expected");
        }
    }

    public static double getTileValue(int x, int y, int b, int tileSize) {
        return TestUtils.getTileValue(x, y, b, 3, tileSize);
    }

    public static void fillTestRasters(WritableRaster raster1, WritableRaster raster2, int tileSize) {
        for (int x = 0; x < tileSize; ++x) {
            for (int y = 0; y < tileSize; ++y) {
                double wrongValue = TestUtils.getTileValue(y, x, y, tileSize) * 3.0 + 1.0;
                if (x < 2 && y < 2) {
                    raster1.setSample(x, y, 5, TestUtils.getTileValue(x, y, 5, tileSize));
                    raster1.setSample(x, y, 7, wrongValue);
                    raster2.setSample(x, y, 7, TestUtils.getTileValue(x, y, 7, tileSize));
                } else {
                    raster2.setSample(x, y, 5, TestUtils.getTileValue(x, y, 5, tileSize));
                }
                if (x > tileSize * 3 / 4 && y > tileSize * 3 / 4) {
                    raster1.setSample(x, y, 6, TestUtils.getTileValue(x, y, 6, tileSize));
                } else {
                    raster2.setSample(x, y, 6, TestUtils.getTileValue(x, y, 6, tileSize));
                    raster2.setSample(x, y, 7, TestUtils.getTileValue(x, y, 7, tileSize));
                }
                if (y % 2 == 0) {
                    raster1.setSample(x, y, 0, TestUtils.getTileValue(x, y, 0, tileSize));
                    raster1.setSample(x, y, 1, TestUtils.getTileValue(x, y, 1, tileSize));
                }
                raster1.setSample(x, y, 2, wrongValue);
                raster1.setSample(x, y, 4, TestUtils.getTileValue(x, y, 4, tileSize));
                if (y % 2 != 0) {
                    raster2.setSample(x, y, 1, TestUtils.getTileValue(x, y, 1, tileSize));
                }
                raster2.setSample(x, y, 2, TestUtils.getTileValue(x, y, 2, tileSize));
                raster2.setSample(x, y, 3, TestUtils.getTileValue(x, y, 3, tileSize));
            }
        }
    }

    public static double getTileValue(int x, int y, int b, int r, int tileSize) {
        double resultOfFunction = TestUtils.randomFunction(x, y, b, r, tileSize);
        if (r % 2 == 0) {
            return resultOfFunction;
        }
        if (rng == null) {
            rng = new Random((long)resultOfFunction);
        } else {
            rng.setSeed((long)resultOfFunction);
        }
        return rng.nextDouble() * resultOfFunction;
    }

    private static double randomFunction(int x, int y, int b, int r, int tileSize) {
        return (double)(x + y * tileSize) * 0.1 / (double)(b + 1) + (double)r;
    }

    @Deprecated
    public static void assert200(String msg, int responseCode) {
        Assert.assertEquals((String)msg, (long)200L, (long)responseCode);
    }

    @Deprecated
    public static void assert400(String msg, int responseCode) {
        Assert.assertEquals((String)msg, (long)400L, (long)responseCode);
    }

    @Deprecated
    public static void assert404(String msg, int responseCode) {
        Assert.assertEquals((String)msg, (long)404L, (long)responseCode);
    }

    public static void assertStatusCode(String msg, int expectedCode, Response response) {
        String assertionMsg = msg + String.format(": A %s response code should be received", expectedCode);
        Assert.assertEquals((String)assertionMsg, (long)expectedCode, (long)response.getStatus());
    }

    public static void assertStatusCode(int expectedCode, Response response) {
        TestUtils.assertStatusCode("REST call", expectedCode, response);
    }

    public static StoreTestEnvironment getTestEnvironment(String type) {
        for (GeoWaveTestStore.GeoWaveStoreType t : GeoWaveTestStore.GeoWaveStoreType.values()) {
            if (!t.getTestEnvironment().getDataStoreFactory().getType().equals(type)) continue;
            return t.getTestEnvironment();
        }
        return null;
    }

    static {
        try {
            CUSTOM_CRS = CRS.decode((String)CUSTOM_CRSCODE, (boolean)true);
        }
        catch (FactoryException e) {
            LOGGER.error("Unable to decode " + CUSTOM_CRSCODE + "CRS", (Throwable)e);
            throw new RuntimeException("Unable to initialize " + CUSTOM_CRSCODE + " CRS");
        }
        i = 0;
        rng = null;
    }

    public static class ExpectedResults {
        public Set<Long> hashedCentroids;
        public int count;

        @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
        public ExpectedResults(Set<Long> hashedCentroids, int count) {
            this.hashedCentroids = hashedCentroids;
            this.count = count;
        }
    }

    public static enum DimensionalityType {
        TEMPORAL("temporal", DEFAULT_TEMPORAL_INDEX),
        SPATIAL("spatial", DEFAULT_SPATIAL_INDEX),
        SPATIAL_TEMPORAL("spatial_temporal", DEFAULT_SPATIAL_TEMPORAL_INDEX),
        ALL("spatial,spatial_temporal", new Index[]{DEFAULT_SPATIAL_INDEX, DEFAULT_SPATIAL_TEMPORAL_INDEX});

        private final String dimensionalityArg;
        private final Index[] indices;

        private DimensionalityType(String dimensionalityArg, Index index) {
            this(dimensionalityArg, new Index[]{index});
        }

        private DimensionalityType(String dimensionalityArg, Index[] indices) {
            this.dimensionalityArg = dimensionalityArg;
            this.indices = indices;
        }

        public String getDimensionalityArg() {
            return this.dimensionalityArg;
        }

        public Index[] getDefaultIndices() {
            return this.indices;
        }
    }
}

