/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test.mapreduce;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.locationtech.geowave.adapter.vector.export.VectorMRExportCommand;
import org.locationtech.geowave.adapter.vector.export.VectorMRExportOptions;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.parser.ManualOperationParams;
import org.locationtech.geowave.core.ingest.operations.LocalToMapReduceToGeowaveCommand;
import org.locationtech.geowave.core.ingest.operations.options.IngestFormatPluginOptions;
import org.locationtech.geowave.core.store.cli.config.AddIndexCommand;
import org.locationtech.geowave.core.store.cli.config.AddStoreCommand;
import org.locationtech.geowave.core.store.cli.remote.options.DataStorePluginOptions;
import org.locationtech.geowave.core.store.cli.remote.options.IndexPluginOptions;
import org.locationtech.geowave.mapreduce.operations.ConfigHDFSCommand;
import org.locationtech.geowave.test.TestUtils;
import org.locationtech.geowave.test.mapreduce.MapReduceTestEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapReduceTestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapReduceTestUtils.class);
    public static final String TEST_EXPORT_DIRECTORY = "basicMapReduceIT-export";
    public static final String EXPECTED_RESULTS_KEY = "EXPECTED_RESULTS";
    public static final int MIN_INPUT_SPLITS = 3;
    public static final int MAX_INPUT_SPLITS = 5;

    public static void testMapReduceIngest(DataStorePluginOptions dataStore, TestUtils.DimensionalityType dimensionalityType, String ingestFilePath) throws Exception {
        MapReduceTestUtils.testMapReduceIngest(dataStore, dimensionalityType, "gpx", ingestFilePath);
    }

    public static void testMapReduceExport(DataStorePluginOptions inputStorePluginOptions) throws Exception {
        MapReduceTestUtils.testMapReduceExport(inputStorePluginOptions, TEST_EXPORT_DIRECTORY);
    }

    public static void testMapReduceExport(DataStorePluginOptions inputStorePluginOptions, String directory) throws Exception {
        VectorMRExportCommand exportCommand = new VectorMRExportCommand();
        VectorMRExportOptions options = exportCommand.getMrOptions();
        exportCommand.setStoreOptions(inputStorePluginOptions);
        MapReduceTestEnvironment env = MapReduceTestEnvironment.getInstance();
        String exportPath = env.getHdfsBaseDirectory() + "/" + directory;
        File exportDir = new File(exportPath.replace("file:", ""));
        if (exportDir.exists()) {
            boolean deleted = false;
            int attempts = 5;
            while (!deleted && attempts-- > 0) {
                try {
                    FileUtils.deleteDirectory((File)exportDir);
                    deleted = true;
                }
                catch (Exception e) {
                    LOGGER.error("Export directory not deleted, trying again in 10s: " + e);
                    Thread.sleep(10000L);
                }
            }
        }
        exportCommand.setParameters(exportPath, null);
        options.setBatchSize(10000);
        options.setMinSplits(Integer.valueOf(3));
        options.setMaxSplits(Integer.valueOf(5));
        options.setResourceManagerHostPort(env.getJobtracker());
        Configuration conf = MapReduceTestUtils.getConfiguration();
        MapReduceTestUtils.filterConfiguration(conf);
        int res = ToolRunner.run((Configuration)conf, (Tool)exportCommand.createRunner((OperationParams)env.getOperationParams()), (String[])new String[0]);
        Assert.assertTrue((String)"Export Vector Data map reduce job failed", (res == 0 ? 1 : 0) != 0);
        TestUtils.deleteAll(inputStorePluginOptions);
    }

    public static void testMapReduceExportAndReingest(DataStorePluginOptions inputStorePluginOptions, DataStorePluginOptions outputStorePluginOptions, TestUtils.DimensionalityType dimensionalityType) throws Exception {
        MapReduceTestUtils.testMapReduceExport(inputStorePluginOptions);
        MapReduceTestUtils.testMapReduceIngest(outputStorePluginOptions, dimensionalityType, "avro", TestUtils.TEMP_DIR + File.separator + "test_tmp" + File.separator + TEST_EXPORT_DIRECTORY);
    }

    public static void testMapReduceIngest(DataStorePluginOptions dataStore, TestUtils.DimensionalityType dimensionalityType, String format, String ingestFilePath) throws Exception {
        LOGGER.warn("Ingesting '" + ingestFilePath + "' - this may take several minutes...");
        Thread progressLogger = MapReduceTestUtils.startProgressLogger();
        String[] indexTypes = dimensionalityType.getDimensionalityArg().split(",");
        ArrayList<IndexPluginOptions> indexOptions = new ArrayList<IndexPluginOptions>(indexTypes.length);
        for (String indexType : indexTypes) {
            IndexPluginOptions indexOption = new IndexPluginOptions();
            indexOption.selectPlugin(indexType);
            indexOptions.add(indexOption);
        }
        MapReduceTestEnvironment env = MapReduceTestEnvironment.getInstance();
        IngestFormatPluginOptions ingestFormatOptions = new IngestFormatPluginOptions();
        ingestFormatOptions.selectPlugin(format);
        File configFile = File.createTempFile("test_mr", null);
        ManualOperationParams operationParams = new ManualOperationParams();
        operationParams.getContext().put("properties-file", configFile);
        ConfigHDFSCommand configHdfs = new ConfigHDFSCommand();
        configHdfs.setHdfsUrlParameter(env.getHdfs());
        configHdfs.execute((OperationParams)operationParams);
        LocalToMapReduceToGeowaveCommand mrGw = new LocalToMapReduceToGeowaveCommand();
        AddStoreCommand addStore = new AddStoreCommand();
        addStore.setParameters("test-store");
        addStore.setPluginOptions(dataStore);
        addStore.execute((OperationParams)operationParams);
        StringBuilder indexParam = new StringBuilder();
        for (int i = 0; i < indexOptions.size(); ++i) {
            AddIndexCommand addIndex = new AddIndexCommand();
            addIndex.setParameters("test-index" + i);
            addIndex.setPluginOptions((IndexPluginOptions)indexOptions.get(i));
            addIndex.execute((OperationParams)operationParams);
            indexParam.append("test-index" + i + ",");
        }
        mrGw.setPluginFormats(ingestFormatOptions);
        mrGw.setParameters(ingestFilePath, env.getHdfsBaseDirectory(), "test-store", indexParam.toString());
        mrGw.getMapReduceOptions().setJobTrackerHostPort(env.getJobtracker());
        mrGw.execute((OperationParams)operationParams);
        progressLogger.interrupt();
    }

    private static Thread startProgressLogger() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    while (true) {
                        long now = System.currentTimeMillis();
                        LOGGER.warn("Ingest running, progress: " + (now - start) / 1000L + "s.");
                        Thread.sleep(60000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
        return t;
    }

    public static void filterConfiguration(Configuration conf) {
        conf.unset("mapreduce.job.end-notification.max.retry.interval");
        conf.unset("mapreduce.job.end-notification.max.attempts");
        conf.unset("session.id");
        conf.unset("mapred.jar");
        conf.unset("fs.default.name");
        conf.unset("mapred.map.tasks.speculative.execution");
        conf.unset("mapred.reduce.tasks");
        conf.unset("mapred.reduce.tasks.speculative.execution");
        conf.unset("mapred.mapoutput.value.class");
        conf.unset("mapred.used.genericoptionsparser");
        conf.unset("mapreduce.map.class");
        conf.unset("mapred.job.name");
        conf.unset("mapreduce.inputformat.class");
        conf.unset("mapred.input.dir");
        conf.unset("mapreduce.outputformat.class");
        conf.unset("mapred.map.tasks");
        conf.unset("mapred.mapoutput.key.class");
        conf.unset("mapred.working.dir");
    }

    public static Configuration getConfiguration() {
        Configuration conf = new Configuration();
        MapReduceTestEnvironment env = MapReduceTestEnvironment.getInstance();
        conf.set("fs.defaultFS", env.getHdfs());
        conf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
        conf.set("mapreduce.jobtracker.address", env.getJobtracker());
        MapReduceTestUtils.filterConfiguration(conf);
        return conf;
    }
}

