/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test.spark;

import java.net.URL;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.locationtech.geowave.analytic.spark.GeoWaveRDD;
import org.locationtech.geowave.analytic.spark.GeoWaveRDDLoader;
import org.locationtech.geowave.analytic.spark.RDDOptions;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.store.api.Query;
import org.locationtech.geowave.core.store.api.QueryBuilder;
import org.locationtech.geowave.core.store.cli.remote.options.DataStorePluginOptions;
import org.locationtech.geowave.core.store.query.constraints.QueryConstraints;
import org.locationtech.geowave.mapreduce.input.GeoWaveInputKey;
import org.locationtech.geowave.test.TestUtils;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkUtils.class);
    private static final int DEFAULT_SPLITS_FOR_COUNT = 100;

    public static void verifyQuery(DataStorePluginOptions dataStore, SparkContext context, URL filterFile, URL[] expectedResultsFiles, String name, Pair<String, String> optimalCqlQueryGeometryAndTimeFields, boolean useDuring) {
        SparkUtils.verifyQuery(dataStore, context, filterFile, expectedResultsFiles, name, null, optimalCqlQueryGeometryAndTimeFields, useDuring);
    }

    public static void verifyQuery(DataStorePluginOptions dataStore, SparkContext context, URL filterFile, URL[] expectedResultsFiles, String name, CoordinateReferenceSystem crsTransform, Pair<String, String> optimalCqlQueryGeometryAndTimeFields, boolean useDuring) {
        try {
            QueryConstraints query;
            TestUtils.ExpectedResults expectedResults = TestUtils.getExpectedResults(expectedResultsFiles);
            if (crsTransform != null) {
                SimpleFeature feature = TestUtils.resourceToFeature(filterFile);
                query = TestUtils.featureToQuery(GeometryUtils.crsTransform((SimpleFeature)feature, (SimpleFeatureType)SimpleFeatureTypeBuilder.retype((SimpleFeatureType)feature.getFeatureType(), (CoordinateReferenceSystem)crsTransform), (MathTransform)CRS.findMathTransform((CoordinateReferenceSystem)GeometryUtils.getDefaultCRS(), (CoordinateReferenceSystem)crsTransform, (boolean)true)), null, GeometryUtils.getCrsCode((CoordinateReferenceSystem)crsTransform), useDuring);
            } else {
                query = TestUtils.resourceToQuery(filterFile, optimalCqlQueryGeometryAndTimeFields, useDuring);
            }
            RDDOptions queryOpts = new RDDOptions();
            queryOpts.setQuery((Query)((QueryBuilder)QueryBuilder.newBuilder().constraints(query)).build());
            queryOpts.setMinSplits(100);
            queryOpts.setMaxSplits(100);
            GeoWaveRDD newRDD = GeoWaveRDDLoader.loadRDD((SparkContext)context, (DataStorePluginOptions)dataStore, (RDDOptions)queryOpts);
            JavaPairRDD javaRdd = newRDD.getRawRDD();
            long count = SparkUtils.getCount((JavaPairRDD<GeoWaveInputKey, SimpleFeature>)javaRdd, dataStore.getType());
            LOGGER.warn("DataStore loaded into RDD with " + count + " features.");
            Assert.assertEquals((long)expectedResults.count, (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestUtils.deleteAll(dataStore);
            Assert.fail((String)("Error occurred while testing '" + name + "'"));
        }
    }

    public static long getCount(JavaPairRDD<GeoWaveInputKey, SimpleFeature> javaRdd, String dataStoreType) {
        return javaRdd.countByKey().size();
    }
}

