/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.archiver.tar.TarGZipUnArchiver;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.locationtech.geowave.adapter.raster.util.ZipUtils;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.test.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigtableEmulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BigtableEmulator.class);
    public static final String HOST_PORT_PROPERTY = "bigtable.emulator.endpoint";
    public static final String INTERNAL_PROPERTY = "bigtable.emulator.internal";
    public static final String DOWNLOAD_URL_PROPERTY = "bigtable.sdk.url";
    public static final String DOWNLOAD_FILE_PROPERTY = "bigtable.sdk.file";
    private final String downloadUrl;
    private final String fileName;
    private static final String GCLOUD_EXE_DIR = "google-cloud-sdk/bin";
    private final Object STARTUP_LOCK = new Object();
    private boolean matchFound = false;
    private final long MAX_STARTUP_WAIT = 60000L;
    private final File sdkDir;
    private ExecuteWatchdog watchdog;

    public BigtableEmulator(String sdkDir, String sdkDownloadUrl, String sdkFileName) {
        this.sdkDir = TestUtils.isSet(sdkDir) ? new File(sdkDir) : new File(TestUtils.TEMP_DIR, "gcloud");
        this.downloadUrl = sdkDownloadUrl;
        this.fileName = sdkFileName;
        if (!this.sdkDir.exists() && !this.sdkDir.mkdirs()) {
            LOGGER.warn("unable to create directory " + this.sdkDir.getAbsolutePath());
        }
    }

    public boolean start(String emulatorHostPort) {
        if (!this.isInstalled()) {
            try {
                if (!this.install()) {
                    return false;
                }
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage());
                return false;
            }
        }
        try {
            this.startEmulator(emulatorHostPort);
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error(e.getMessage());
            return false;
        }
        return true;
    }

    public boolean isRunning() {
        return this.watchdog != null && this.watchdog.isWatching();
    }

    public void stop() {
        this.watchdog.destroyProcess();
        String KILL_CMD_1 = "for i in $(ps -ef | grep -i \"[b]eta emulators bigtable\" | awk '{print $2}'); do kill -9 $i; done";
        String KILL_CMD_2 = "for i in $(ps -ef | grep -i \"[c]btemulator\" | awk '{print $2}'); do kill -9 $i; done";
        File bashFile = new File(TestUtils.TEMP_DIR, "kill-bigtable.sh");
        try {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(bashFile), "UTF-8");
            PrintWriter scriptWriter = new PrintWriter(w);
            scriptWriter.println("#!/bin/bash");
            scriptWriter.println("set -ev");
            scriptWriter.println("for i in $(ps -ef | grep -i \"[b]eta emulators bigtable\" | awk '{print $2}'); do kill -9 $i; done");
            scriptWriter.println("for i in $(ps -ef | grep -i \"[c]btemulator\" | awk '{print $2}'); do kill -9 $i; done");
            scriptWriter.close();
            bashFile.setExecutable(true);
        }
        catch (FileNotFoundException e1) {
            LOGGER.error("Unable to create bigtable emulator kill script", (Throwable)e1);
            return;
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Unable to create bigtable emulator kill script", (Throwable)e);
        }
        CommandLine cmdLine = new CommandLine(bashFile.getAbsolutePath());
        DefaultExecutor executor = new DefaultExecutor();
        int exitValue = 0;
        try {
            exitValue = executor.execute(cmdLine);
        }
        catch (IOException ex) {
            LOGGER.error("Unable to execute bigtable emulator kill script", (Throwable)ex);
        }
        LOGGER.warn("Bigtable emulator " + (exitValue == 0 ? "stopped" : "failed to stop"));
    }

    private boolean isInstalled() {
        File gcloudExe = new File(this.sdkDir, "google-cloud-sdk/bin/gcloud");
        return gcloudExe.canExecute();
    }

    protected boolean install() throws IOException {
        URL url = new URL(this.downloadUrl + "/" + this.fileName);
        File downloadFile = new File(this.sdkDir.getParentFile(), this.fileName);
        if (!downloadFile.exists()) {
            try (FileOutputStream fos = new FileOutputStream(downloadFile);){
                IOUtils.copyLarge((InputStream)url.openStream(), (OutputStream)fos);
                fos.flush();
            }
        }
        if (downloadFile.getName().endsWith(".zip")) {
            ZipUtils.unZipFile((File)downloadFile, (String)this.sdkDir.getAbsolutePath());
        } else if (downloadFile.getName().endsWith(".tar.gz")) {
            TarGZipUnArchiver unarchiver = new TarGZipUnArchiver();
            unarchiver.enableLogging((org.codehaus.plexus.logging.Logger)new ConsoleLogger(2, "Gcloud SDK Unarchive"));
            unarchiver.setSourceFile(downloadFile);
            unarchiver.setDestDirectory(this.sdkDir);
            unarchiver.extract();
        }
        if (!downloadFile.delete()) {
            LOGGER.warn("cannot delete " + downloadFile.getAbsolutePath());
        }
        if (!this.isInstalled()) {
            LOGGER.error("Gcloud install failed");
            return false;
        }
        File gcloudExe = new File(this.sdkDir, "google-cloud-sdk/bin/gcloud");
        CommandLine cmdLine = new CommandLine(gcloudExe);
        cmdLine.addArgument("components");
        cmdLine.addArgument("install");
        cmdLine.addArgument("beta");
        cmdLine.addArgument("--quiet");
        DefaultExecutor executor = new DefaultExecutor();
        int exitValue = executor.execute(cmdLine);
        return exitValue == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startEmulator(final String emulatorHostPort) throws ExecuteException, IOException, InterruptedException {
        CommandLine cmdLine = new CommandLine(this.sdkDir + "/" + GCLOUD_EXE_DIR + "/gcloud");
        cmdLine.addArgument("beta");
        cmdLine.addArgument("emulators");
        cmdLine.addArgument("bigtable");
        cmdLine.addArgument("start");
        cmdLine.addArgument("--quiet");
        cmdLine.addArgument("--host-port");
        cmdLine.addArgument(emulatorHostPort);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        this.watchdog = new ExecuteWatchdog(-1L);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWatchdog(this.watchdog);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(ByteStreams.nullOutputStream(), ByteStreams.nullOutputStream(), null){

            protected Thread createPump(InputStream is, OutputStream os, boolean closeWhenExhausted) {
                FilterInputStream fis = new FilterInputStream(is){
                    byte[] startupBytes;
                    Queue<Integer> queue;
                    {
                        this.startupBytes = ("running on " + emulatorHostPort).getBytes(StringUtils.UTF8_CHARSET);
                        this.queue = new LinkedList<Integer>();
                    }

                    private boolean isStartupFound() {
                        Integer[] array = this.queue.toArray(new Integer[0]);
                        byte[] ba = new byte[array.length];
                        for (int i = 0; i < ba.length; ++i) {
                            ba[i] = array[i].byteValue();
                        }
                        Iterator iterator = this.queue.iterator();
                        for (byte b : this.startupBytes) {
                            if (iterator.hasNext() && b == (Integer)iterator.next()) continue;
                            return false;
                        }
                        return true;
                    }

                    private void readAhead() throws IOException {
                        while (this.queue.size() < this.startupBytes.length) {
                            int next = super.read();
                            this.queue.offer(next);
                            if (next != -1) continue;
                            break;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public int read() throws IOException {
                        if (BigtableEmulator.this.matchFound) {
                            super.read();
                        }
                        this.readAhead();
                        if (this.isStartupFound()) {
                            Object object = BigtableEmulator.this.STARTUP_LOCK;
                            synchronized (object) {
                                BigtableEmulator.this.STARTUP_LOCK.notifyAll();
                            }
                            BigtableEmulator.this.matchFound = true;
                        }
                        return this.queue.remove();
                    }

                    @Override
                    public int read(byte[] b) throws IOException {
                        if (BigtableEmulator.this.matchFound) {
                            super.read(b);
                        }
                        return this.read(b, 0, b.length);
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        int i;
                        if (BigtableEmulator.this.matchFound) {
                            super.read(b, off, len);
                        }
                        if (b == null) {
                            throw new NullPointerException();
                        }
                        if (off < 0 || len < 0 || len > b.length - off) {
                            throw new IndexOutOfBoundsException();
                        }
                        if (len == 0) {
                            return 0;
                        }
                        int c = this.read();
                        if (c == -1) {
                            return -1;
                        }
                        b[off] = (byte)c;
                        try {
                            for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                                b[off + i] = (byte)c;
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return i;
                    }
                };
                return super.createPump((InputStream)fis, os, closeWhenExhausted);
            }
        });
        LOGGER.warn("Starting BigTable Emulator: " + cmdLine.toString());
        Object object = this.STARTUP_LOCK;
        synchronized (object) {
            executor.execute(cmdLine, (ExecuteResultHandler)resultHandler);
            this.STARTUP_LOCK.wait(60000L);
        }
    }
}

