/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test;

import org.junit.contrib.java.lang.system.EnvironmentVariables;
import org.locationtech.geowave.core.store.GenericStoreFactory;
import org.locationtech.geowave.core.store.StoreFactoryOptions;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.datastore.bigtable.BigTableStoreFactoryFamily;
import org.locationtech.geowave.test.BigtableEmulator;
import org.locationtech.geowave.test.StoreTestEnvironment;
import org.locationtech.geowave.test.TestEnvironment;
import org.locationtech.geowave.test.TestUtils;
import org.locationtech.geowave.test.annotation.GeoWaveTestStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigtableStoreTestEnvironment
extends StoreTestEnvironment {
    private static final GenericStoreFactory<DataStore> STORE_FACTORY = new BigTableStoreFactoryFamily().getDataStoreFactory();
    private static BigtableStoreTestEnvironment singletonInstance = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(BigtableStoreTestEnvironment.class);
    protected BigtableEmulator emulator;
    private boolean internalEmulator = true;
    private String emulatorHostPort = "127.0.0.1:8086";
    private String sdkDownloadUrl = "https://dl.google.com/dl/cloudsdk/channels/rapid/downloads";
    private String sdkFile = "google-cloud-sdk-183.0.0-linux-x86_64.tar.gz";
    private boolean environmentInitialized = false;

    public static synchronized BigtableStoreTestEnvironment getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new BigtableStoreTestEnvironment();
        }
        return singletonInstance;
    }

    private BigtableStoreTestEnvironment() {
    }

    @Override
    protected void initOptions(StoreFactoryOptions options) {
    }

    @Override
    protected GenericStoreFactory<DataStore> getDataStoreFactory() {
        return STORE_FACTORY;
    }

    @Override
    protected GeoWaveTestStore.GeoWaveStoreType getStoreType() {
        return GeoWaveTestStore.GeoWaveStoreType.BIGTABLE;
    }

    @Override
    public void setup() {
        this.initEnv();
        if (this.internalEmulator && this.emulator == null) {
            String downloadUrlProp = System.getProperty("bigtable.sdk.url");
            if (TestUtils.isSet(downloadUrlProp)) {
                this.sdkDownloadUrl = downloadUrlProp;
                LOGGER.warn("Bigtable SDK download URL: " + this.sdkDownloadUrl);
            } else {
                LOGGER.warn("Bigtable SDK download URL (default): " + this.sdkDownloadUrl);
            }
            String downloadFileProp = System.getProperty("bigtable.sdk.file");
            if (TestUtils.isSet(downloadFileProp)) {
                this.sdkFile = downloadFileProp;
                LOGGER.warn("Bigtable SDK file: " + this.sdkFile);
            } else {
                LOGGER.warn("Bigtable SDK file (default): " + this.sdkFile);
            }
            this.emulator = new BigtableEmulator(null, this.sdkDownloadUrl, this.sdkFile);
            if (this.emulator.isRunning()) {
                this.emulator.stop();
            }
            if (!this.emulator.start(this.emulatorHostPort)) {
                LOGGER.error("Bigtable emulator startup failed");
            }
        }
    }

    private void initEnv() {
        if (!this.environmentInitialized) {
            String internalEmulatorProp = System.getProperty("bigtable.emulator.internal");
            if (TestUtils.isSet(internalEmulatorProp)) {
                this.internalEmulator = Boolean.parseBoolean(internalEmulatorProp);
                LOGGER.warn("Bigtable internal emulator enabled: " + this.internalEmulator);
            } else {
                LOGGER.warn("Bigtable internal emulator disabled by default");
            }
            String hostPortProp = System.getProperty("bigtable.emulator.endpoint");
            if (TestUtils.isSet(hostPortProp)) {
                this.emulatorHostPort = hostPortProp;
                LOGGER.warn("Bigtable emulator will run at: " + this.emulatorHostPort);
            } else {
                LOGGER.warn("Bigtable emulator will run at default location: " + this.emulatorHostPort);
            }
            EnvironmentVariables environmentVariables = new EnvironmentVariables();
            environmentVariables.set("BIGTABLE_EMULATOR_HOST", this.emulatorHostPort);
            this.environmentInitialized = true;
        }
    }

    @Override
    public void tearDown() {
        if (this.internalEmulator && this.emulator != null) {
            this.emulator.stop();
            this.emulator = null;
        }
    }

    @Override
    public TestEnvironment[] getDependentEnvironments() {
        return new TestEnvironment[0];
    }
}

