/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.archiver.tar.TarGZipUnArchiver;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.locationtech.geowave.test.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDBLocal {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamoDBLocal.class);
    private static final String DYNDB_URL = "https://s3-us-west-2.amazonaws.com/dynamodb-local/";
    private static final String DYNDB_TAR = "dynamodb_local_latest.tar.gz";
    private static final String HOST_PORT = "8000";
    private static final long EMULATOR_SPINUP_DELAY_MS = 30000L;
    private final File dynLocalDir;
    private ExecuteWatchdog watchdog;

    public DynamoDBLocal(String localDir) {
        this.dynLocalDir = TestUtils.isSet(localDir) ? new File(localDir) : new File(TestUtils.TEMP_DIR, "dynamodb");
        if (!this.dynLocalDir.exists() && !this.dynLocalDir.mkdirs()) {
            LOGGER.warn("unable to create directory " + this.dynLocalDir.getAbsolutePath());
        }
    }

    public boolean start() {
        if (!this.isInstalled()) {
            try {
                if (!this.install()) {
                    return false;
                }
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage());
                return false;
            }
        }
        try {
            this.startDynamoLocal();
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error(e.getMessage());
            return false;
        }
        return true;
    }

    public boolean isRunning() {
        return this.watchdog != null && this.watchdog.isWatching();
    }

    public void stop() {
        this.watchdog.destroyProcess();
    }

    private boolean isInstalled() {
        File dynLocalJar = new File(this.dynLocalDir, "DynamoDBLocal.jar");
        return dynLocalJar.canRead();
    }

    protected boolean install() throws IOException {
        HttpURLConnection.setFollowRedirects(true);
        URL url = new URL("https://s3-us-west-2.amazonaws.com/dynamodb-local/dynamodb_local_latest.tar.gz");
        File downloadFile = new File(this.dynLocalDir, DYNDB_TAR);
        if (!downloadFile.exists()) {
            try (FileOutputStream fos = new FileOutputStream(downloadFile);){
                IOUtils.copyLarge((InputStream)url.openStream(), (OutputStream)fos);
                fos.flush();
            }
        }
        TarGZipUnArchiver unarchiver = new TarGZipUnArchiver();
        unarchiver.enableLogging((org.codehaus.plexus.logging.Logger)new ConsoleLogger(2, "DynamoDB Local Unarchive"));
        unarchiver.setSourceFile(downloadFile);
        unarchiver.setDestDirectory(this.dynLocalDir);
        unarchiver.extract();
        if (!downloadFile.delete()) {
            LOGGER.warn("cannot delete " + downloadFile.getAbsolutePath());
        }
        if (!this.isInstalled()) {
            LOGGER.error("DynamoDB Local install failed");
            return false;
        }
        return true;
    }

    private void startDynamoLocal() throws ExecuteException, IOException, InterruptedException {
        CommandLine cmdLine = new CommandLine("java");
        cmdLine.addArgument("-Djava.library.path=" + this.dynLocalDir + "/DynamoDBLocal_lib");
        cmdLine.addArgument("-jar");
        cmdLine.addArgument(this.dynLocalDir + "/DynamoDBLocal.jar");
        cmdLine.addArgument("-sharedDb");
        cmdLine.addArgument("-inMemory");
        cmdLine.addArgument("-port");
        cmdLine.addArgument(HOST_PORT);
        System.setProperty("aws.accessKeyId", "dummy");
        System.setProperty("aws.secretKey", "dummy");
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        this.watchdog = new ExecuteWatchdog(-1L);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWatchdog(this.watchdog);
        executor.execute(cmdLine, (ExecuteResultHandler)resultHandler);
        Thread.sleep(30000L);
    }
}

