/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test;

import java.util.Arrays;
import org.apache.hadoop.hbase.security.User;
import org.locationtech.geowave.core.store.GenericStoreFactory;
import org.locationtech.geowave.core.store.StoreFactoryOptions;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.datastore.hbase.HBaseStoreFactoryFamily;
import org.locationtech.geowave.datastore.hbase.cli.HBaseMiniCluster;
import org.locationtech.geowave.datastore.hbase.config.HBaseRequiredOptions;
import org.locationtech.geowave.test.StoreTestEnvironment;
import org.locationtech.geowave.test.TestEnvironment;
import org.locationtech.geowave.test.TestUtils;
import org.locationtech.geowave.test.ZookeeperTestEnvironment;
import org.locationtech.geowave.test.annotation.GeoWaveTestStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseStoreTestEnvironment
extends StoreTestEnvironment {
    private static final GenericStoreFactory<DataStore> STORE_FACTORY = new HBaseStoreFactoryFamily().getDataStoreFactory();
    private static final int NUM_REGION_SERVERS = 2;
    private static HBaseStoreTestEnvironment singletonInstance = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(HBaseStoreTestEnvironment.class);
    public static final String DEFAULT_HBASE_TEMP_DIR = "./target/hbase_temp";
    protected String zookeeper;
    private HBaseMiniCluster hbaseMiniCluster;
    private static String[] auths = new String[]{"a", "b", "c", "z"};
    protected User SUPERUSER;

    public static synchronized HBaseStoreTestEnvironment getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new HBaseStoreTestEnvironment();
        }
        return singletonInstance;
    }

    @Override
    protected void initOptions(StoreFactoryOptions options) {
        HBaseRequiredOptions hbaseRequiredOptions = (HBaseRequiredOptions)options;
        hbaseRequiredOptions.setZookeeper(this.zookeeper);
    }

    @Override
    protected GenericStoreFactory<DataStore> getDataStoreFactory() {
        return STORE_FACTORY;
    }

    @Override
    public void setup() {
        if (this.hbaseMiniCluster == null) {
            if (!TestUtils.isSet(this.zookeeper)) {
                this.zookeeper = System.getProperty("zookeeperUrl");
                if (!TestUtils.isSet(this.zookeeper)) {
                    this.zookeeper = ZookeeperTestEnvironment.getInstance().getZookeeper();
                    LOGGER.debug("Using local zookeeper URL: " + this.zookeeper);
                }
            }
            this.hbaseMiniCluster = new HBaseMiniCluster(Arrays.asList(auths), "./target/zk_temp", "./target/hbase/lib", DEFAULT_HBASE_TEMP_DIR, 2);
            this.hbaseMiniCluster.setup();
        }
    }

    @Override
    public void tearDown() {
        if (this.hbaseMiniCluster != null) {
            this.hbaseMiniCluster.tearDown();
            this.hbaseMiniCluster = null;
        }
    }

    @Override
    protected GeoWaveTestStore.GeoWaveStoreType getStoreType() {
        return GeoWaveTestStore.GeoWaveStoreType.HBASE;
    }

    @Override
    public TestEnvironment[] getDependentEnvironments() {
        return new TestEnvironment[]{ZookeeperTestEnvironment.getInstance()};
    }
}

