/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.locationtech.geowave.test.TestEnvironment;
import org.locationtech.geowave.test.kafka.KafkaTestEnvironment;
import org.locationtech.geowave.test.mapreduce.MapReduceTestEnvironment;
import org.locationtech.geowave.test.services.ServicesTestEnvironment;
import org.locationtech.geowave.test.spark.SparkTestEnvironment;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface Environments {
    public Environment[] value();

    public static enum Environment {
        MAP_REDUCE(MapReduceTestEnvironment.getInstance()),
        KAFKA(KafkaTestEnvironment.getInstance()),
        SERVICES(ServicesTestEnvironment.getInstance()),
        SPARK(SparkTestEnvironment.getInstance());

        private final TestEnvironment testEnvironment;

        private Environment(TestEnvironment testEnvironment) {
            this.testEnvironment = testEnvironment;
        }

        public TestEnvironment getTestEnvironment() {
            return this.testEnvironment;
        }
    }
}

