/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test.mapreduce;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.parser.ManualOperationParams;
import org.locationtech.geowave.mapreduce.operations.ConfigHDFSCommand;
import org.locationtech.geowave.test.TestEnvironment;
import org.locationtech.geowave.test.TestUtils;
import org.locationtech.geowave.test.mapreduce.MapReduceTestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapReduceTestEnvironment
implements TestEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapReduceTestEnvironment.class);
    private static MapReduceTestEnvironment singletonInstance = null;
    public static final String HDFS_BASE_DIRECTORY = "test_tmp";
    private static final String DEFAULT_JOB_TRACKER = "local";
    private String jobtracker;
    private String hdfs;
    private boolean hdfsProtocol;
    private String hdfsBaseDirectory;
    private ManualOperationParams operationParams;
    private File configFile;

    public static synchronized MapReduceTestEnvironment getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new MapReduceTestEnvironment();
        }
        return singletonInstance;
    }

    private MapReduceTestEnvironment() {
    }

    @Override
    public void setup() throws Exception {
        this.hdfs = System.getProperty("hdfs");
        this.jobtracker = System.getProperty("jobtracker");
        if (!TestUtils.isSet(this.hdfs)) {
            this.hdfs = "file:///";
            this.hdfsBaseDirectory = TestUtils.TEMP_DIR.toURI().toURL().toString() + "/" + HDFS_BASE_DIRECTORY;
            this.hdfsProtocol = false;
            this.configFile = File.createTempFile("test_mr", null);
            this.operationParams = new ManualOperationParams();
            this.operationParams.getContext().put("properties-file", this.configFile);
            ConfigHDFSCommand configHdfs = new ConfigHDFSCommand();
            configHdfs.setHdfsUrlParameter(this.hdfs);
            configHdfs.execute((OperationParams)this.operationParams);
        } else {
            this.hdfsBaseDirectory = HDFS_BASE_DIRECTORY;
            if (!this.hdfs.contains("://")) {
                this.hdfs = "hdfs://" + this.hdfs;
                this.hdfsProtocol = true;
            } else {
                this.hdfsProtocol = this.hdfs.toLowerCase(Locale.ENGLISH).startsWith("hdfs://");
            }
        }
        if (!TestUtils.isSet(this.jobtracker)) {
            this.jobtracker = DEFAULT_JOB_TRACKER;
        }
    }

    @Override
    public void tearDown() {
        block9: {
            try {
                if (this.hdfsProtocol) {
                    Path tmpDir = new Path(this.hdfsBaseDirectory);
                    try (FileSystem fs = null;){
                        fs = FileSystem.get((Configuration)MapReduceTestUtils.getConfiguration());
                        fs.delete(tmpDir, true);
                    }
                    if (this.configFile != null && this.configFile.exists() && this.configFile.delete()) {
                        this.configFile = null;
                    }
                    break block9;
                }
                FileUtils.deleteDirectory((File)new File(this.hdfsBaseDirectory.replace("file:", "").replace("/C:", "")));
            }
            catch (IOException e) {
                LOGGER.error("Unable to delete HDFS temp directory", (Throwable)e);
            }
        }
    }

    public String getJobtracker() {
        return this.jobtracker;
    }

    public void setJobtracker(String jobtracker) {
        this.jobtracker = jobtracker;
    }

    public String getHdfs() {
        return this.hdfs;
    }

    public void setHdfs(String hdfs) {
        this.hdfs = hdfs;
    }

    public boolean isHdfsProtocol() {
        return this.hdfsProtocol;
    }

    public void setHdfsProtocol(boolean hdfsProtocol) {
        this.hdfsProtocol = hdfsProtocol;
    }

    public String getHdfsBaseDirectory() {
        return this.hdfsBaseDirectory;
    }

    public void setHdfsBaseDirectory(String hdfsBaseDirectory) {
        this.hdfsBaseDirectory = hdfsBaseDirectory;
    }

    public ManualOperationParams getOperationParams() {
        return this.operationParams;
    }

    @Override
    public TestEnvironment[] getDependentEnvironments() {
        return new TestEnvironment[0];
    }
}

