/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test;

import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.util.FileUtils;
import org.locationtech.geowave.core.store.GenericStoreFactory;
import org.locationtech.geowave.core.store.StoreFactoryOptions;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.datastore.cassandra.CassandraStoreFactoryFamily;
import org.locationtech.geowave.datastore.cassandra.cli.CassandraServer;
import org.locationtech.geowave.datastore.cassandra.config.CassandraOptions;
import org.locationtech.geowave.datastore.cassandra.config.CassandraRequiredOptions;
import org.locationtech.geowave.test.StoreTestEnvironment;
import org.locationtech.geowave.test.TestEnvironment;
import org.locationtech.geowave.test.annotation.GeoWaveTestStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraStoreTestEnvironment
extends StoreTestEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraStoreTestEnvironment.class);
    private static final GenericStoreFactory<DataStore> STORE_FACTORY = new CassandraStoreFactoryFamily().getDataStoreFactory();
    private static CassandraStoreTestEnvironment singletonInstance = null;
    protected static final File TEMP_DIR = new File(System.getProperty("user.dir") + File.separator + "target", "cassandra_temp");
    protected static final String NODE_DIRECTORY_PREFIX = "cassandra";
    private static final boolean CLUSTERED_MODE = false;
    private boolean running = false;

    public static synchronized CassandraStoreTestEnvironment getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new CassandraStoreTestEnvironment();
        }
        return singletonInstance;
    }

    private CassandraStoreTestEnvironment() {
    }

    @Override
    protected void initOptions(StoreFactoryOptions options) {
        CassandraRequiredOptions cassandraOpts = (CassandraRequiredOptions)options;
        cassandraOpts.setContactPoint("127.0.0.1");
        ((CassandraOptions)cassandraOpts.getStoreOptions()).setBatchWriteSize(5);
    }

    @Override
    protected GenericStoreFactory<DataStore> getDataStoreFactory() {
        return STORE_FACTORY;
    }

    @Override
    public void setup() {
        if (!this.running) {
            if (TEMP_DIR.exists()) {
                CassandraStoreTestEnvironment.cleanTempDir();
            }
            if (!TEMP_DIR.mkdirs()) {
                LOGGER.warn("Unable to create temporary cassandra directory");
            }
            new CassandraServer(1, 512, TEMP_DIR.getAbsolutePath()).start();
            this.running = true;
        }
    }

    @Override
    public void tearDown() {
        if (this.running) {
            new CassandraServer(1, 512, TEMP_DIR.getAbsolutePath()).stop();
            this.running = false;
        }
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Unable to sleep waiting to delete directory", (Throwable)e);
        }
        CassandraStoreTestEnvironment.cleanTempDir();
    }

    private static void cleanTempDir() {
        try {
            FileUtils.deleteDirectory((File)TEMP_DIR);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to delete temp cassandra directory", (Throwable)e);
        }
    }

    @Override
    protected GeoWaveTestStore.GeoWaveStoreType getStoreType() {
        return GeoWaveTestStore.GeoWaveStoreType.CASSANDRA;
    }

    @Override
    public TestEnvironment[] getDependentEnvironments() {
        return new TestEnvironment[0];
    }
}

