/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test;

import org.apache.log4j.Logger;
import org.locationtech.geowave.core.store.GenericStoreFactory;
import org.locationtech.geowave.core.store.StoreFactoryOptions;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.datastore.dynamodb.DynamoDBStoreFactoryFamily;
import org.locationtech.geowave.datastore.dynamodb.cli.DynamoDBLocal;
import org.locationtech.geowave.datastore.dynamodb.config.DynamoDBOptions;
import org.locationtech.geowave.test.StoreTestEnvironment;
import org.locationtech.geowave.test.TestEnvironment;
import org.locationtech.geowave.test.annotation.GeoWaveTestStore;

public class DynamoDBStoreTestEnvironment
extends StoreTestEnvironment {
    private static final GenericStoreFactory<DataStore> STORE_FACTORY = new DynamoDBStoreFactoryFamily().getDataStoreFactory();
    private static DynamoDBStoreTestEnvironment singletonInstance = null;
    private static final Logger LOGGER = Logger.getLogger(DynamoDBStoreTestEnvironment.class);
    protected DynamoDBLocal dynamoLocal;

    public static synchronized DynamoDBStoreTestEnvironment getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new DynamoDBStoreTestEnvironment();
        }
        return singletonInstance;
    }

    private DynamoDBStoreTestEnvironment() {
    }

    @Override
    public void setup() {
        if (this.dynamoLocal == null) {
            this.dynamoLocal = new DynamoDBLocal(null);
        }
        if (this.dynamoLocal.isRunning()) {
            this.dynamoLocal.stop();
        }
        if (!this.dynamoLocal.start()) {
            LOGGER.error((Object)"DynamoDB emulator startup failed");
        }
    }

    @Override
    public void tearDown() {
        this.dynamoLocal.stop();
    }

    @Override
    protected GenericStoreFactory<DataStore> getDataStoreFactory() {
        return STORE_FACTORY;
    }

    @Override
    protected GeoWaveTestStore.GeoWaveStoreType getStoreType() {
        return GeoWaveTestStore.GeoWaveStoreType.DYNAMODB;
    }

    @Override
    protected void initOptions(StoreFactoryOptions options) {
        ((DynamoDBOptions)options).setEndpoint("http://localhost:8000");
    }

    @Override
    public TestEnvironment[] getDependentEnvironments() {
        return new TestEnvironment[0];
    }
}

