/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test.services.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.util.Timestamps;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.NameResolver;
import io.grpc.internal.DnsNameResolverProvider;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.service.grpc.protobuf.AnalyticMapreduceGrpc;
import org.locationtech.geowave.service.grpc.protobuf.AnalyticSparkGrpc;
import org.locationtech.geowave.service.grpc.protobuf.CQLQueryParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.CalculateStatCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.ClearStoreCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.CliGeoserverGrpc;
import org.locationtech.geowave.service.grpc.protobuf.ConfigGeoServerCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.ConfigHDFSCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.CoreCliGrpc;
import org.locationtech.geowave.service.grpc.protobuf.CoreIngestGrpc;
import org.locationtech.geowave.service.grpc.protobuf.CoreMapreduceGrpc;
import org.locationtech.geowave.service.grpc.protobuf.CoreStoreGrpc;
import org.locationtech.geowave.service.grpc.protobuf.DBScanCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.DescribeTypeCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.FeatureAttributeProtos;
import org.locationtech.geowave.service.grpc.protobuf.FeatureProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerAddCoverageCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerAddCoverageStoreCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerAddDatastoreCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerAddFeatureLayerCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerAddLayerCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerAddStyleCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerAddWorkspaceCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerGetCoverageCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerGetCoverageStoreCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerGetDatastoreCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerGetFeatureLayerCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerGetStoreAdapterCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerGetStyleCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerListCoverageStoresCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerListCoveragesCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerListDatastoresCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerListFeatureLayersCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerListStylesCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerListWorkspacesCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerRemoveCoverageCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerRemoveCoverageStoreCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerRemoveDatastoreCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerRemoveFeatureLayerCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerRemoveStyleCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerRemoveWorkspaceCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoServerSetLayerStyleCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.GeoWaveReturnTypesProtos;
import org.locationtech.geowave.service.grpc.protobuf.KafkaToGeowaveCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.KdeCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.KmeansSparkCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.ListCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.ListIndexPluginsCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.ListIndicesCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.ListIngestPluginsCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.ListStatsCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.ListStorePluginsCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.ListTypesCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.LocalToGeowaveCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.LocalToHdfsCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.LocalToKafkaCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.LocalToMapReduceToGeowaveCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.MapReduceToGeowaveCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.NearestNeighborCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.RecalculateStatsCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.RemoveIndexCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.RemoveStatCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.RemoveStoreCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.RemoveTypeCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.SetCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.SparkSqlCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.SparkToGeowaveCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.SpatialJoinCommandParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.SpatialQueryParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.SpatialTemporalQueryParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.TemporalConstraintsProtos;
import org.locationtech.geowave.service.grpc.protobuf.VectorGrpc;
import org.locationtech.geowave.service.grpc.protobuf.VectorIngestParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.VectorQueryParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.VectorStoreParametersProtos;
import org.locationtech.geowave.service.grpc.protobuf.VersionCommandParametersProtos;
import org.locationtech.geowave.test.services.grpc.GeoWaveGrpcTestUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoWaveGrpcTestClient {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)GeoWaveGrpcTestClient.class.getName());
    public final ManagedChannel channel;
    public final VectorGrpc.VectorBlockingStub vectorBlockingStub;
    public final VectorGrpc.VectorStub vectorAsyncStub;
    public final CoreCliGrpc.CoreCliBlockingStub coreCliBlockingStub;
    public final CoreMapreduceGrpc.CoreMapreduceBlockingStub coreMapreduceBlockingStub;
    public final AnalyticMapreduceGrpc.AnalyticMapreduceBlockingStub analyticMapreduceBlockingStub;
    public final AnalyticSparkGrpc.AnalyticSparkBlockingStub analyticSparkBlockingStub;
    public final CoreStoreGrpc.CoreStoreBlockingStub coreStoreBlockingStub;
    public final CoreIngestGrpc.CoreIngestBlockingStub coreIngestBlockingStub;
    public final CliGeoserverGrpc.CliGeoserverBlockingStub cliGeoserverBlockingStub;
    public int numFeaturesProcessed = 0;

    public GeoWaveGrpcTestClient(String host, int port) {
        this(((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)host, (int)port).nameResolverFactory((NameResolver.Factory)new DnsNameResolverProvider())).usePlaintext(true));
    }

    public GeoWaveGrpcTestClient(NettyChannelBuilder channelBuilder) {
        this.channel = channelBuilder.build();
        this.vectorBlockingStub = VectorGrpc.newBlockingStub((Channel)this.channel);
        this.vectorAsyncStub = VectorGrpc.newStub((Channel)this.channel);
        this.coreCliBlockingStub = CoreCliGrpc.newBlockingStub((Channel)this.channel);
        this.coreMapreduceBlockingStub = CoreMapreduceGrpc.newBlockingStub((Channel)this.channel);
        this.analyticMapreduceBlockingStub = AnalyticMapreduceGrpc.newBlockingStub((Channel)this.channel);
        this.coreStoreBlockingStub = CoreStoreGrpc.newBlockingStub((Channel)this.channel);
        this.coreIngestBlockingStub = CoreIngestGrpc.newBlockingStub((Channel)this.channel);
        this.cliGeoserverBlockingStub = CliGeoserverGrpc.newBlockingStub((Channel)this.channel);
        this.analyticSparkBlockingStub = AnalyticSparkGrpc.newBlockingStub((Channel)this.channel);
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    public void setCommand(String key, String val) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(key);
        params.add(val);
        SetCommandParametersProtos request = SetCommandParametersProtos.newBuilder().addAllParameters(params).build();
        this.coreCliBlockingStub.setCommand(request);
    }

    public Map<String, String> listCommand() {
        ListCommandParametersProtos request = ListCommandParametersProtos.newBuilder().build();
        GeoWaveReturnTypesProtos.MapStringStringResponseProtos response = this.coreCliBlockingStub.listCommand(request);
        Map map = response.getResponseValueMap();
        return map;
    }

    public void vectorIngest(int minLat, int maxLat, int minLon, int maxLon, int latStepDegs, int lonStepDegs) throws InterruptedException, UnsupportedEncodingException, ParseException {
        LOGGER.info("Performing Vector Ingest...");
        VectorStoreParametersProtos baseParams = VectorStoreParametersProtos.newBuilder().setStoreName("grpc").setTypeName("TestGeometry").setIndexName("grpcspatial").build();
        final CountDownLatch finishLatch = new CountDownLatch(1);
        StreamObserver<GeoWaveReturnTypesProtos.StringResponseProtos> responseObserver = new StreamObserver<GeoWaveReturnTypesProtos.StringResponseProtos>(){

            public void onNext(GeoWaveReturnTypesProtos.StringResponseProtos value) {
                try {
                    GeoWaveGrpcTestClient.this.numFeaturesProcessed = Integer.parseInt(value.getResponseValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                LOGGER.info(value.getResponseValue());
            }

            public void onError(Throwable t) {
                LOGGER.error("Error: Vector Ingest failed.", t);
                finishLatch.countDown();
            }

            public void onCompleted() {
                LOGGER.info("Finished Vector Ingest...");
                finishLatch.countDown();
            }
        };
        StreamObserver requestObserver = this.vectorAsyncStub.vectorIngest((StreamObserver)responseObserver);
        VectorIngestParametersProtos.Builder requestBuilder = VectorIngestParametersProtos.newBuilder();
        FeatureAttributeProtos.Builder attBuilder = FeatureAttributeProtos.newBuilder();
        for (int longitude = minLon; longitude <= maxLon; longitude += lonStepDegs) {
            for (int latitude = minLat; latitude <= maxLat; latitude += latStepDegs) {
                attBuilder.setValGeometry(GeoWaveGrpcTestClient.copyFrom(new WKBWriter().write((Geometry)GeometryUtils.GEOMETRY_FACTORY.createPoint(new Coordinate((double)longitude, (double)latitude)))));
                requestBuilder.putFeature("geometry", attBuilder.build());
                TimeZone tz = TimeZone.getTimeZone("UTC");
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
                df.setTimeZone(tz);
                attBuilder.setValDate(Timestamps.fromMillis((long)((df.parse("2016-02-20T01:32Z").getTime() + df.parse("2016-02-21T01:32Z").getTime()) / 2L)));
                requestBuilder.putFeature("TimeStamp", attBuilder.build());
                attBuilder.setValDouble((double)latitude);
                requestBuilder.putFeature("Latitude", attBuilder.build());
                attBuilder.setValDouble((double)longitude);
                requestBuilder.putFeature("Longitude", attBuilder.build());
                VectorIngestParametersProtos params = requestBuilder.setBaseParams(baseParams).build();
                requestObserver.onNext((Object)params);
                if (finishLatch.getCount() != 0L) continue;
                return;
            }
        }
        requestObserver.onCompleted();
        if (!finishLatch.await(15L, TimeUnit.MINUTES)) {
            LOGGER.warn("Vector Ingest can not finish within 5 minutes");
        }
    }

    public ArrayList<FeatureProtos> vectorQuery() throws UnsupportedEncodingException {
        LOGGER.info("Performing Vector Query...");
        VectorQueryParametersProtos request = VectorQueryParametersProtos.newBuilder().setStoreName("grpc").setTypeName("TestGeometry").setQuery("BBOX(geometry,0.0,0.0, 25.0, 25.0)").build();
        Iterator features = this.vectorBlockingStub.vectorQuery(request);
        ArrayList<FeatureProtos> feature_list = new ArrayList<FeatureProtos>();
        int i = 1;
        while (features.hasNext()) {
            FeatureProtos feature = (FeatureProtos)features.next();
            feature_list.add(feature);
            ++i;
        }
        return feature_list;
    }

    private static ByteString copyFrom(byte[] bytes) {
        return ByteString.copyFrom((byte[])bytes);
    }

    public ArrayList<FeatureProtos> cqlQuery() throws UnsupportedEncodingException {
        LOGGER.info("Performing CQL Query...");
        VectorStoreParametersProtos baseParams = VectorStoreParametersProtos.newBuilder().setStoreName("grpc").setTypeName("TestGeometry").setIndexName("grpcspatial").build();
        CQLQueryParametersProtos request = CQLQueryParametersProtos.newBuilder().setBaseParams(baseParams).setCql("BBOX(geometry,0.0,0.0, 25.0, 25.0)").build();
        ArrayList<FeatureProtos> feature_list = new ArrayList<FeatureProtos>();
        Iterator features = this.vectorBlockingStub.cqlQuery(request);
        int i = 1;
        while (features.hasNext()) {
            FeatureProtos feature = (FeatureProtos)features.next();
            feature_list.add(feature);
            ++i;
        }
        return feature_list;
    }

    public ArrayList<FeatureProtos> spatialQuery() throws UnsupportedEncodingException {
        LOGGER.info("Performing Spatial Query...");
        VectorStoreParametersProtos baseParams = VectorStoreParametersProtos.newBuilder().setStoreName("grpc").setTypeName("TestGeometry").setIndexName("grpcspatial").build();
        SpatialQueryParametersProtos request = SpatialQueryParametersProtos.newBuilder().setBaseParams(baseParams).setGeometry(GeoWaveGrpcTestClient.copyFrom(GeoWaveGrpcTestUtils.wkbSpatialQuery)).build();
        ArrayList<FeatureProtos> feature_list = new ArrayList<FeatureProtos>();
        Iterator features = this.vectorBlockingStub.spatialQuery(request);
        int i = 1;
        while (features.hasNext()) {
            FeatureProtos feature = (FeatureProtos)features.next();
            feature_list.add(feature);
            ++i;
        }
        return feature_list;
    }

    public ArrayList<FeatureProtos> spatialTemporalQuery() throws ParseException {
        LOGGER.info("Performing Spatial Temporal Query...");
        VectorStoreParametersProtos baseParams = VectorStoreParametersProtos.newBuilder().setStoreName("grpc").build();
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        df.setTimeZone(tz);
        SpatialQueryParametersProtos spatialQuery = SpatialQueryParametersProtos.newBuilder().setBaseParams(baseParams).setGeometry(GeoWaveGrpcTestClient.copyFrom(GeoWaveGrpcTestUtils.wkbSpatialQuery)).build();
        TemporalConstraintsProtos t = TemporalConstraintsProtos.newBuilder().setStartTime(Timestamps.fromMillis((long)df.parse("2016-02-20T01:32Z").getTime())).setEndTime(Timestamps.fromMillis((long)df.parse("2016-02-21T01:32Z").getTime())).build();
        SpatialTemporalQueryParametersProtos request = SpatialTemporalQueryParametersProtos.newBuilder().setSpatialParams(spatialQuery).addTemporalConstraints(0, t).setCompareOperation("CONTAINS").build();
        ArrayList<FeatureProtos> feature_list = new ArrayList<FeatureProtos>();
        Iterator features = this.vectorBlockingStub.spatialTemporalQuery(request);
        while (features.hasNext()) {
            FeatureProtos feature = (FeatureProtos)features.next();
            feature_list.add(feature);
        }
        return feature_list;
    }

    public boolean configHDFSCommand() {
        ConfigHDFSCommandParametersProtos request = ConfigHDFSCommandParametersProtos.newBuilder().addParameters(GeoWaveGrpcTestUtils.getMapReduceTestEnv().getHdfs()).build();
        this.coreMapreduceBlockingStub.configHDFSCommand(request);
        return true;
    }

    public boolean dbScanCommand() {
        ArrayList<String> types = new ArrayList<String>();
        types.add("TestGeometry");
        DBScanCommandParametersProtos request = DBScanCommandParametersProtos.newBuilder().addParameters("grpc").setClusteringMaxIterations("5").setClusteringMinimumSize("10").setExtractMinInputSplit("2").setExtractMaxInputSplit("6").setPartitionMaxDistance("1000").setOutputReducerCount("4").setMapReduceHdfsHostPort(GeoWaveGrpcTestUtils.getMapReduceTestEnv().getHdfs()).setMapReduceJobtrackerHostPort(GeoWaveGrpcTestUtils.getMapReduceTestEnv().getJobtracker()).setMapReduceHdfsBaseDir(GeoWaveGrpcTestUtils.getMapReduceTestEnv().getHdfsBaseDirectory()).addAllTypeNames(types).build();
        this.analyticMapreduceBlockingStub.dBScanCommand(request);
        return true;
    }

    public boolean nearestNeighborCommand() {
        ArrayList<String> types = new ArrayList<String>();
        types.add("TestGeometry");
        NearestNeighborCommandParametersProtos request = NearestNeighborCommandParametersProtos.newBuilder().addParameters("grpc").addAllTypeNames(types).setExtractQuery("POLYGON (( 0.0 0.0, 0.0 25.0, 25.0 25.0, 25.0 0.0, 0.0 0.0))").setExtractMinInputSplit("2").setExtractMaxInputSplit("6").setPartitionMaxDistance("10").setOutputReducerCount("4").setMapReduceHdfsHostPort(GeoWaveGrpcTestUtils.getMapReduceTestEnv().getHdfs()).setMapReduceJobtrackerHostPort(GeoWaveGrpcTestUtils.getMapReduceTestEnv().getJobtracker()).setOutputHdfsOutputPath(GeoWaveGrpcTestUtils.getMapReduceTestEnv().getHdfsBaseDirectory() + "/GrpcNearestNeighbor").setMapReduceHdfsBaseDir(GeoWaveGrpcTestUtils.getMapReduceTestEnv().getHdfsBaseDirectory()).build();
        this.analyticMapreduceBlockingStub.nearestNeighborCommand(request);
        return true;
    }

    public boolean kdeCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        params.add("grpc-output");
        KdeCommandParametersProtos request = KdeCommandParametersProtos.newBuilder().addAllParameters(params).setCoverageName("grpc_kde").setFeatureType("TestGeometry").setHdfsHostPort(GeoWaveGrpcTestUtils.getMapReduceTestEnv().getHdfs()).setJobTrackerOrResourceManHostPort(GeoWaveGrpcTestUtils.getMapReduceTestEnv().getJobtracker()).setMinLevel(5).setMaxLevel(26).setMinSplits(32).setMaxSplits(32).setTileSize(1).build();
        this.analyticMapreduceBlockingStub.kdeCommand(request);
        return true;
    }

    public boolean RecalculateStatsCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        RecalculateStatsCommandParametersProtos request = RecalculateStatsCommandParametersProtos.newBuilder().addAllParameters(params).setJsonFormatFlag(true).build();
        this.coreStoreBlockingStub.recalculateStatsCommand(request);
        return true;
    }

    public String RemoveIndexCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        params.add("grpcspatial");
        RemoveIndexCommandParametersProtos request = RemoveIndexCommandParametersProtos.newBuilder().addAllParameters(params).build();
        GeoWaveReturnTypesProtos.StringResponseProtos resp = this.coreStoreBlockingStub.removeIndexCommand(request);
        return resp.getResponseValue();
    }

    public boolean VersionCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        VersionCommandParametersProtos request = VersionCommandParametersProtos.newBuilder().addAllParameters(params).build();
        this.coreStoreBlockingStub.versionCommand(request);
        return true;
    }

    public String ListIndexCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        ListIndicesCommandParametersProtos request = ListIndicesCommandParametersProtos.newBuilder().addAllParameters(params).build();
        GeoWaveReturnTypesProtos.StringResponseProtos resp = this.coreStoreBlockingStub.listIndicesCommand(request);
        return resp.getResponseValue();
    }

    public String ListStatsCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        ListStatsCommandParametersProtos request = ListStatsCommandParametersProtos.newBuilder().addAllParameters(params).build();
        GeoWaveReturnTypesProtos.StringResponseProtos resp = this.coreStoreBlockingStub.listStatsCommand(request);
        return resp.getResponseValue();
    }

    public boolean ClearCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        ClearStoreCommandParametersProtos request = ClearStoreCommandParametersProtos.newBuilder().addAllParameters(params).build();
        this.coreStoreBlockingStub.clearStoreCommand(request);
        return true;
    }

    public String ListAdapterCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        ListTypesCommandParametersProtos request = ListTypesCommandParametersProtos.newBuilder().addAllParameters(params).build();
        GeoWaveReturnTypesProtos.StringResponseProtos resp = this.coreStoreBlockingStub.listTypesCommand(request);
        return resp.getResponseValue();
    }

    public boolean DescribeAdapterCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        params.add("TestGeometry");
        DescribeTypeCommandParametersProtos request = DescribeTypeCommandParametersProtos.newBuilder().addAllParameters(params).build();
        this.coreStoreBlockingStub.describeTypeCommand(request);
        return true;
    }

    public String RemoveStoreCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        RemoveStoreCommandParametersProtos request = RemoveStoreCommandParametersProtos.newBuilder().addAllParameters(params).build();
        GeoWaveReturnTypesProtos.StringResponseProtos resp = this.coreStoreBlockingStub.removeStoreCommand(request);
        return resp.getResponseValue();
    }

    public boolean RemoveAdapterCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        params.add("TestGeometry");
        RemoveTypeCommandParametersProtos request = RemoveTypeCommandParametersProtos.newBuilder().addAllParameters(params).build();
        this.coreStoreBlockingStub.removeTypeCommand(request);
        return true;
    }

    public boolean RemoveStatCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        params.add("TestGeometry");
        params.add("BOUNDING_BOX");
        RemoveStatCommandParametersProtos request = RemoveStatCommandParametersProtos.newBuilder().addAllParameters(params).setFieldName("geometry").build();
        this.coreStoreBlockingStub.removeStatCommand(request);
        return true;
    }

    public boolean CalculateStatCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        params.add("TestGeometry");
        params.add("BOUNDING_BOX");
        CalculateStatCommandParametersProtos request = CalculateStatCommandParametersProtos.newBuilder().addAllParameters(params).setFieldName("geometry").build();
        this.coreStoreBlockingStub.calculateStatCommand(request);
        return true;
    }

    public String GeoServerAddLayerCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        GeoServerAddLayerCommandParametersProtos request = GeoServerAddLayerCommandParametersProtos.newBuilder().addAllParameters(params).setAdapterId("GeometryTest").setAddOption("VECTOR").setStyle("default").setWorkspace("default").build();
        return this.cliGeoserverBlockingStub.geoServerAddLayerCommand(request).getResponseValue();
    }

    public String GeoServerGetDatastoreCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        GeoServerGetDatastoreCommandParametersProtos request = GeoServerGetDatastoreCommandParametersProtos.newBuilder().addAllParameters(params).setWorkspace("default").build();
        return this.cliGeoserverBlockingStub.geoServerGetDatastoreCommand(request).getResponseValue();
    }

    public String GeoServerGetFeatureProtosLayerCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        GeoServerGetFeatureLayerCommandParametersProtos request = GeoServerGetFeatureLayerCommandParametersProtos.newBuilder().addAllParameters(params).build();
        return this.cliGeoserverBlockingStub.geoServerGetFeatureLayerCommand(request).getResponseValue();
    }

    public String GeoServerListCoverageStoresCommand() {
        GeoServerListCoverageStoresCommandParametersProtos request = GeoServerListCoverageStoresCommandParametersProtos.newBuilder().setWorkspace("default").build();
        return this.cliGeoserverBlockingStub.geoServerListCoverageStoresCommand(request).getResponseValue();
    }

    public List<String> GeoServerGetStoreAdapterCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        GeoServerGetStoreAdapterCommandParametersProtos request = GeoServerGetStoreAdapterCommandParametersProtos.newBuilder().addAllParameters(params).build();
        return this.cliGeoserverBlockingStub.geoServerGetStoreAdapterCommand(request).getResponseValueList();
    }

    public String GeoServerGetCoverageCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        GeoServerGetCoverageCommandParametersProtos request = GeoServerGetCoverageCommandParametersProtos.newBuilder().addAllParameters(params).setWorkspace("default").setCvgstore("test_cvg_store").build();
        return this.cliGeoserverBlockingStub.geoServerGetCoverageCommand(request).getResponseValue();
    }

    public String GeoServerRemoveFeatureProtosLayerCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        GeoServerRemoveFeatureLayerCommandParametersProtos request = GeoServerRemoveFeatureLayerCommandParametersProtos.newBuilder().addAllParameters(params).build();
        return this.cliGeoserverBlockingStub.geoServerRemoveFeatureLayerCommand(request).getResponseValue();
    }

    public String GeoServerAddCoverageCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        GeoServerAddCoverageCommandParametersProtos request = GeoServerAddCoverageCommandParametersProtos.newBuilder().addAllParameters(params).setWorkspace("default").setCvgstore("test_cvg_store").build();
        return this.cliGeoserverBlockingStub.geoServerAddCoverageCommand(request).getResponseValue();
    }

    public String GeoServerRemoveWorkspaceCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        GeoServerRemoveWorkspaceCommandParametersProtos request = GeoServerRemoveWorkspaceCommandParametersProtos.newBuilder().addAllParameters(params).build();
        return this.cliGeoserverBlockingStub.geoServerRemoveWorkspaceCommand(request).getResponseValue();
    }

    public List<String> GeoServerListWorkspacesCommand() {
        GeoServerListWorkspacesCommandParametersProtos request = GeoServerListWorkspacesCommandParametersProtos.newBuilder().build();
        return this.cliGeoserverBlockingStub.geoServerListWorkspacesCommand(request).getResponseValueList();
    }

    public String GeoServerGetCoverageStoreCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        GeoServerGetCoverageStoreCommandParametersProtos request = GeoServerGetCoverageStoreCommandParametersProtos.newBuilder().addAllParameters(params).setWorkspace("default").build();
        return this.cliGeoserverBlockingStub.geoServerGetCoverageStoreCommand(request).getResponseValue();
    }

    public String ConfigGeoServerCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        ConfigGeoServerCommandParametersProtos request = ConfigGeoServerCommandParametersProtos.newBuilder().addAllParameters(params).setWorkspace("default").setUsername("user").setPass("default").build();
        return this.cliGeoserverBlockingStub.configGeoServerCommand(request).getResponseValue();
    }

    public String GeoServerListCoveragesCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        GeoServerListCoveragesCommandParametersProtos request = GeoServerListCoveragesCommandParametersProtos.newBuilder().addAllParameters(params).setWorkspace("default").build();
        return this.cliGeoserverBlockingStub.geoServerListCoveragesCommand(request).getResponseValue();
    }

    public String GeoServerListStylesCommand() {
        GeoServerListStylesCommandParametersProtos request = GeoServerListStylesCommandParametersProtos.newBuilder().build();
        return this.cliGeoserverBlockingStub.geoServerListStylesCommand(request).getResponseValue();
    }

    public String GeoServerAddCoverageStoreCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        GeoServerAddCoverageStoreCommandParametersProtos request = GeoServerAddCoverageStoreCommandParametersProtos.newBuilder().addAllParameters(params).setWorkspace("default").setCoverageStore("coverage-store").setEqualizeHistogramOverride(false).setScaleTo8Bit(false).setInterpolationOverride("0").build();
        return this.cliGeoserverBlockingStub.geoServerAddCoverageStoreCommand(request).getResponseValue();
    }

    public String GeoServerAddFeatureProtosLayerCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        GeoServerAddFeatureLayerCommandParametersProtos request = GeoServerAddFeatureLayerCommandParametersProtos.newBuilder().addAllParameters(params).setWorkspace("default").setDatastore("grpc").build();
        return this.cliGeoserverBlockingStub.geoServerAddFeatureLayerCommand(request).getResponseValue();
    }

    public String GeoServerAddDatastoreCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        GeoServerAddDatastoreCommandParametersProtos request = GeoServerAddDatastoreCommandParametersProtos.newBuilder().addAllParameters(params).setWorkspace("default").setDatastore("grpc-store").build();
        return this.cliGeoserverBlockingStub.geoServerAddDatastoreCommand(request).getResponseValue();
    }

    public String GeoServerListDatastoresCommand() {
        GeoServerListDatastoresCommandParametersProtos request = GeoServerListDatastoresCommandParametersProtos.newBuilder().setWorkspace("default").build();
        return this.cliGeoserverBlockingStub.geoServerListDatastoresCommand(request).getResponseValue();
    }

    public String GeoServerSetLayerStyleCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        GeoServerSetLayerStyleCommandParametersProtos request = GeoServerSetLayerStyleCommandParametersProtos.newBuilder().addAllParameters(params).setStyleName("test-style").build();
        return this.cliGeoserverBlockingStub.geoServerSetLayerStyleCommand(request).getResponseValue();
    }

    public String GeoServerRemoveCoverageStoreCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        GeoServerRemoveCoverageStoreCommandParametersProtos request = GeoServerRemoveCoverageStoreCommandParametersProtos.newBuilder().addAllParameters(params).setWorkspace("default").build();
        return this.cliGeoserverBlockingStub.geoServerRemoveCoverageStoreCommand(request).getResponseValue();
    }

    public String GeoServerRemoveDatastoreCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        GeoServerRemoveDatastoreCommandParametersProtos request = GeoServerRemoveDatastoreCommandParametersProtos.newBuilder().addAllParameters(params).setWorkspace("default").build();
        return this.cliGeoserverBlockingStub.geoServerRemoveDatastoreCommand(request).getResponseValue();
    }

    public String GeoServerAddStyleCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        GeoServerAddStyleCommandParametersProtos request = GeoServerAddStyleCommandParametersProtos.newBuilder().addAllParameters(params).setStylesld("styles-id").build();
        return this.cliGeoserverBlockingStub.geoServerAddStyleCommand(request).getResponseValue();
    }

    public String GeoServerAddWorkspaceCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        GeoServerAddWorkspaceCommandParametersProtos request = GeoServerAddWorkspaceCommandParametersProtos.newBuilder().addAllParameters(params).build();
        return this.cliGeoserverBlockingStub.geoServerAddWorkspaceCommand(request).getResponseValue();
    }

    public String GeoServerGetStyleCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        GeoServerGetStyleCommandParametersProtos request = GeoServerGetStyleCommandParametersProtos.newBuilder().addAllParameters(params).build();
        return this.cliGeoserverBlockingStub.geoServerGetStyleCommand(request).getResponseValue();
    }

    public String GeoServerRemoveStyleCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        GeoServerRemoveStyleCommandParametersProtos request = GeoServerRemoveStyleCommandParametersProtos.newBuilder().addAllParameters(params).build();
        return this.cliGeoserverBlockingStub.geoServerRemoveStyleCommand(request).getResponseValue();
    }

    public String GeoServerRemoveCoverageCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        GeoServerRemoveCoverageCommandParametersProtos request = GeoServerRemoveCoverageCommandParametersProtos.newBuilder().addAllParameters(params).setWorkspace("default").setCvgstore("cvg-store").build();
        return this.cliGeoserverBlockingStub.geoServerRemoveCoverageCommand(request).getResponseValue();
    }

    public String GeoServerListFeatureProtosLayersCommand() {
        GeoServerListFeatureLayersCommandParametersProtos request = GeoServerListFeatureLayersCommandParametersProtos.newBuilder().setWorkspace("default").setDatastore("cvg-store").setGeowaveOnly(true).build();
        return this.cliGeoserverBlockingStub.geoServerListFeatureLayersCommand(request).getResponseValue();
    }

    public boolean LocalToHdfsCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("data/osm_gpx_test_case/");
        params.add(GeoWaveGrpcTestUtils.getMapReduceTestEnv().getHdfsBaseDirectory());
        ArrayList extensions = new ArrayList();
        LocalToHdfsCommandParametersProtos request = LocalToHdfsCommandParametersProtos.newBuilder().addAllParameters(params).addAllExtensions(extensions).setFormats("gpx").build();
        this.coreIngestBlockingStub.localToHdfsCommand(request);
        return true;
    }

    public boolean LocalToGeoWaveCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("data/osm_gpx_test_case/");
        params.add("grpc");
        params.add("grpcspatial");
        ArrayList extensions = new ArrayList();
        LocalToGeowaveCommandParametersProtos request = LocalToGeowaveCommandParametersProtos.newBuilder().addAllParameters(params).addAllExtensions(extensions).setFormats("gpx").setThreads(1).build();
        this.coreIngestBlockingStub.localToGeowaveCommand(request);
        return true;
    }

    public boolean MapReduceToGeoWaveCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add(GeoWaveGrpcTestUtils.getMapReduceTestEnv().getHdfsBaseDirectory());
        params.add("grpc");
        params.add("grpcspatial");
        ArrayList extensions = new ArrayList();
        MapReduceToGeowaveCommandParametersProtos request = MapReduceToGeowaveCommandParametersProtos.newBuilder().addAllParameters(params).addAllExtensions(extensions).setFormats("gpx").setJobTrackerHostPort(GeoWaveGrpcTestUtils.getMapReduceTestEnv().getJobtracker()).build();
        this.coreIngestBlockingStub.mapReduceToGeowaveCommand(request);
        return true;
    }

    public boolean SparkToGeoWaveCommand() {
        ArrayList<String> params = new ArrayList<String>();
        File tempDataDir = new File("./data/");
        String hdfsPath = "";
        try {
            hdfsPath = tempDataDir.toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            return false;
        }
        params.add(hdfsPath + "osm_gpx_test_case/");
        params.add("grpc");
        params.add("grpcspatial");
        ArrayList extensions = new ArrayList();
        SparkToGeowaveCommandParametersProtos request = SparkToGeowaveCommandParametersProtos.newBuilder().addAllParameters(params).addAllExtensions(extensions).setFormats("gpx").setAppName("CoreGeoWaveSparkITs").setMaster("local[*]").setHost("localhost").setNumExecutors(1).setNumCores(1).build();
        this.coreIngestBlockingStub.sparkToGeowaveCommand(request);
        return true;
    }

    public boolean LocalToMapReduceToGeoWaveCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("data/osm_gpx_test_case/");
        params.add(GeoWaveGrpcTestUtils.getMapReduceTestEnv().getHdfsBaseDirectory());
        params.add("grpc");
        params.add("grpcspatial");
        ArrayList extensions = new ArrayList();
        LocalToMapReduceToGeowaveCommandParametersProtos request = LocalToMapReduceToGeowaveCommandParametersProtos.newBuilder().addAllParameters(params).addAllExtensions(extensions).setFormats("gpx").setJobTrackerHostPort(GeoWaveGrpcTestUtils.getMapReduceTestEnv().getJobtracker()).build();
        this.coreIngestBlockingStub.localToMapReduceToGeowaveCommand(request);
        return true;
    }

    public boolean KafkaToGeoWaveCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        params.add("grpcspatial");
        ArrayList extensions = new ArrayList();
        KafkaToGeowaveCommandParametersProtos request = KafkaToGeowaveCommandParametersProtos.newBuilder().addAllParameters(params).addAllExtensions(extensions).setFormats("gpx").setGroupId("testGroup").setZookeeperConnect(GeoWaveGrpcTestUtils.getZookeeperTestEnv().getZookeeper()).setAutoOffsetReset("smallest").setFetchMessageMaxBytes("5000000").setConsumerTimeoutMs("5000").setReconnectOnTimeout(false).setBatchSize(10000).build();
        this.coreIngestBlockingStub.kafkaToGeowaveCommand(request);
        return true;
    }

    public String ListIngestPluginsCommand() {
        ListIngestPluginsCommandParametersProtos request = ListIngestPluginsCommandParametersProtos.newBuilder().build();
        return this.coreIngestBlockingStub.listIngestPluginsCommand(request).getResponseValue();
    }

    public String ListIndexPluginsCommand() {
        ListIndexPluginsCommandParametersProtos request = ListIndexPluginsCommandParametersProtos.newBuilder().build();
        return this.coreStoreBlockingStub.listIndexPluginsCommand(request).getResponseValue();
    }

    public String ListStorePluginsCommand() {
        ListStorePluginsCommandParametersProtos request = ListStorePluginsCommandParametersProtos.newBuilder().build();
        return this.coreStoreBlockingStub.listStorePluginsCommand(request).getResponseValue();
    }

    public boolean LocalToKafkaCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("data/osm_gpx_test_case/");
        ArrayList extensions = new ArrayList();
        String localhost = "localhost";
        try {
            localhost = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("unable to get canonical hostname for localhost", (Throwable)e);
        }
        LocalToKafkaCommandParametersProtos request = LocalToKafkaCommandParametersProtos.newBuilder().addAllParameters(params).addAllExtensions(extensions).setFormats("gpx").setMetadataBrokerList(localhost + ":9092").setRequestRequiredAcks("1").setProducerType("sync").setSerializerClass("org.locationtech.geowave.core.ingest.kafka.AvroKafkaEncoder").setRetryBackoffMs("1000").build();
        this.coreIngestBlockingStub.localToKafkaCommand(request);
        return true;
    }

    public boolean KmeansSparkCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        params.add("grpc-output");
        KmeansSparkCommandParametersProtos request = KmeansSparkCommandParametersProtos.newBuilder().addAllParameters(params).setAppName("test-app").setHost("localhost").setMaster("local[*]").setTypeName("TestGeometry").setNumClusters(2).setNumIterations(2).setEpsilon(20.0).setUseTime(false).setGenerateHulls(true).setComputeHullData(true).setCqlFilter("BBOX(geometry,0.0,0.0, 25.0, 25.0)").setMinSplits(1).setMaxSplits(4).setCentroidTypeName("poly").setHullTypeName("poly-hull").build();
        this.analyticSparkBlockingStub.kmeansSparkCommand(request);
        return true;
    }

    public boolean SparkSqlCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("select * from %grpc|TestGeometry");
        SparkSqlCommandParametersProtos request = SparkSqlCommandParametersProtos.newBuilder().addAllParameters(params).setOutputStoreName("grpc-output").setMaster("local[*]").setAppName("sparkSqlTestApp").setHost("localhost").setOutputTypeName("TestGeometry").setShowResults(5).build();
        this.analyticSparkBlockingStub.sparkSqlCommand(request);
        return true;
    }

    public boolean SpatialJoinCommand() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("grpc");
        params.add("grpc");
        params.add("grpc-output");
        SpatialJoinCommandParametersProtos request = SpatialJoinCommandParametersProtos.newBuilder().addAllParameters(params).setAppName("test-app2").setMaster("local[*]").setHost("localhost").setLeftAdapterTypeName("TestGeometry").setRightAdapterTypeName("TestGeometry").setOutLeftAdapterTypeName("TestGeometry_l").setOutRightAdapterTypeName("TestGeometry_r").setPredicate("GeomIntersects").setRadius(0.1).setNegativeTest(false).build();
        this.analyticSparkBlockingStub.spatialJoinCommand(request);
        return true;
    }
}

