/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test;

import java.util.Iterator;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.locationtech.geowave.core.index.SPIServiceRegistry;
import org.locationtech.geowave.test.TestEnvironment;
import org.locationtech.geowave.test.TestUtils;
import org.locationtech.geowave.test.kerberos.KerberosTestingUtilSpi;

public class KerberosTestEnvironment
implements TestEnvironment {
    private static KerberosTestEnvironment singletonInstance = null;
    private static final String TEST_KERBEROS_ENVIRONMENT_VARIABLE_NAME = "TEST_KERBEROS";
    private static final String TEST_KERBEROS_PROPERTY_NAME = "testKerberos";
    private KerberosTestingUtilSpi util;

    public static synchronized KerberosTestEnvironment getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new KerberosTestEnvironment();
        }
        return singletonInstance;
    }

    private KerberosTestEnvironment() {
    }

    public boolean isRunning() {
        return this.util != null;
    }

    public static boolean useKerberos() {
        String kerberosStr = System.getenv(TEST_KERBEROS_ENVIRONMENT_VARIABLE_NAME);
        if (!TestUtils.isSet(kerberosStr)) {
            kerberosStr = System.getProperty(TEST_KERBEROS_PROPERTY_NAME);
        }
        return TestUtils.isSet(kerberosStr) && "true".equalsIgnoreCase(kerberosStr);
    }

    private KerberosTestingUtilSpi getUtil() {
        Iterator kerberosTestingUtilRegistry = new SPIServiceRegistry(KerberosTestEnvironment.class).load(KerberosTestingUtilSpi.class);
        while (kerberosTestingUtilRegistry.hasNext()) {
            KerberosTestingUtilSpi kereberosTestingUtil = (KerberosTestingUtilSpi)kerberosTestingUtilRegistry.next();
            if (kereberosTestingUtil == null) continue;
            return kereberosTestingUtil;
        }
        return null;
    }

    @Override
    public void setup() throws Exception {
        if (this.util == null) {
            this.util = this.getUtil();
            this.util.setup();
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.util.tearDown();
        this.util = null;
    }

    @Override
    public TestEnvironment[] getDependentEnvironments() {
        return new TestEnvironment[0];
    }

    public void configureMiniAccumulo(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
        if (this.util != null) {
            this.util.configureMiniAccumulo(cfg, coreSite);
        }
    }

    public ClusterUser getRootUser() {
        if (this.util != null) {
            return this.util.getRootUser();
        }
        return null;
    }
}

