/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test;

import org.locationtech.geowave.core.store.GenericStoreFactory;
import org.locationtech.geowave.core.store.StoreFactoryOptions;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.datastore.redis.RedisStoreFactoryFamily;
import org.locationtech.geowave.datastore.redis.config.RedisOptions;
import org.locationtech.geowave.test.StoreTestEnvironment;
import org.locationtech.geowave.test.TestEnvironment;
import org.locationtech.geowave.test.annotation.GeoWaveTestStore;
import redis.embedded.RedisServer;

public class RedisStoreTestEnvironment
extends StoreTestEnvironment {
    private static final GenericStoreFactory<DataStore> STORE_FACTORY = new RedisStoreFactoryFamily().getDataStoreFactory();
    private static RedisStoreTestEnvironment singletonInstance = null;
    private RedisServer redisServer;

    public static synchronized RedisStoreTestEnvironment getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new RedisStoreTestEnvironment();
        }
        return singletonInstance;
    }

    @Override
    public void setup() {
        if (this.redisServer == null) {
            this.redisServer = RedisServer.builder().port(Integer.valueOf(6379)).setting("bind 127.0.0.1").setting("maxmemory 512M").setting("timeout 30000").build();
            this.redisServer.start();
        }
    }

    @Override
    public void tearDown() {
        if (this.redisServer != null) {
            this.redisServer.stop();
            this.redisServer = null;
        }
    }

    @Override
    protected GenericStoreFactory<DataStore> getDataStoreFactory() {
        return STORE_FACTORY;
    }

    @Override
    protected GeoWaveTestStore.GeoWaveStoreType getStoreType() {
        return GeoWaveTestStore.GeoWaveStoreType.REDIS;
    }

    @Override
    protected void initOptions(StoreFactoryOptions options) {
        ((RedisOptions)options).setAddress("redis://127.0.0.1:6379");
    }

    @Override
    public TestEnvironment[] getDependentEnvironments() {
        return new TestEnvironment[0];
    }
}

