/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test;

import java.util.HashMap;
import org.locationtech.geowave.core.store.GenericStoreFactory;
import org.locationtech.geowave.core.store.StoreFactoryOptions;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.locationtech.geowave.core.store.config.ConfigUtils;
import org.locationtech.geowave.test.TestDataStoreOptions;
import org.locationtech.geowave.test.TestEnvironment;
import org.locationtech.geowave.test.annotation.GeoWaveTestStore;

public abstract class StoreTestEnvironment
implements TestEnvironment {
    protected abstract GenericStoreFactory<DataStore> getDataStoreFactory();

    protected abstract GeoWaveTestStore.GeoWaveStoreType getStoreType();

    protected abstract void initOptions(StoreFactoryOptions var1);

    public DataStorePluginOptions getDataStoreOptions(GeoWaveTestStore store, String[] profileOptions) {
        String[] kv;
        TestDataStoreOptions pluginOptions = new TestDataStoreOptions(this.getStoreType());
        GenericStoreFactory<DataStore> factory = this.getDataStoreFactory();
        StoreFactoryOptions opts = factory.createOptionsInstance();
        this.initOptions(opts);
        opts.setGeoWaveNamespace(store.namespace());
        HashMap<String, String> optionOverrides = new HashMap<String, String>();
        for (String optionOverride : store.options()) {
            if (!optionOverride.contains("=")) continue;
            kv = optionOverride.split("=");
            optionOverrides.put(kv[0], kv[1]);
        }
        if (profileOptions != null) {
            for (String optionOverride : profileOptions) {
                if (!optionOverride.contains("=")) continue;
                kv = optionOverride.split("=");
                optionOverrides.put(kv[0], kv[1]);
            }
        }
        if (!optionOverrides.isEmpty()) {
            opts = ConfigUtils.populateOptionsFromList((StoreFactoryOptions)opts, optionOverrides);
        }
        pluginOptions.selectPlugin(factory.getType());
        pluginOptions.setFactoryOptions(opts);
        return pluginOptions;
    }

    public int getMaxCellSize() {
        return Integer.MAX_VALUE;
    }
}

