/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.locationtech.geowave.test.AccumuloStoreTestEnvironment;
import org.locationtech.geowave.test.BigtableStoreTestEnvironment;
import org.locationtech.geowave.test.CassandraStoreTestEnvironment;
import org.locationtech.geowave.test.DynamoDBStoreTestEnvironment;
import org.locationtech.geowave.test.FileSystemStoreTestEnvironment;
import org.locationtech.geowave.test.HBaseStoreTestEnvironment;
import org.locationtech.geowave.test.KuduStoreTestEnvironment;
import org.locationtech.geowave.test.RedisStoreTestEnvironment;
import org.locationtech.geowave.test.RocksDBStoreTestEnvironment;
import org.locationtech.geowave.test.StoreTestEnvironment;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.TYPE})
public @interface GeoWaveTestStore {
    public GeoWaveStoreType[] value();

    public String namespace() default "mil_nga_giat_geowave_test";

    public String[] options() default {""};

    public static enum GeoWaveStoreType {
        DYNAMODB(DynamoDBStoreTestEnvironment.getInstance()),
        ACCUMULO(AccumuloStoreTestEnvironment.getInstance()),
        BIGTABLE(BigtableStoreTestEnvironment.getInstance()),
        CASSANDRA(CassandraStoreTestEnvironment.getInstance()),
        HBASE(HBaseStoreTestEnvironment.getInstance()),
        KUDU(KuduStoreTestEnvironment.getInstance()),
        REDIS(RedisStoreTestEnvironment.getInstance()),
        ROCKSDB(RocksDBStoreTestEnvironment.getInstance()),
        FILESYSTEM(FileSystemStoreTestEnvironment.getInstance());

        private final StoreTestEnvironment testEnvironment;

        private GeoWaveStoreType(StoreTestEnvironment testEnvironment) {
            this.testEnvironment = testEnvironment;
        }

        public StoreTestEnvironment getTestEnvironment() {
            return this.testEnvironment;
        }
    }
}

